float4x4 mWorldViewProj : WORLDVIEWPROJECTION;

struct VS_INPUT
{
	float3 position : POSITION;
	float3 normal : NORMAL;
	float2 textureCoordinates : TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 position : POSITION;
	float2 textureCoordinates0 : TEXCOORD0;
};

VS_OUTPUT main_vs(const VS_INPUT vertex)
{
	VS_OUTPUT output;

	output.position = mul(float4(vertex.position, 1), mWorldViewProj);
	output.textureCoordinates0 = vertex.textureCoordinates;

	return output;
}
