// Константы
float4 c[8]; // Массив констант, где c0-c7 используются для матриц и других данных
float4 c8;   // Альфа-значение

// Входные данные
struct VS_INPUT
{
    float2 texcoord1 : TEXCOORD1; // v8 в вашем ассемблерном коде
};

// Выходные данные
struct VS_OUTPUT
{
    float4 pos : POSITION;
    float4 color : COLOR0;
    float2 texcoord : TEXCOORD0;
};

// Вершинный шейдер
VS_OUTPUT main(VS_INPUT input)
{
    VS_OUTPUT output;

    // Используем y-координату текстуры для выбора константы
    int index = int(input.texcoord1.y);
    float4 r0 = c[index];

    // Умножение на матрицу view * proj (c4-c7)
    output.pos = mul(r0, transpose(float4x4(c[4], c[5], c[6], c[7])));

    // Передача альфа-значения в цвет
    output.color = c8;

    // Используем x-координату текстуры для выбора текстуры
    index = int(input.texcoord1.x);
    output.texcoord = c[index].xy;

    return output;
}