// Регистры констант:
// c0 - c3: worldMatrix
// c4 - c7: viewProjMatrix
// c8:      colorConstant (альфа-значение)
// c9 - c12: uvConstants
float4x4 worldMatrix    : register(c0);
float4x4 viewProjMatrix : register(c4);
float4   colorConstant  : register(c8);
float4   uvConstants[4] : register(c9);

struct VS_INPUT {
    float blendWeight : BLENDWEIGHT0; // Используем значение blendWeight.x как индекс
    float2 TexCoord   : TEXCOORD0;
};

struct VS_OUTPUT {
    float4 Position : POSITION0;
    float4 Color    : COLOR0;
    float2 TexCoord : TEXCOORD0;
};

VS_OUTPUT main(VS_INPUT input)
{
    VS_OUTPUT output;
    
    // Вместо uint используем int
    int index = (int)input.blendWeight;

    // Загружаем константу по индексу
    float4 posData = uvConstants[index];

    // Трансформация позиции
    float4 worldPos = mul(posData, worldMatrix);
    output.Position = mul(worldPos, viewProjMatrix);
    
    // Передача альфа-значения
    output.Color = colorConstant;
    
    // Передача исходных текстурных координат
    output.TexCoord = input.TexCoord;
    
    return output;
}
