// c0 - c3 : worldMatrix (4 регистров, матрица мира)
// c4 - c7 : viewProjMatrix (4 регистров, матрица view*proj)
// c8      : alphaValue (цвет/альфа, записывается в oD0)
// c9 - c12: набор float4, используемых как массив (uvConstants)
//           - c[a0.x + 9] -> uvConstants[index]
//           - c[a0.x + 10] -> uvConstants[index + 1]
float4x4 worldMatrix    : register(c0);
float4x4 viewProjMatrix : register(c4);
float4   alphaValue     : register(c8);
float4   uvConstants[4] : register(c9);

struct VS_INPUT
{
    // В старых шейдерах (vs.1.1) blendWeight (v1.x) использовался как индекс.
    // Для Shader Model 3.0 и ниже безопаснее привести к int, а не к uint.
    float blendWeight : BLENDWEIGHT0; 
};

struct VS_OUTPUT
{
    float4 Position : POSITION0;
    float4 Color    : COLOR0;
    float2 TexCoord : TEXCOORD0;
};

VS_OUTPUT main(VS_INPUT input)
{
    VS_OUTPUT output;

    // Аналог: mov a0.x, v1.x
    // Индекс для обращения к массиву констант
    int index = (int)input.blendWeight;

    // Аналог: mov r0.xyzw, c[a0.x + 9].xyzw
    // Читаем позиционные данные из uvConstants[index]
    float4 posData = uvConstants[index];

    // Трансформация позиции:
    // m4x4  r4, r0, c0  =>  r4 = mul(posData, worldMatrix)
    // m4x4  oPos, r4, c4 => oPos = mul(r4, viewProjMatrix)
    float4 worldPos = mul(posData, worldMatrix);
    output.Position = mul(worldPos, viewProjMatrix);

    // Аналог: mov oD0, c8
    // Передаём альфа-значение (или цвет) из регистра c8
    output.Color = alphaValue;

    // Аналог: mov oT0.xy, c[a0.x + 10].xy
    // Берём следующий элемент массива для текстурных координат
    float4 uvData = uvConstants[index + 1];
    output.TexCoord = uvData.xy;

    return output;
}
