vs.1.1

; Константные регистры (должны быть установлены перед вызовом)
; c0-c3  = worldMatrix
; c4-c7  = viewProjMatrix
; c8     = alphaValue (цвет/альфа)
; c9-c12 = uvConstants (не используются, но оставляем место)

; Входные данные
dcl_position v0      ; POSITION0 (float3)
dcl_texcoord v1      ; TEXCOORD0 (float2)
dcl_blendindices v2  ; BLENDINDICES0 (не используется, но объявляем)

; 1. Добавляем w=1.0 к позиции (аналог float4(input.Position, 1.0))
mov r0.xyz, v0       ; Копируем xyz
mov r0.w, c13.w      ; Устанавливаем w=1 (c13.w должен быть =1.0)

; 2. Умножаем на мировую матрицу (аналог mul(worldPos, worldMatrix))
m4x4 r1, r0, c0      ; r1 = worldPos

; 3. Умножаем на viewProjMatrix (аналог mul(worldPos, viewProjMatrix))
m4x4 oPos, r1, c4    ; oPos = итоговая позиция

; 4. Устанавливаем цвет (аналог output.Color = alphaValue)
mov oD0, c8          ; oD0 = цвет/альфа

; 5. Передаем текстурные координаты без изменений
mov oT0, v1          ; oT0 = TexCoord