// Регистры констант
float4x4 worldMatrix    : register(c0);       // Матрица мира
float4x4 viewProjMatrix : register(c4);       // Матрица вида + проекция
float4   alphaValue     : register(c8);       // Альфа-значение (или весь цвет)
float4   uvConstants[4] : register(c9);       // Константы UV

struct VS_INPUT {
    float3 Position     : POSITION0;    // Позиция вершины
    float2 TexCoord     : TEXCOORD0;    // Текстурные координаты
    uint   BlendIndices : BLENDINDICES0; // Индексы смешивания
};

struct VS_OUTPUT {
    float4 Position : POSITION0;  // Выходная позиция
    float4 Color    : COLOR0;     // Цвет (или альфа)
    float2 TexCoord : TEXCOORD0;  // Текстурные координаты
};

VS_OUTPUT main(VS_INPUT input)
{
    VS_OUTPUT output;

    // Преобразование позиции в мировое пространство
    float4 worldPos = mul(float4(input.Position, 1.0), worldMatrix);

    // Преобразование в пространство экрана
    output.Position = mul(worldPos, viewProjMatrix);

    // Если alphaValue содержит только альфа-канал, используем его для прозрачности
    // В случае если alphaValue содержит весь цвет, используем его целиком
    output.Color = float4(alphaValue.rgb, alphaValue.a);

    // Преобразование текстурных координат
    output.TexCoord = input.TexCoord;

    return output;
}
