// Регистры констант (аналогично оригинальным настройкам)
float4x4 worldMatrix : register(c0);
float4x4 viewProjMatrix : register(c4);
float4 alphaValue : register(c8);
float4 uvConstants[4] : register(c9);

struct VS_INPUT {
    float3 Position : POSITION0;
    uint BlendIndices : BLENDINDICES0;
};

struct VS_OUTPUT {
    float4 Position : POSITION0;
    float4 Color : COLOR0;
    float2 TexCoord : TEXCOORD0;
};

VS_OUTPUT main(VS_INPUT input)
{
    VS_OUTPUT output;
    
    // Трансформация позиции (аналогично m4x4)
    float4 worldPos = mul(float4(input.Position, 1.0), worldMatrix);
    output.Position = mul(worldPos, viewProjMatrix);
    
    // Передача альфа-значения
    output.Color = alphaValue;
    
    // Выбор UV-координат по индексу (аналог mov a0.x + обращение к константам)
    output.TexCoord = uvConstants[input.BlendIndices].xy;
    
    return output;
}