// Регистры констант (соответствуют оригинальным настройкам)
float4x4 worldMatrix : register(c0);
float4x4 viewProjMatrix : register(c4);
float4 alphaValue : register(c8);

struct VS_INPUT {
    float3 Position : POSITION0;
    float2 TexCoord : TEXCOORD0;
};

struct VS_OUTPUT {
    float4 Position : POSITION0;
    float4 Color : COLOR0;
    float2 TexCoord : TEXCOORD0;
};

VS_OUTPUT main(VS_INPUT input)
{
    VS_OUTPUT output;
    
    // Трансформация позиции (аналогично оригинальным m4x4)
    float4 worldPos = mul(float4(input.Position, 1.0), worldMatrix);
    output.Position = mul(worldPos, viewProjMatrix);
    
    // Передача альфа-значения (аналог mov oD0, c8)
    output.Color = alphaValue;
    
    // Передача текстурных координат без изменений (аналог mov oT0.xy,v7.xy)
    output.TexCoord = input.TexCoord;
    
    return output;
}