// Регистры констант
float4x4 worldMatrix    : register(c0);
float4x4 viewProjMatrix : register(c4);
float4   alphaValue     : register(c8);
float4   uvConstants[4] : register(c9);

struct VS_INPUT {
    float3 Position     : POSITION0;
    float2 TexCoord     : TEXCOORD0;
    uint   BlendIndices : BLENDINDICES0;
};

struct VS_OUTPUT {
    float4 Position : POSITION0;
    float4 Color    : COLOR0;
    float2 TexCoord : TEXCOORD0;
};


VS_OUTPUT main(VS_INPUT input)
{
    VS_OUTPUT output;

    float4 worldPos = mul(float4(input.Position, 1.0), worldMatrix);
    output.Position = mul(worldPos, viewProjMatrix);
    output.Color = alphaValue;

    uint index = input.BlendIndices;

    if (index > 3)
    {
        // Ограничение UV-области (для исключения краев текстуры)
        float2 clampUV = clamp(input.TexCoord, 0.002, 0.998);
        output.TexCoord = clampUV;
    }
    else
    {
        output.TexCoord = uvConstants[index].xy;
    }

    return output;
}
