// Эффект для DirectX 9
// Определение текстуры и сэмплера для использования во всех техниках
texture tex0;		// Первая текстура

sampler s0 = sampler_state
{
	MinFilter = Linear;		// Линейная фильтрация при уменьшении
	MagFilter = Linear;		// Линейная фильтрация при увеличении
	AddressU  = CLAMP;		// Режим адресации по U: CLAMP (зажимание)
	AddressV  = CLAMP;		// Режим адресации по V: CLAMP (зажимание)
};

// Техника t0: отрисовка сцены за один проход
technique t0
{
	pass p0
	{
		PixelShader    = NULL;					// Без пользовательского пиксельного шейдера
		//VertexShader = XYZB1 | Diffuse | Tex1;	// Возможное использование вершинного шейдера (закомментировано)

		ZEnable        = TRUE;					// Включить тест глубины (Z-buffer)
		ZWriteEnable   = FALSE;					// Отключить запись в Z-buffer

		VertexBlend    = Disable;				// Отключить вершинный блендинг

		StencilEnable  = FALSE;					// Отключить стэнсильный буфер
		DitherEnable   = FALSE;					// Отключить дизеринг (сглаживание цвета)
		FogEnable      = FALSE;					// Отключить эффект тумана
		SpecularEnable = FALSE;					// Отключить зеркальное освещение
		//MULTISAMPLEANTIALIAS = TRUE;			// Включить мультисэмплинг (при необходимости)

		CullMode       = None;					// Отключить отсечение граней
		Lighting       = FALSE;					// Отключить расчёт освещения

		Minfilter[0]   = Linear;					// Линейная фильтрация для уменьшения
		Magfilter[0]   = Linear;					// Линейная фильтрация для увеличения

		AddressU[0]    = CLAMP;					// Адресация по U: CLAMP
		AddressV[0]    = CLAMP;					// Адресация по V: CLAMP

		AlphaTestEnable = FALSE;					// Отключить альфа-тест

		AlphaBlendEnable = TRUE;					// Включить альфа-смешивание
		//SrcBlend      = SrcAlpha;				// Источник для альфа-смешивания (закомментировано)
		//DestBlend     = InvSrcAlpha;			// Назначение для альфа-смешивания (закомментировано)

		// Использование сэмплера s0 для привязки текстуры
		//Texture[0]   = <tex0>;
		//Texture[1]   = NULL;

		ColorOp[0]     = Modulate;				// Операция цвета: умножение
		ColorArg1[0]   = Texture;				// Первый аргумент – текстура
		ColorArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		AlphaOp[0]     = Modulate;				// Операция альфа: умножение
		AlphaArg1[0]   = Texture;				// Первый аргумент – текстура
		AlphaArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		ColorOp[1]     = Disable;				// Отключение второй стадии обработки цвета
		AlphaOp[1]     = Disable;				// Отключение второй стадии обработки альфа
	}
}

// Техника t1: отрисовка с записью в Z-буфер (глубину)
technique t1
{
	pass p0
	{
		PixelShader    = NULL;					// Без пользовательского пиксельного шейдера

		ZEnable        = TRUE;					// Включить тест глубины
		ZWriteEnable   = TRUE;					// Записывать значения в Z-buffer

		CullMode       = None;					// Отключить отсечение граней
		Lighting       = FALSE;					// Отключить освещение

		AddressU[0]    = WRAP;					// Адресация по U: WRAP (оборачивание)
		AddressV[0]    = WRAP;					// Адресация по V: WRAP (оборачивание)

		AlphaTestEnable = FALSE;					// Отключить альфа-тест

		AlphaBlendEnable = FALSE;				// Отключить альфа-смешивание

		// Использование сэмплера s0 для текстуры
		//Texture[0]   = <tex0>;
		//Texture[1]   = NULL;

		ColorOp[0]     = Modulate;				// Умножение цвета
		ColorArg1[0]   = Texture;				// Первый аргумент – текстура
		ColorArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		AlphaOp[0]     = Modulate;				// Умножение альфа-канала
		AlphaArg1[0]   = Texture;				// Первый аргумент – текстура
		AlphaArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		ColorOp[1]     = Disable;				// Отключить вторую стадию цвета
		AlphaOp[1]     = Disable;				// Отключить вторую стадию альфа
	}
}

// Техника t2: затенение с альфа-смешиванием
technique t2
{
	pass p0
	{
		PixelShader    = NULL;					// Без пользовательского пиксельного шейдера
		//VertexShader = XYZ | Diffuse | Tex2;	// Возможное использование вершинного шейдера (закомментировано)

		ZEnable        = TRUE;					// Включить тест глубины
		ZWriteEnable   = FALSE;					// Отключить запись в Z-buffer

		VertexBlend    = Disable;				// Отключить вершинный блендинг

		StencilEnable  = FALSE;					// Отключить стэнсильный буфер
		DitherEnable   = FALSE;					// Отключить дизеринг
		FogEnable      = FALSE;					// Отключить туман
		SpecularEnable = FALSE;					// Отключить зеркальное освещение

		CullMode       = None;					// Отключить отсечение граней
		Lighting       = FALSE;					// Отключить освещение

		Minfilter[0]   = Linear;					// Линейная фильтрация для уменьшения
		Magfilter[0]   = Linear;					// Линейная фильтрация для увеличения

		AddressU[0]    = CLAMP;					// Адресация по U: CLAMP
		AddressV[0]    = CLAMP;					// Адресация по V: CLAMP
		//Wrap0       = U|V;					// (Оборачивание – закомментировано)

		AlphaTestEnable = FALSE;					// Отключить альфа-тест
		AlphaBlendEnable = TRUE;					// Включить альфа-смешивание
		//SrcBlend      = SrcAlpha;				// (закомментировано)
		//DestBlend     = InvSrcAlpha;			// (закомментировано)

		// Использование сэмплера s0 для текстуры
		//Texture[0]   = <tex0>;
		//Texture[1]   = NULL;

		ColorOp[0]     = Modulate;				// Моделирование цвета через умножение
		ColorArg1[0]   = Texture;				// Первый аргумент – текстура
		ColorArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		AlphaOp[0]     = Modulate;				// Моделирование альфа через умножение
		AlphaArg1[0]   = Texture;				// Первый аргумент – текстура
		AlphaArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		ColorOp[1]     = Disable;				// Отключить вторую стадию цвета
		AlphaOp[1]     = Disable;				// Отключить вторую стадию альфа
	}
}

// Техника t3: эффекты для частиц
technique t3
{
	pass p0
	{
		PixelShader    = NULL;					// Без пользовательского пиксельного шейдера

		ZEnable        = TRUE;					// Включить тест глубины
		ZWriteEnable   = FALSE;					// Отключить запись в Z-buffer

		VertexBlend    = Disable;				// Отключить вершинный блендинг

		StencilEnable  = FALSE;					// Отключить стэнсильный буфер
		DitherEnable   = FALSE;					// Отключить дизеринг
		FogEnable      = FALSE;					// Отключить туман
		SpecularEnable = FALSE;					// Отключить зеркальное освещение

		CullMode       = None;					// Отключить отсечение граней
		Lighting       = FALSE;					// Отключить освещение

		//Minfilter    = Linear;				// Фильтрация (закомментировано)
		//Magfilter    = Linear;				// Фильтрация (закомментировано)

		AddressU[0]    = CLAMP;					// Адресация по U: CLAMP
		AddressV[0]    = CLAMP;					// Адресация по V: CLAMP

		AlphaTestEnable = FALSE;					// Отключить альфа-тест

		// Альтернативная настройка альфа-теста:
		//AlphaTestEnable = TRUE;
		//AlphaRef      = 0x00;
		//AlphaFunc     = Greater;

		AlphaBlendEnable = TRUE;					// Включить альфа-смешивание

		// Использование сэмплера s0 для текстуры частиц
		//Texture[0]   = <tex0>;
		//Texture[1]   = NULL;

		ColorOp[0]     = Modulate;				// Умножение цвета
		ColorArg1[0]   = Texture;				// Первый аргумент – текстура
		ColorArg2[0]   = TFactor;				// Второй аргумент – коэффициент текстуры

		AlphaOp[0]     = Modulate;				// Умножение альфа-канала
		AlphaArg1[0]   = Texture;				// Первый аргумент – текстура
		AlphaArg2[0]   = TFactor;				// Второй аргумент – коэффициент текстуры

		ColorOp[1]     = Disable;				// Отключить вторую стадию цвета
		AlphaOp[1]     = Disable;				// Отключить вторую стадию альфа
	}
}

// Техника t4: затенение с альфа-тестом и альфа-смешиванием
technique t4
{
	pass p0
	{
		PixelShader    = NULL;					// Без пользовательского пиксельного шейдера
		//VertexShader = XYZ | Diffuse | Tex2;	// Возможное использование вершинного шейдера (закомментировано)

		ZEnable        = TRUE;					// Включить тест глубины
		ZWriteEnable   = FALSE;					// Отключить запись в Z-buffer

		VertexBlend    = Disable;				// Отключить вершинный блендинг

		StencilEnable  = FALSE;					// Отключить стэнсильный буфер
		DitherEnable   = FALSE;					// Отключить дизеринг
		FogEnable      = FALSE;					// Отключить туман
		SpecularEnable = FALSE;					// Отключить зеркальное освещение

		CullMode       = None;					// Отключить отсечение граней
		Lighting       = FALSE;					// Отключить освещение

		Minfilter[0]   = Linear;					// Линейная фильтрация для уменьшения
		Magfilter[0]   = Linear;					// Линейная фильтрация для увеличения

		AddressU[0]    = WRAP;					// Адресация по U: WRAP (оборачивание)
		AddressV[0]    = WRAP;					// Адресация по V: WRAP (оборачивание)
		//Wrap0       = U|V;					// (закомментировано)

		AlphaTestEnable = TRUE;					// Включить альфа-тест
		AlphaRef       = 0xff000000;				// Референсное значение для альфа-теста
		AlphaFunc      = NOTEQUAL;				// Функция теста: не равно

		AlphaBlendEnable = TRUE;					// Включить альфа-смешивание
		//SrcBlend      = SrcAlpha;				// (закомментировано)
		//DestBlend     = InvSrcAlpha;			// (закомментировано)

		// Использование сэмплера s0 для текстуры
		//Texture[0]   = <tex0>;
		//Texture[1]   = NULL;

		ColorOp[0]     = Modulate;				// Умножение цвета
		ColorArg1[0]   = Texture;				// Первый аргумент – текстура
		ColorArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		AlphaOp[0]     = Modulate;				// Умножение альфа-канала
		AlphaArg1[0]   = Texture;				// Первый аргумент – текстура
		AlphaArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		ColorOp[1]     = Disable;				// Отключить вторую стадию цвета
		AlphaOp[1]     = Disable;				// Отключить вторую стадию альфа
	}
}

// Техника t5: состояние для отрисовки шрифта
technique t5
{
	pass p0
	{
		PixelShader    = NULL;					// Без пользовательского пиксельного шейдера
		//VertexShader = XYZ | Diffuse | Tex2;	// Возможное использование вершинного шейдера (закомментировано)

		ZEnable        = FALSE;					// Отключить тест глубины
		ZWriteEnable   = FALSE;					// Не записывать в Z-buffer

		VertexBlend    = Disable;				// Отключить вершинный блендинг

		StencilEnable  = FALSE;					// Отключить стэнсильный буфер
		DitherEnable   = FALSE;					// Отключить дизеринг
		FogEnable      = FALSE;					// Отключить туман
		SpecularEnable = FALSE;					// Отключить зеркальное освещение

		//CLIPPLANEENABLE = FALSE;				// (закомментировано, если требуется)
		Clipping       = FALSE;					// Отключить клиппинг
		FOGENABLE      = FALSE;					// Отключить туман

		SHADEMODE      = FLAT;					// Режим затенения: плоский

		CullMode       = CCW;					// Отсечение по CCW (против часовой стрелки)
		Lighting       = FALSE;					// Отключить освещение

		Minfilter[0]   = Point;					// Точечная фильтрация для уменьшения
		Magfilter[0]   = Point;					// Точечная фильтрация для увеличения

		AddressU[0]    = CLAMP;					// Адресация по U: CLAMP
		AddressV[0]    = CLAMP;					// Адресация по V: CLAMP

		AlphaTestEnable = FALSE;					// Отключить альфа-тест
		AlphaBlendEnable = TRUE;					// Включить альфа-смешивание
		SrcBlend       = SrcAlpha;				// Источник альфа
		DestBlend      = InvSrcAlpha;			// Обратная альфа

		// Использование сэмплера s0 для текстуры шрифта
		//Texture[0]   = <tex0>;
		//Texture[1]   = NULL;

		ColorOp[0]     = Modulate;				// Умножение цвета
		ColorArg1[0]   = Texture;				// Первый аргумент – текстура
		ColorArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		AlphaOp[0]     = Modulate;				// Умножение альфа-канала
		AlphaArg1[0]   = Texture;				// Первый аргумент – текстура
		AlphaArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		ColorOp[1]     = Disable;				// Отключить вторую стадию цвета
		AlphaOp[1]     = Disable;				// Отключить вторую стадию альфа
	}
}

// Техника t6: отрисовка контура шрифта (комментарии)
technique t6
{
	pass p0
	{
		PixelShader    = NULL;					// Без пользовательского пиксельного шейдера
		//VertexShader = XYZ | Diffuse | Tex2;	// Возможное использование вершинного шейдера (закомментировано)

		ZEnable        = FALSE;					// Отключить тест глубины
		ZWriteEnable   = FALSE;					// Не записывать в Z-buffer

		VertexBlend    = Disable;				// Отключить вершинный блендинг

		StencilEnable  = FALSE;					// Отключить стэнсильный буфер
		DitherEnable   = FALSE;					// Отключить дизеринг
		FogEnable      = FALSE;					// Отключить туман
		SpecularEnable = FALSE;					// Отключить зеркальное освещение

		SHADEMODE      = Flat;					// Режим затенения: плоский

		CullMode       = CCW;					// Отсечение по CCW (против часовой стрелки)
		Lighting       = FALSE;					// Отключить освещение

		Minfilter[0]   = Point;					// Точечная фильтрация для уменьшения
		Magfilter[0]   = Point;					// Точечная фильтрация для увеличения

		AddressU[0]    = WRAP;					// Адресация по U: WRAP (оборачивание)
		AddressV[0]    = WRAP;					// Адресация по V: WRAP (оборачивание)

		AlphaTestEnable = FALSE;					// Отключить альфа-тест
		AlphaBlendEnable = TRUE;					// Включить альфа-смешивание
		SrcBlend       = SrcAlpha;				// Источник альфа
		DestBlend      = InvSrcAlpha;			// Обратная альфа

		// Использование сэмплера s0 для текстуры контура шрифта
		//Texture[0]   = <tex0>;
		//Texture[1]   = NULL;

		ColorOp[0]     = Modulate;				// Умножение цвета
		ColorArg1[0]   = Texture;				// Первый аргумент – текстура
		ColorArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		AlphaOp[0]     = Modulate;				// Умножение альфа-канала
		AlphaArg1[0]   = Texture;				// Первый аргумент – текстура
		AlphaArg2[0]   = Diffuse;				// Второй аргумент – диффузный цвет

		ColorOp[1]     = Disable;				// Отключить вторую стадию цвета
		AlphaOp[1]     = Disable;				// Отключить вторую стадию альфа
	}
}
