--     
function GenFormSkills()
	local form = L_SetForm({
		system_name	= "frmSkill",
		arr_size	= {251, 368},
		arr_area	= {472, 160},
		text_title	= lstr(877)
	})
	
	GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_S, MACROS_SKILLS) 
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_SetIsDrag(form, TRUE)
	
	--   
	local imgNumber = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgNumber", 233, 302, 9, 45)
	GML_UI_LoadImage(imgNumber, "texture/ui_morgan/skills/skills_panel_bg.png", NORMAL, 233, 302, 0, 0)
	
	
	local a_tabs = {
		[1] = {tab_name = lstr(878), sys_name = "lstSkill", a_pos = {1, -45-7}, sys_name_points = "labPoint", lab_name_points = lstr(881)}, -- 
		[2] = {tab_name = lstr(879), sys_name = "lstSkillW", a_pos = {71 + 3 + 3, -45-7}, sys_name_points = "labPoint1", lab_name_points = lstr(882)}, -- 
		[3] = {tab_name = lstr(880), sys_name = "lstSkillS", a_pos = {141 + 6 + 6, -45-7}}, -- 
	}
	-- 
	local pgeSkill = GML_UI_CreateCompent(form, PAGE_TYPE, "pgeSkill", 211 + 10, 233 - 5, 11, 79)
	GML_UI_SetPageButton(pgeSkill, PAGE_BUTTON_CUSTOM, 48, 16)
	
	for _i, _tab_data in ipairs(a_tabs) do
		local _tab = GML_UI_CreateCompent(form, SKILL_LIST_TYPE, _tab_data.sys_name, 211 + 14, 283 + 15, 13 - 8, -10 -19)
		GML_UI_SetMargin(_tab, 0, 0, 0, 5)
		GML_UI_SetListRowHeight(_tab, 37)
		
		-- 
		GML_UI_LoadSkillListButtonImage(_tab, "texture/ui_morgan/buttons_14X14.png", 14, 14, 0, 14, 14, 14)
		
		-- 
		L_DrawScroll(_tab)
		
		local skillid	= GML_UI_CreatePageItem(pgeSkill)
		local ttlBattle	= GML_UI_GetPageItemObj(skillid, PAGE_ITEM_TITLE)
		GML_UI_LoadImage(ttlBattle, "texture/ui_morgan/btn_tabs.png", PAGE_ITEM_TITLE_NORMAL, 73, 18, 0, 0)
		GML_UI_LoadImage(ttlBattle, "texture/ui_morgan/btn_tabs.png", PAGE_ITEM_TITLE_ACTIVE, 73, 18, 0, 18)
		GML_UI_SetPos(ttlBattle, _tab_data.a_pos[1], _tab_data.a_pos[2])
		GML_UI_SetSize(ttlBattle, 73, 18)
		GML_UI_AddCompent(skillid, _tab)
		
		-- 
		L_Text(form, {
			--system_name	= "labInfoSinmara",
			arr_size	= {73, 12},
			arr_area	= {12 + ((_i - 1) * (73 + 3)), 31},
			hint		= "",
			
			arr_text	= {
				text			= _tab_data.tab_name, 
				--font			= FONT14,
				--color			= COLOR_GRAY,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				center		= 1,
				--right	= 1,
			}
		})
		
		--  
		if _tab_data.sys_name_points then
			local _points_lab = L_Text(form, {
				--system_name	= "labInfoSinmara",
				arr_size	= {125, 12},
				arr_area	= {50 - 2 - 4 + 1, 350 - 80},
				hint		= "",
				
				arr_text	= {
					text			=_tab_data.lab_name_points, 
					--font			= FONT14,
					--color			= COLOR_GRAY,
					shadow		= FALSE,
					--shadow_color	= COLOR_WHITE,
					--center		= 1,
					right	= 1,
				}
			})
			
			
			local _points_val = L_Text(form, {
				system_name	= _tab_data.sys_name_points,
				arr_size	= {17, 12},
				arr_area	= {177- 5, 350 - 79 + 0},
				hint		= "",
				
				arr_text	= {
					text			= 0, 
					--font			= FONT14,
					--color			= COLOR_GRAY,
					shadow		= FALSE,
					--shadow_color	= COLOR_WHITE,
					--center		= 1,
					--right	= 1,
				}
			})
		
			GML_UI_AddCompent(skillid, _points_lab)
			GML_UI_AddCompent(skillid, _points_val)
		end
	end

	return form
end
GenFormSkills()
