--  (Esc)
function GenFormOptions()
	local form = L_SetForm({
		system_name	= "f_options",
		arr_size	= {204, 295 + 26},
		arr_area	= {208, 160},
		text_title	= lstr(258)
	})
	
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_O)
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, 1)
	GML_UI_SetIsDrag(form, TRUE)
	GML_UI_SetFormStyle(form, 0)
	
	
	local arr_menu = {
		{
			{btn_name = lstr(259), hint = lstr(260), btn_system_name = "f_opts_b_settings"},
		},
		{
			{btn_name = lstr(261), hint = lstr(262), btn_system_name = "f_opts_b_supports"},
			{btn_name = lstr(831), hint = lstr(832), btn_system_name = "f_opts_b_supports_tg"},
		},
		{
			{btn_name = lstr(263), hint = lstr(264), btn_system_name = "f_opts_b_gamedb"},
			{btn_name = lstr(265), hint = lstr(266), btn_system_name = "f_opts_b_danjtime"},
			{btn_name = lstr(267), hint = lstr(268), btn_system_name = "f_opts_b_bonuscode"},
		},
		{
			{btn_name = lstr(269), hint = lstr(270), btn_system_name = "f_opts_b_elsecha"},
			{btn_name = lstr(271), hint = lstr(272), btn_system_name = "f_opts_b_disconnect"},
			{btn_name = lstr(273), hint = lstr(274), btn_system_name = "f_opts_b_exit"},
		},
	}
	
	local margin_top = 32
	
	for i = 1, #arr_menu do
		local block_height = 28
		if #arr_menu[i] > 1 then
			block_height = block_height - 1
		end
		
		-- 
		L_CreateBG({
			form_name = form, arr_pos_area = {10, margin_top}, arr_size = {184, block_height * #arr_menu[i]}
		})
		
		for i2 = 1, #arr_menu[i] do
			if i2 > 1 then
				--  
				local hr_line = GML_UI_CreateCompent(form, IMAGE_TYPE, "hr_line", 182, 1, 11, margin_top)
				GML_UI_LoadImage(hr_line, "texture/ui_morgan/settings/game_settings_2.png", NORMAL, 10, 1, 0, 248) 
				GML_UI_SetImageAlpha(hr_line, 130)
			end
			
			
			-- 
			L_Text(form, {
				--system_name	= "labInfoSinmara",
				arr_size	= {168, 17},
				arr_area	= {20, margin_top + 8},
				hint		= "",
				
				arr_text	= {
					text			= arr_menu[i][i2].btn_name, 
					--font			= FONT14,
					--color			= COLOR_GRAY,
					shadow		= FALSE,
					--shadow_color	= COLOR_WHITE,
					--center		= 1,
					--right	= 1,
				}
			})
			
			-- 
			local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, arr_menu[i][i2].btn_system_name, 182, 26, 11, margin_top + 1)
			if arr_menu[i][i2].hint then
				GML_UI_SetHint(btn, arr_menu[i][i2].hint)
			end
			local btn_texture_name = "btn_select_options.png"
			if i2 > 1 and i2 ~= #arr_menu[i] then
				btn_texture_name = "btn_select_options_center.png"
			elseif i2 > 1 and i2 == #arr_menu[i] then
				btn_texture_name = "btn_select_options_bottom.png"
			elseif #arr_menu[i] > 1 and i2 == 1 then
				btn_texture_name = "btn_select_options_top.png"
			end
			
			if #arr_menu > 1 then
				margin_top = margin_top - 1
			end
			
			GML_UI_LoadButtonImage(btn, "texture/ui_morgan/options/"..btn_texture_name, 182, 26, 0, 0, TRUE)
			
			if arr_menu[i][i2].btn_system_name == "f_opts_b_supports" then
				GML_UI_AddButtonLink(btn, "https://vk.com/im?sel=-124513133")
			end
			
			if arr_menu[i][i2].btn_system_name == "f_opts_b_supports_tg" then
				GML_UI_AddButtonLink(btn, "https://t.me/piratia_pw")
			end
			
			margin_top = margin_top + 28
		end
		
		margin_top = margin_top + 5
	end
	
	----
	--  
	----
	
	-- telegram
	local f_opts_b_telegram = GML_UI_CreateCompent(form, BUTTON_TYPE, "f_opts_b_telegram", 14, 14, 76 + ((14 + 5) * 0), margin_top + 2)
	GML_UI_LoadButtonImage(f_opts_b_telegram, "texture/ui_morgan/form/social.png", 14, 14, 0, 0, TRUE)
	GML_UI_AddButtonLink(f_opts_b_telegram, "https://t.me/gisgames")
	
	-- vk
	local f_opts_b_vk = GML_UI_CreateCompent(form, BUTTON_TYPE, "f_opts_b_vk", 14, 14, 76 + ((14 + 5) * 1), margin_top+ 2)
	GML_UI_LoadButtonImage(f_opts_b_vk, "texture/ui_morgan/form/social.png", 14, 14, 0, 14, TRUE)
	GML_UI_AddButtonLink(f_opts_b_vk, "https://vk.com/piratiapw")
	
	-- discord
	local f_opts_b_discord = GML_UI_CreateCompent(form, BUTTON_TYPE, "f_opts_b_discord", 14, 14, 76 + ((14 + 5) * 2), margin_top+ 2)
	GML_UI_LoadButtonImage(f_opts_b_discord, "texture/ui_morgan/form/social.png", 14, 14, 0, 28, TRUE)
	GML_UI_AddButtonLink(f_opts_b_discord, "https://discord.gg/EKCKbbev4M")
end
GenFormOptions()


A_SETTINGS = {
	{
		title	= lstr(276),
		title_2	= lstr(869),
		points	= {
			--  
			{
				title		= lstr(277),
				type		= "select",
				system_name	= "slctQuality",
				points		= {lstr(278), lstr(279), lstr(280)},
				hint		= lstr(281)
			},
			
			--  
			{
				title		= lstr(282),
				type		= "select",
				system_name	= "slctTexture",
				points		= {lstr(278), lstr(279), lstr(280)},
				hint		= lstr(283)
			},
			
			--  
			{
				title		= lstr(284),
				type		= "select",
				system_name	= "slctPixelDisplay",
				points		= {"19201080", "1600900", "1440900", "1360768", "1280800", "1024760", "986600", "800600", "720500"}
			},
			
			--   
			{
				title		= lstr(285),
				type		= "checkbox",
				system_name = "cbxModel",
				points		= {lstr(286), lstr(287)}
			},
		
			--   (FPS)
			{
				title		= lstr(288),
				type		= "checkbox",
				system_name = "cbxFPS",
				points		= {"60", "30"},
				
			},
			
			--  
			{
				title		= lstr(289),
				type		= "checkbox",
				system_name = "cbxColor",
				points		= {"32", "16"},
				hint		= lstr(290)
			},
			
			--   
			{
				title		= lstr(291),
				type		= "checkbox",
				system_name = "cbxTrail",
				points		= {lstr(286), lstr(287)},
				hint		= lstr(292)
			},
			
			--  
			{
				title		= lstr(293),
				type		= "checkbox",
				system_name = "cbxShowEffect",
				points		= {lstr(286), lstr(287)},
				hint		= lstr(300)
			},
			
			--  
			{
				title		= lstr(294),
				type		= "checkbox",
				system_name = "cbxShowGlow",
				points		= {lstr(286), lstr(287)},
				hint		= lstr(300),
				
			},
			
			--  
			{
				title		= lstr(295),
				type		= "slider",
				system_name = "slider_view_map",
				hint		= lstr(296)
			},
			
	
		}
	},
	
	{
		title	= lstr(297),
		title_2	= lstr(870),
		points	= {
			--  
			{
				title		= lstr(298),
				type		= "slider",
				system_name = "proAudioMusic",
			},
	
			--  
			{
				title		= lstr(299),
				type		= "slider",
				system_name = "proAudioMidi",
			},
			
			--  
			{
				title		= lstr(763),
				type		= "slider",
				system_name = "proAudioVoice",
			},
			
		}
	},
	
	{
		title	= lstr(301),
		title_2	= lstr(871),
		points	= {
			-- 
			{
				title		= lstr(302),
				type		= "select",
				system_name	= "slctCam",
				points		= {lstr(303), lstr(304), lstr(305),},
				hint		= lstr(306)
			},
			
			--  
			{
				title		= lstr(766),
				type		= "select",
				system_name	= "slctCamControl",
				points		= {lstr(767), lstr(768)},
				hint		= lstr(769)
			},
			
			--    
			{
				title		= lstr(307),
				type		= "checkbox",
				system_name = "cbxSafeCameraTP",
				points		= {lstr(286), lstr(287)},
				hint		= lstr(308)
			},
			
			
			--  ()
			{
				title		= lstr(309),
				type		= "checkbox",
				system_name = "cbxAnimation",
				points		= {lstr(286), lstr(287)},
				hint		= lstr(310)
			},
			
			--   
			-- {
			-- 	title		= lstr(833),
			-- 	type		= "slider",
			-- 	system_name = "slider_anim_speed",
			-- 	hint		= lstr(834)
			-- },
			
			--    
			{
				title		= lstr(770),
				type		= "select",
				system_name = "slctMonsterHPDisplay",
				points		= {lstr(771), lstr(772), lstr(773)},
				hint		= lstr(774)
			},
			
			--    
			{
				title		= lstr(775),
				type		= "select",
				system_name = "slctCharacterHPDisplay",
				points		= {lstr(776), lstr(777), lstr(778)},
				hint		= lstr(779)
			},
			
			
			--  
			{
				title		= lstr(311),
				type		= "checkbox",
				system_name = "cbxShowStallName",
				points		= {lstr(286), lstr(287)},
				hint		= lstr(312)
			},
			
			--   ( )
			{
				title		= lstr(313),
				type		= "checkbox",
				system_name = "cbxShowIconEffects",
				points		= {lstr(286), lstr(287)}
			},
			
			--   ()
			{
				title		= lstr(812),
				type		= "checkbox",
				system_name = "cbxShowIconEffectsParty",
				points		= {lstr(286), lstr(287)}
			},
			
			--    Shift
			{
				title		= lstr(314),
				type		= "checkbox",
				system_name = "cbxShowHeadSay",
				points		= {lstr(286), lstr(287)},
				hint		= lstr(300),
			},
			
			--    Shift
			{
				title		= lstr(315),
				type		= "checkbox",
				system_name = "cbxShowItemsName",
				points		= {lstr(286), lstr(287)},
				hint		= lstr(316)
			},
			
			--    Shift
			{
				title		= lstr(317),
				type		= "checkbox",
				system_name = "cbxShowStackItem",
				points		= {lstr(286), lstr(287)}
			},
			
			--   
			{
				title		= lstr(318),
				type		= "checkbox",
				system_name = "cbxShowShowQuest",
				points		= {lstr(286), lstr(287)},
				hint		= lstr(319)
			},
		}
	},
	{
		title	= lstr(835),
		title_2	= lstr(872),
		points	= {
			--  
			{
				title		= lstr(827),
				type		= "select",
				system_name	= "slctBtnSkill",
				points		= {lstr(828), lstr(829)},
				hint		= lstr(830)
			},
			
			-- 
			{
				title		= lstr(836),
				default		= "E",
				type		= "enter",
				system_name	= "macros_setting_1",
				hint		= lstr(837)
			},
			
			--  
			{
				title		= lstr(842),
				default		= "D",
				type		= "enter",
				system_name	= "macros_setting_2",
				hint		= lstr(843)
			},
			
			-- 
			{
				title		= lstr(854),
				default		= "G",
				type		= "enter",
				system_name	= "macros_setting_3",
				hint		= lstr(855)
			},
			
			-- 
			{
				title		= lstr(850),
				default		= "A",
				type		= "enter",
				system_name	= "macros_setting_4",
				hint		= lstr(851)
			},
			
			-- 
			{
				title		= lstr(840),
				default		= "S",
				type		= "enter",
				system_name	= "macros_setting_5",
				hint		= lstr(841)
			},
			
			-- 
			{
				title		= lstr(844),
				default		= "Q",
				type		= "enter",
				system_name	= "macros_setting_6",
				hint		= lstr(845)
			},
			
			-- 
			{
				title		= lstr(848),
				default		= "R",
				type		= "enter",
				system_name	= "macros_setting_7",
				hint		= lstr(849)
			},
			
			--  
			{
				title		= lstr(846),
				default		= "M",
				type		= "enter",
				system_name	= "macros_setting_8",
				hint		= lstr(847)
			},
			
			-- 
			{
				title		= lstr(892),
				default		= "C",
				type		= "enter",
				system_name	= "macros_setting_16",
				hint		= lstr(893)
			},
			
			--  
			{
				title		= lstr(852),
				default		= "F",
				type		= "enter",
				system_name	= "macros_setting_9",
				hint		= lstr(853)
			},
			
			--  
			{
				title		= lstr(856),
				default		= "H",
				type		= "enter",
				system_name	= "macros_setting_10",
				hint		= lstr(857)
			},
			
			--  
			{
				title		= lstr(858),
				default		= "J",
				type		= "enter",
				system_name	= "macros_setting_11",
				hint		= lstr(859)
			},
			
			--  
			{
				title		= lstr(862),
				default		= "N",
				type		= "enter",
				system_name	= "macros_setting_12",
				hint		= lstr(863)
			},
			
			--  
			{
				title		= lstr(860),
				default		= "B",
				type		= "enter",
				system_name	= "macros_setting_13",
				hint		= lstr(860)
			},
			
			-- 
			{
				title		= lstr(864),
				default		= "O",
				type		= "enter",
				system_name	= "macros_setting_14",
				hint		= lstr(865)
			},
			
			-- / 
			{
				title		= lstr(883),
				default		= "Ins",
				type		= "enter",
				system_name	= "macros_setting_15",
				hint		= lstr(884)
			},
			
		}
	},
}


-- 
function GenFormVideoSettings()
	local arr_items_settings = A_SETTINGS
	local settings_row__max_count = 0
	for _i = 1, #arr_items_settings do
		if #arr_items_settings[_i].points > settings_row__max_count then
			settings_row__max_count = #arr_items_settings[_i].points
		end
	end
	
	
	local width_left_menu = 189-63
	local form = L_SetForm({
		system_name	= "frmVideo",
		arr_size	= {434 + width_left_menu, 46 + (settings_row__max_count * 22) + 37},
		arr_area	= {208, 160},
		text_title	= lstr(275)
	})
	
	GML_UI_ShowForm(form, FALSE )
	GML_UI_AddFormToTemplete(form, 1 )
	GML_UI_SetIsDrag(form, TRUE )
	GML_UI_SetFormStyle(form, 0 )
	GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_O, MACROS_SETTINGS)
	
	
	

	
	-- 
	local cpt_tabs = GML_UI_CreateCompent(form, PAGE_TYPE, "f_video_tabs", 236-63, 314, 0, 0)
	--GML_UI_SetPageButton(pgeNPCtrade, PAGE_BUTTON_CUSTOM, 39, 19)
	
	local margin_top = 32
	
	for i = 1, #arr_items_settings do
		local block_height = 28
		
		-- 
		L_CreateBG({
			form_name = form, arr_pos_area = {10, margin_top}, arr_size = {184 -63, block_height}
		})
		
		
		-- 
		L_Text(form, {
			--system_name	= "labInfoSinmara",
			arr_size	= {168-63, 17},
			arr_area	= {20, margin_top + 8},
			hint		= "",
			
			arr_text	= {
				text			= arr_items_settings[i].title, 
				--font			= FONT14,
				--color			= COLOR_GRAY,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				--center		= 1,
				--right	= 1,
			}
		})
		
		-- 
		local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "f_video_btn_tab_"..i, 182-63, 26, 11, margin_top + 1)
		GML_UI_LoadButtonImage(btn, "texture/ui_morgan/options/btn_select_options_mini.png", 182-63, 26, 0, 0, TRUE)
		
		margin_top = margin_top + 5 + 28
	end
	

	
	local arr_tabs = {}
	
	local arr_selects = {}
	
	local height_header = 22
	local max_gen_heigth_form = height_header
	for type_settings = 1, #arr_items_settings do
		local gen_height_form = height_header + 10
		local tab = GML_UI_CreatePageItem(cpt_tabs, 0)
		table.insert(arr_tabs, tab)
		
		---- 
		--L_CreateBG({
		--	form_name = form, arr_pos_area = {10, gen_height_form}, arr_size = {414, #arr_items_settings[type_settings].points * 24 + 10}
		--})
		

		
		--gen_height_form = gen_height_form + 2
		--   
		local text = L_Text(form, {
			--system_name	= "labPrice",
			arr_size	= {80+ 50, 17},
			arr_area	= {19 + width_left_menu, gen_height_form},
			
			arr_text	= {
				text			= arr_items_settings[type_settings].title_2,
				--font			= ITEMS_NAME,
				color			= COLOR_GRAY3,
				shadow			= FALSE,
				--shadow_color	= COLOR_WHITE,
				--center		= 1,
				--right			= 1,
			}
		})
		
		GML_UI_AddCompent(arr_tabs[type_settings], text)
		
		--  
		local hr_line = GML_UI_CreateCompent(form, IMAGE_TYPE, "hr_line", 351+ 50, 1, 16 + width_left_menu, gen_height_form + 14)
		GML_UI_AddCompent(arr_tabs[type_settings], hr_line)
		GML_UI_LoadImage(hr_line, "texture/ui_morgan/settings/game_settings_2.png", NORMAL, 10, 1, 0, 248) 
		GML_UI_SetImageAlpha(hr_line, 130)
		--     
		gen_height_form = gen_height_form + 20
		
		for i = 1, #arr_items_settings[type_settings].points do
			local arr_data_point	= arr_items_settings[type_settings].points[i]
			
			local text = L_Text(form, {
				system_name	= "item_settings_"..i,
				arr_size	= {270, 17},
				arr_area	= {19 + width_left_menu, gen_height_form},
				hint		= arr_data_point.hint or "",
				
				arr_text	= {
					text			= arr_data_point.title,
					--font			= ITEMS_NAME,
					--color			= COLOR_GRAY3,
					shadow			= FALSE,
					--shadow_color	= COLOR_WHITE,
					--center		= 1,
					--right			= 1,
				}
			})
			GML_UI_AddCompent(arr_tabs[type_settings], text)
			--local item_settings		= GML_UI_CreateCompent(form, LABELEX_TYPE, "item_settings_"..i, 10, 10, 19 + width_left_menu, gen_height_form)
			--GML_UI_AddCompent(arr_tabs[type_settings], item_settings)
			--GML_UI_SetCaption(item_settings, tostring(arr_data_point.title))
			--GML_UI_SetTextColor(item_settings, COLOR_WHITE)
			--GML_UI_SetLabelExFont(item_settings, DEFAULT_FONT, FALSE, COLOR_WHITE)
			--hint		= arr_items_settings[type_settings].hint or "",
			

			
			if arr_data_point.type == "checkbox" then
				local check_box_group = GML_UI_CreateCompent(form, CHECK_GROUP_TYPE, arr_data_point.system_name, 0, 0, 0, 0 )
				GML_UI_AddCompent(arr_tabs[type_settings], check_box_group)
				for i2 = 1, #arr_data_point.points do
					--  
					local check_box_title = GML_UI_CreateCompent(form, LABELEX_TYPE, "check_box_title"..i.."_"..i2, 14, 14, 330 + (55 * (i2 - 1)) + width_left_menu, gen_height_form - 1)
					GML_UI_AddCompent(arr_tabs[type_settings], check_box_title)
					GML_UI_SetCaption(check_box_title, arr_data_point.points[i2])
					GML_UI_SetTextColor(check_box_title, COLOR_WHITE)
					GML_UI_SetLabelExFont(check_box_title, DEFAULT_FONT, FALSE, COLOR_WHITE)
					
					-- 
					local check_box = GML_UI_CreateCompent(form, CHECK_TYPE, "cbx_"..i.."_"..i2, 42, 13, 314 + (55 * (i2 - 1)) + width_left_menu, gen_height_form - 1)
					GML_UI_AddCompent(arr_tabs[type_settings], check_box)
					GML_UI_LoadImage(check_box, "texture/ui_morgan/settings/btn_checkbox.png", UNCHECKED, 42, 13, 0, 13)
					GML_UI_LoadImage(check_box, "texture/ui_morgan/settings/btn_checkbox.png", CHECKED, 42, 13, 0, 0)
					GML_UI_AddGroupBox(check_box_group, check_box)
				end
			elseif arr_data_point.type == "select" then
				
				local arr_select = {
					system_name		= arr_data_point.system_name,
					title			= arr_data_point.title,
					arr_area		= {316 + width_left_menu, gen_height_form - 1},
					arr_size		= {96, 200},
					points			= arr_data_point.points,
					type_settings	= type_settings
				}
				
				table.insert(arr_selects, arr_select)	
			elseif arr_data_point.type == "enter" then
				
				if arr_data_point.default then
					local text = L_Text(form, {
						--system_name	= "macros_lab_" + i,
						arr_size	= {40, 17},
						arr_area	= {270 + width_left_menu, gen_height_form + 1},
						
						arr_text	= {
							text			= arr_data_point.default,
							--font			= ITEMS_NAME,
							color			= COLOR_GRAY3,
							shadow			= FALSE,
							--shadow_color	= COLOR_WHITE,
							center		= 1,
							--right			= 1,
						}
					})
					
					GML_UI_AddCompent(arr_tabs[type_settings], text)
				end
				
				-- 
				local a_cpt = L_CreateBG({
					form_name = form, arr_pos_area = {312 + width_left_menu, gen_height_form - 3}, arr_size = {102, 17}
				})
				
				for i = 1, #a_cpt do
					GML_UI_AddCompent(arr_tabs[type_settings], a_cpt[i])
				end
				
				-- 
				local text_btn_macros = L_Text(form, {
					system_name	= arr_data_point.system_name.."_text",
					arr_size	= {102, 17},
					arr_area	= {312 + width_left_menu, gen_height_form},
					hint		= lstr(839),
					
					arr_text	= {
						text			= lstr(838), 
						--font			= FONT14,
						color			= COLOR_GRAY,
						shadow		= FALSE,
						--shadow_color	= COLOR_WHITE,
						center		= 1,
						--right	= 1,
					}
				})
				GML_UI_AddCompent(arr_tabs[type_settings], text_btn_macros)
		
				-- 
				local btn_macros = GML_UI_CreateCompent(form, BUTTON_TYPE, arr_data_point.system_name, 102, 17, 312 + width_left_menu, gen_height_form - 3)
				GML_UI_AddCompent(arr_tabs[type_settings], btn_macros)
			elseif arr_data_point.type == "slider" then
				local text = L_Text(form, {
					system_name	= arr_data_point.system_name.."_txtprc",
					arr_size	= {10, 17},
					arr_area	= {255 - 23 + 38 - 50 + 54 + width_left_menu + 30, gen_height_form + 1},
					--hint		= "",
					
					arr_text	= {
						text			= "0%",
						font			= MINI_FONT,
						color			= COLOR_GRAY3,
						shadow			= FALSE,
						--shadow_color	= COLOR_WHITE,
						--center		= 1,
						right			= 1,
					}
				})
				
				GML_UI_AddCompent(arr_tabs[type_settings], text)
		
				-- 
				local img = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 181 - 38 - 15 - 30, 15, 255 - 23 + 38 + 15 + width_left_menu+ 30, gen_height_form - 1- 1)
				GML_UI_AddCompent(arr_tabs[type_settings], img)
				GML_UI_LoadImage(img, "texture/ui_morgan/settings/p_bar_bg.png", NORMAL, 181, 15, 0, 0)
				
				local slider = GML_UI_CreateCompent( form, PROGRESS_TYPE, arr_data_point.system_name, 177 - 38 - 15- 30, 11, 255 - 21 + 38 + 15 + width_left_menu+ 30, gen_height_form + 1- 1)
				GML_UI_AddCompent(arr_tabs[type_settings], slider)
				GML_UI_LoadScaleImage(slider, "texture/ui_morgan/settings/p_bar.png", PROGRESS_PROGRESS, 177 - 38 - 15- 30, 11, 0, 0, 1.0, 1.0)
				GML_UI_SetProgressActiveMouse(slider, 1)
			end
			
			--  
			local hr_line = GML_UI_CreateCompent(form, IMAGE_TYPE, "hr_line", 351+ 50, 1, 16 + width_left_menu, gen_height_form + 16)
			GML_UI_AddCompent(arr_tabs[type_settings], hr_line)
			GML_UI_LoadImage(hr_line, "texture/ui_morgan/settings/game_settings_2.png", NORMAL, 10, 1, 0, 248) 
			GML_UI_SetImageAlpha(hr_line, 130)
			gen_height_form = gen_height_form + 22
		end
		
		if gen_height_form > max_gen_heigth_form then
			max_gen_heigth_form = gen_height_form
		end
		
		
	end

	
	--GML_UI_AddCompent(arr_tabs[type_settings], bg_settings_waiting)
	---- 
	--L_DrawButton2(form, "ok", 89 + 51 + width_left_menu, max_gen_heigth_form + 4, "btnYes")
	--
	---- 
	--L_DrawButton2(form, "cancel", 176 + 51 + width_left_menu, max_gen_heigth_form + 4, "btnNo")
	
	L_StaticBtn(form, {
		system_name			= "btnYes",													--   
		text				= lstr(866),										-- ""   
		--hint				= lstr(378),	-- " "   
		arr_area			= {89 + 51 + - 26 + width_left_menu, max_gen_heigth_form + 4},															--  
		modal_result		= 1,
		--text_system_name	= "seasonMainBtnText",										--   
	})
	
	L_StaticBtn(form, {
		system_name			= "btnClear",													--   
		text				= lstr(867),										-- ""   
		--hint				= lstr(378),	-- " "   
		arr_area			= {89 + 51 + 51 + width_left_menu, max_gen_heigth_form + 4},															--  
		modal_result		= 0,
		--text_system_name	= "seasonMainBtnText",										--   
	})
	
	L_StaticBtn(form, {
		system_name			= "btnNo",													--   
		text				= lstr(868),										-- ""   
		--hint				= lstr(378),	-- " "   
		arr_area			= {89 + 51 + 128 + width_left_menu, max_gen_heigth_form + 4},															--  
		modal_result		= 1,
		--text_system_name	= "seasonMainBtnText",										--   
	})

	for i = #arr_selects, 1, -1 do
		local cpt_bg_left = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_bg_left"..math.random(1, 10000), 6, 12 + 4 + 1, arr_selects[i].arr_area[1]-4, arr_selects[i].arr_area[2] - 2)
		GML_UI_AddCompent(arr_tabs[arr_selects[i].type_settings], cpt_bg_left)
		GML_UI_LoadImage(cpt_bg_left, "texture/ui_morgan/buttons.png", NORMAL, 6, 18, 0, 73)
		
		local cpt_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_bg_"..math.random(1, 10000), arr_selects[i].arr_size[1] - 12 + 6, 12 + 4 + 1, arr_selects[i].arr_area[1] + 2, arr_selects[i].arr_area[2] - 2)
		GML_UI_AddCompent(arr_tabs[arr_selects[i].type_settings], cpt_bg)
		GML_UI_LoadImage(cpt_bg, "texture/ui_morgan/buttons.png", NORMAL, 4, 18, 6, 73)
		
		local cpt_bg_right = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_bg_right"..math.random(1, 10000), 6, 12 + 4 + 1, arr_selects[i].arr_area[1] + arr_selects[i].arr_size[1] - 4, arr_selects[i].arr_area[2] - 2)
		GML_UI_AddCompent(arr_tabs[arr_selects[i].type_settings], cpt_bg_right)
		GML_UI_LoadImage(cpt_bg_right, "texture/ui_morgan/buttons.png", NORMAL, 6, 18, 10, 73)
	
		local sBox = GML_UI_CreateCompent(form, SELECT_BOX, arr_selects[i].system_name, arr_selects[i].arr_size[1], arr_selects[i].arr_size[2], arr_selects[i].arr_area[1], arr_selects[i].arr_area[2] + 1)
		GML_UI_AddCompent(arr_tabs[arr_selects[i].type_settings], sBox)
		GML_UI_SB_SetPlaceholder(sBox, arr_selects[i].title, 0xFFFFFFFF)
		--GML_UI_SB_SetPlaceholder(sBox, arr_selects[i].title, 0xFFfED746)
		
		for i2 = 1, #arr_selects[i].points do
			GML_UI_SB_AddItem(sBox, arr_selects[i].points[i2])
		end
		
		GML_UI_SB_SetSelectItem(sBox, 1)
	end
	
	--    
	local bg_settings_waiting = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_settings_waiting", 554, 431, 3, 22)
	GML_UI_LoadImage(bg_settings_waiting, "texture/ui_morgan/settings/bg_settings_waiting.png", NORMAL, 554, 431, 0, 0) 
	--local hr_line = GML_UI_CreateCompent(form, IMAGE_TYPE, "hr_line", 182-63, 1, 11, 134)
	--GML_UI_LoadImage(hr_line, "texture/ui_morgan/settings/game_settings_2.png", NORMAL, 10, 1, 0, 248) 
	--GML_UI_SetImageAlpha(hr_line, 50)
	
	--L_TextArea(form, {
	--	cpt_arr_area	= {10, 27 + (33 * #arr_items_settings) + 5},
	--	--cpt_hint		= "",
	--	--cpt_label_type	= LABELEX_TYPE,
	--	
	--	arr_text			=	{
	--		lstr(320),
	--		lstr(321)
	--	},
	--	
	--	text_width	= 185,
	--	--text_hight			= 12,
	--	text_font			= FONT14,
	--	text_color			= COLOR_GRAY,
	--	text_shadow			= FALSE,
	--	--text_shadow_color	= COLOR_BLACK,
	--	text_center			= 1,
	--	--text_right			= 0,
	--})
end
GenFormVideoSettings()



--   
function GenFormAskCharacterChange()
	GenFormAlert({
		arr_line_text = {
			lstr(322),
		},
		system_name = "frmAskChange"
	})
end
GenFormAskCharacterChange()


--    
function GenFormAskRelogin()
	GenFormAlert({
		arr_line_text = {
			lstr(323),
		},
		system_name = "frmAskRelogin"
	})
end
GenFormAskRelogin()

--     Premium
function GenFormAskReloginPremium()
	GenFormAlert({
		arr_line_text = {
			lstr(324)
		},
		system_name = "frmAskReloginPremium"
	})
end
GenFormAskReloginPremium()

--     Premium 2
function GenFormAskReloginPremiumExit()
	GenFormAlert({
		arr_line_text = {
			lstr(325),
			lstr(326)
		},
		system_name = "frmAskReloginPremiumExit"
	})
end
GenFormAskReloginPremiumExit()


--    
function GenFormAskExit()
	GenFormAlert({
		arr_line_text = {
			lstr(327)
		},
		system_name = "frmAskExit"
	})
end
GenFormAskExit()
