-- 
function GenFormDialog()
	local form = L_SetForm({
		system_name	= "frmNPCchat",
		arr_size	= {331, 322},
		arr_area	= {180, 140},
		text_title	= lstr(380)
	})
	
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	--GML_UI_SetFormStyle(form, 2)
	GML_UI_SetIsDrag(form, TRUE)
	
	
	L_CreateBG({
		form_name = form, arr_size = {315, 261}, arr_pos_area = {8, 27}, castom_path = "texture/ui_morgan/form/bg_5.png"
	})
	
	local bg_text = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgBakFull", 281, 199, 25, 58)
	GML_UI_LoadImage(bg_text, "texture/ui_morgan/dialog/bg_text.png", NORMAL, 281, 199, 0, 0)
	
	-- 278
	--   
	local memCtrl = GML_UI_CreateCompent(form, MEMO_TYPE, "memCtrl", 297 - 2, 241, 25, 37)
	GML_UI_SetTextColor(memCtrl, COLOR_BLACK)
	GML_UI_SetCaption(memCtrl, "") 

	local locale = GML_GetSelectLocale()
	local a_max_symbols = {
		["RU"] = 41,
		["EN"] = 46,
	}
	
	local max_symbols = a_max_symbols[locale] or a_max_symbols["RU"]

	GML_UI_SetMemoMaxNumPerRow(memCtrl, max_symbols)
	GML_UI_SetMemoPageShowNum(memCtrl, 11)
	GML_UI_SetMemoRowHeight(memCtrl , 22)
	--GML_UI_SetMemoMaxNumPerRow(memCtrl, 45)
	-- 
	L_DrawScroll(memCtrl, 120, 2)
	
	
	-- 
	local btn = L_StaticBtn(form, {
		system_name			= "btnNo",							--   
		text				= lstr(381),						-- ""   
		--hint				= "",								-- " "   
		arr_area			= {132, 294},						--  
		--modal_result		= 1,
		--text_system_name	= "seasonMainBtnText",				--   
	})
end
GenFormDialog()


--  
function GenFormExchange()

	local form = L_SetForm({
		system_name	= "f_exchange",
		arr_size	= {318, 368},
		arr_area	= {180, 140},
		text_title	= lstr(785)
	})
	
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_V)
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_SetFormStyle(form, 2)
	GML_UI_SetIsDrag(form, TRUE)
	
	-- 
	for _col = 1, 4 do
	
		for _row = 1, 3 do

			--   
			local col_offset = (_row - 1) * 101
			local row_offset = (_col - 1) * 76

			local x_bg, y_bg = 10 + col_offset, 32 + row_offset
			L_CreateBG({ form_name = form, arr_size = {96, 71}, arr_pos_area = {x_bg, y_bg} })

			-- ,    
			local x_item_1, y_item_1 = 17 + col_offset, 39 + row_offset
			L_GenItemBG(form, { arr_area = {x_item_1, y_item_1} })
			GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "item_1_".._col.."_".._row, 38, 38, x_item_1 + 2, y_item_1 + 2)

			--   
			local x_arrow, y_arrow = 55 + col_offset, 53 + row_offset
			local img_arrow = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgNumber", 5, 8, x_arrow, y_arrow)
			GML_UI_LoadImage(img_arrow, "texture/ui_morgan/arrow_right_40_alpha.png", NORMAL, 5, 8, 0, 0)

			-- ,   
			local x_item_2, y_item_2 = 63 + col_offset, 39 + row_offset
			L_GenItemBG(form, { arr_area = {x_item_2, y_item_2} })
			GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "item_2_".._col.."_".._row, 38, 38, x_item_2 + 2, y_item_2 + 2)

			--    
			local x_input, y_input = 17 + col_offset, 78 + row_offset
			L_OldRowInput(form, "inp_count_".._col.."_".._row, 1, 32, "", {82, 18}, {x_input, y_input})

			--  
			local x_btn, y_btn = 83 + col_offset, 80 + row_offset
			local btn_exchange = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_exchange_".._col.."_".._row, 14, 14, x_btn, y_btn)
			GML_UI_LoadButtonImage(btn_exchange, "texture/ui_morgan/buttons_14X14.png", 14, 14, 0, 294, TRUE)
			GML_UI_SetHint(btn_exchange, lstr(786))
			
			
			--   
			local col_offset = (_row - 1) * 101
			local row_offset = (_col - 1) * 76

			local bg_on_lot = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_on_lot_".._col.."_".._row, 96, 72, x_bg, y_bg)
			GML_UI_LoadImage(bg_on_lot, "texture/ui_morgan/exchange/bg_on_lot.png", NORMAL, 96, 72, 0, 0)
			
		end
		
	end

	-- 
	L_GenPag(form, {system_name = "pgs_page", arr_area = {0, 340}, width = 318, width_text_bg = 47})
	
end
GenFormExchange()

--   ()  
function GenFormTradeNPC()
	local form = L_SetForm({
		system_name	= "frmNPCtrade",
		arr_size	= {251, 368},
		arr_area	= {240, 168},
		text_title	= lstr(382)
	})
	
	
	
	local redem_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "redem_bg", 235, 32, 8, 328)
	GML_UI_LoadImage(redem_bg, "texture/ui_morgan/npc_trade/redem_bg.png", NORMAL, 235, 32, 0, 0)
	--GML_UI_SetImageAlpha(redem_bg, math.ceil(255 * 50 / 100))
	
	-- 
	local grdNPCtradeRedem = L_SetFormItems(form, {
		system_name	= "grdNPCtradeRedem",			--   
		arr_area	= {9, 329},			--   
		size_type	= 2,
		arr_items	= {
			col = 8,						--  ,
			row = 1,						--  
			row_scroll = 1,				--    
		},
	})
	
	-- 
	
	GML_UI_SetHint(grdNPCtradeRedem, ",   .\n    \n  3 .")
	
	--   
	local pgeNPCtrade = GML_UI_CreateCompent(form, PAGE_TYPE, "pgeNPCtrade", 236, 318, 0, 0)
	GML_UI_SetPageButton(pgeNPCtrade, PAGE_BUTTON_CUSTOM, 39, 19)
	
	for _tab_id = 1, 7 do
		local _tab		= GML_UI_CreatePageItem(pgeNPCtrade)
		local _tab_obj	= GML_UI_GetPageItemObj(_tab, PAGE_ITEM_TITLE)
		GML_UI_LoadImage(_tab_obj, "texture/ui_morgan/npc_trade/btn_bg.png", PAGE_ITEM_TITLE_NORMAL, 30, 26, 0, 0)
		GML_UI_LoadImage(_tab_obj, "texture/ui_morgan/npc_trade/btn_bg.png", PAGE_ITEM_TITLE_ACTIVE, 30, 26, 30, 0)
		GML_UI_SetPos(_tab_obj, 11 + ((_tab_id - 1) * 33), 24)
		GML_UI_SetSize(_tab_obj, 30, 26)
		--GML_UI_SetIsShow(_tab, FALSE)
		
		local _tab_icon_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "tab_icon_bg_".._tab_id, 18, 18, 17 + ((_tab_id - 1) * 33), 29)
		GML_UI_LoadImage(_tab_icon_bg, "texture/ui_morgan/npc_trade/tab_icon/".._tab_id..".png", NORMAL, 18, 18, 0, 0)
		--GML_UI_SetIsShow(_tab_icon_bg, FALSE)
	end
		-- 
	local grdNPCtradeWeapon = L_SetFormItems(form, {
		system_name	= "grdNPCtradeWeapon",		--   
		arr_area	= {8, 50},					--   
		arr_items	= {
			col			= 6,					--  ,
			row			= 7,					--  
			row_scroll = 60,					--    
		},
	})
	
	return form
end
GenFormTradeNPC()

--	--   ()  
--	function GenFormTradeNPC()
--		local form = L_SetForm({
--			system_name	= "frmNPCtrade",
--			arr_size	= {251, 368},
--			arr_area	= {240, 168},
--			text_title	= lstr(382)
--		})
--		
--		-- 
--		local grdNPCtradeWeapon = L_SetFormItems(form, {
--			system_name	= "grdNPCtradeWeapon",		--   
--			arr_area	= {8, 45},					--   
--			arr_items	= {
--				col			= 6,					--  ,
--				row			= 6,					--  
--				row_scroll = 60,					--    
--			},
--		})
--		
--		-- 
--		local grdNPCtradeEquip = L_SetFormItems(form, {
--			system_name	= "grdNPCtradeEquip",			--   
--			arr_area	= {8, 45},			--   
--			arr_items	= {
--				col = 6,						--  ,
--				row = 6,						--  
--				row_scroll = 60,				--    
--			},
--		})
--		
--		-- 
--		local grdNPCtradeOther = L_SetFormItems(form, {
--			system_name	= "grdNPCtradeOther",			--   
--			arr_area	= {8, 45},			--   
--			arr_items	= {
--				col = 6,						--  ,
--				row = 6,						--  
--				row_scroll = 60,				--    
--			},
--		})
--		
--		-- 
--		local grdNPCtradeRedem = L_SetFormItems(form, {
--			system_name	= "grdNPCtradeRedem",			--   
--			arr_area	= {8, 282},			--   
--			arr_items	= {
--				col = 6,						--  ,
--				row = 1,						--  
--				row_scroll = 1,				--    
--			},
--		})
--		
--		GML_UI_SetHint(grdNPCtradeRedem, ",   .\n    \n  3 .")
--		
--		--   
--		local pgeNPCtrade = GML_UI_CreateCompent(form, PAGE_TYPE, "pgeNPCtrade", 236, 318, 0, 0)
--		GML_UI_SetPageButton(pgeNPCtrade, PAGE_BUTTON_CUSTOM, 39, 19)
--		
--		for _tab_id = 1, 8 do
--			local _tab		= GML_UI_CreatePageItem(pgeNPCtrade)
--			local _tab_obj	= GML_UI_GetPageItemObj(_tab, PAGE_ITEM_TITLE)
--			GML_UI_LoadImage(_tab_obj, "texture/ui_morgan/npc_trade/btn_bg.png", PAGE_ITEM_TITLE_NORMAL, 26, 22, 0, 0)
--			GML_UI_LoadImage(_tab_obj, "texture/ui_morgan/npc_trade/btn_bg.png", PAGE_ITEM_TITLE_ACTIVE, 26, 22, 26, 0)
--			GML_UI_SetPos(_tab_obj, 11 + ((_tab_id - 1) * 29), 23)
--			GML_UI_SetSize(_tab_obj, 26, 22)
--			
--			local _tab_icon_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "tab_icon_bg_".._tab_id, 16, 16, 16 + ((_tab_id - 1) * 29), 27)
--			GML_UI_LoadImage(_tab_icon_bg, "texture/ui_morgan/npc_trade/tab_icon/".._tab_id..".png", NORMAL, 16, 16, 0, 0)
--		end
--		
--		--  
--	
--		
--		return form
--	end
--	GenFormTradeNPC()

----      
--function GenFormNPCTrade()
--	local form = GML_UI_CreateForm("frmNPCtrade", FALSE, 264, 394, 240, 168, TRUE, FALSE)
--	GML_UI_LoadFormImage(form, "texture/ui/npctrade.tga", 264, 394, 0, 0, "", 0, 0)
--	GML_UI_ShowForm(form, TRUE)
--	GML_UI_AddFormToTemplete(form, FORM_MAIN)
--	GML_UI_SetIsDrag(form, TRUE)
--
--	-- 
--	L_DrawTitle(form, lstr(382))
--
--	-- 
--	L_DrawClose(form, 264)
--
--	-- 
--	local grdNPCtradeWeapon = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, "grdNPCtradeWeapon", 248, 316, 14, 65)
--	GML_UI_SetGridSpace(grdNPCtradeWeapon, 7, 7)
--	GML_UI_SetGridContent(grdNPCtradeWeapon, 20, 6)
--	GML_UI_SetGridUnitSize(grdNPCtradeWeapon, 32, 32)
--	GML_UI_SetMargin(grdNPCtradeWeapon, 4, 4, 0, 0)
--
--	-- 
--	L_DrawScroll(grdNPCtradeWeapon)
--
--	-- 
--	local grdNPCtradeEquip = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, "grdNPCtradeEquip", 248, 316, 14, 65)
--	GML_UI_SetGridSpace(grdNPCtradeEquip, 7, 7)
--	GML_UI_SetGridContent(grdNPCtradeEquip, 20, 6)
--	GML_UI_SetGridUnitSize(grdNPCtradeEquip, 32, 32)
--	GML_UI_SetMargin(grdNPCtradeEquip, 4, 4, 0, 0)
--
--	-- 
--	L_DrawScroll(grdNPCtradeEquip)
--
--	-- 
--	local grdNPCtradeOther = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, "grdNPCtradeOther", 248, 316, 14, 65)
--	GML_UI_SetGridSpace(grdNPCtradeOther, 7, 7)
--	GML_UI_SetGridContent(grdNPCtradeOther, 20, 6)
--	GML_UI_SetGridUnitSize(grdNPCtradeOther, 32, 32)
--	GML_UI_SetMargin(grdNPCtradeOther, 4, 4, 0, 0)
--
--	-- 
--	L_DrawScroll(grdNPCtradeOther)
--
--	--   
--	local pgeNPCtrade = GML_UI_CreateCompent(form, PAGE_TYPE, "pgeNPCtrade", 236, 314, 0, 0)
--	GML_UI_SetPageButton(pgeNPCtrade, PAGE_BUTTON_CUSTOM, 39, 19)
--
--	--  
--	local itemid = GML_UI_CreatePageItem(pgeNPCtrade)
--	local ttlWeapon = GML_UI_GetPageItemObj(itemid, PAGE_ITEM_TITLE)
--	GML_UI_LoadImage(ttlWeapon, "texture/ui/npctrade.tga", PAGE_ITEM_TITLE_NORMAL, 80, 22, 270, 0)
--	GML_UI_LoadImage(ttlWeapon, "texture/ui/npctrade.tga", PAGE_ITEM_TITLE_ACTIVE, 80, 22, 350, 0)
--	GML_UI_SetPos(ttlWeapon, 12, 40)
--	GML_UI_SetSize(ttlWeapon, 80, 22)
--	GML_UI_AddCompent(itemid, grdNPCtradeWeapon)
--
--	--  
--	itemid = GML_UI_CreatePageItem(pgeNPCtrade)
--	local ttlEquip = GML_UI_GetPageItemObj(itemid, PAGE_ITEM_TITLE)
--	GML_UI_LoadImage(ttlEquip, "texture/ui/npctrade.tga", PAGE_ITEM_TITLE_NORMAL, 80, 22, 270, 22)
--	GML_UI_LoadImage(ttlEquip, "texture/ui/npctrade.tga", PAGE_ITEM_TITLE_ACTIVE, 80, 22, 350, 22)
--	GML_UI_SetPos(ttlEquip, 92, 40)
--	GML_UI_SetSize(ttlEquip, 80, 22)
--	GML_UI_AddCompent(itemid, grdNPCtradeEquip)
--
--	--  
--	itemid = GML_UI_CreatePageItem(pgeNPCtrade)
--	local ttlOther = GML_UI_GetPageItemObj(itemid, PAGE_ITEM_TITLE)
--	GML_UI_LoadImage(ttlOther, "texture/ui/npctrade.tga", PAGE_ITEM_TITLE_NORMAL, 80, 22, 270, 44)
--	GML_UI_LoadImage(ttlOther, "texture/ui/npctrade.tga", PAGE_ITEM_TITLE_ACTIVE, 80, 22, 350, 44)
--	GML_UI_SetPos(ttlOther, 172, 40)
--	GML_UI_SetSize(ttlOther, 80, 22)
--	GML_UI_AddCompent(itemid, grdNPCtradeOther)
--
--	return form
--end
--GenFormNPCTrade()





--          NPC
function GenFormNPCTradeNumber()
	local form = GML_UI_CreateForm("frmNPCTradeNumber", FALSE, 185, 101, 240, 268, TRUE, FALSE)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_V)
	GML_UI_LoadFormImage(form, "texture/ui/sure.dds", 185, 101, 0, 0, "", 0, 0)
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_SetIsDrag(form, TRUE)
	GML_UI_SetFormStyle(form, 2)
	GML_UI_SetAlpha(form, 255)

	--  
	local btnClose = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnClose", 14, 14, 164, 3)
	GML_UI_LoadButtonImage(btnClose, "texture/ui/PublicC.tga", 14, 14, 116, 175, TRUE)

	--    ""
	local labNumber = GML_UI_CreateCompent(form, LABELEX_TYPE, "labNumber", 23, 11, 44, 32)
	GML_UI_SetCaption(labNumber, lstr(383))												--
	GML_UI_SetTextColor(labNumber, COLOR_BLACK)
	GML_UI_SetLabelExFont(labNumber, DEFAULT_FONT, TRUE, COLOR_WHITE)

	--    " "
	local labSum = GML_UI_CreateCompent(form, LABELEX_TYPE, "labSum", 23, 11, 44, 54)
	GML_UI_SetCaption(labSum, lstr(385))												-- 
	GML_UI_SetTextColor(labSum, COLOR_BLACK)
	GML_UI_SetLabelExFont(labSum, DEFAULT_FONT, TRUE, COLOR_WHITE)

	--   
	local imgNumber = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgNumber", 87, 18, 71, 28)
	GML_UI_LoadImage(imgNumber, "texture/ui/PublicC.tga", NORMAL, 87, 18, 99, 235)

	--   
	local imgSum = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgSum", 87, 18, 71, 50)
	GML_UI_LoadImage(imgSum, "texture/ui/PublicC.tga", NORMAL, 87, 18, 99, 235)

	--   
	local edtNPCTradeNumber = GML_UI_CreateCompent(form, EDIT_TYPE, "edtNPCTradeNumber", 87, 11, 79, 32)
	GML_UI_SetTextColor(edtNPCTradeNumber, COLOR_BLACK)
	GML_UI_SetEditMaxNum(edtNPCTradeNumber, 3)
	GML_UI_SetEditMaxNumVisible(edtNPCTradeNumber, 3)

	--    
	local labNPCTradeNumber = GML_UI_CreateCompent(form, LABELEX_TYPE, "labNPCTradeNumber", 87, 11, 79, 54)
	GML_UI_SetCaption(labNPCTradeNumber, "0")
	GML_UI_SetTextColor(labNPCTradeNumber, COLOR_WHITE)
	GML_UI_SetLabelExFont(labNPCTradeNumber, DEFAULT_FONT, TRUE, COLOR_BLACK)

	--  
	local btnYes = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnYes", 41, 19, 85, 78)
	GML_UI_LoadButtonImage(btnYes, "texture/ui/PublicC.tga", 41, 19, 0, 40, TRUE)

	--  
	local btnNo = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnNo", 41, 19, 130, 78)
	GML_UI_LoadButtonImage(btnNo, "texture/ui/PublicC.tga", 41, 19, 0, 20, FALSE)

	return form
end
GenFormNPCTradeNumber()

-- 
function GetFormBank()
	local form = L_SetForm({
		system_name	= "frmNPCstorage",
		arr_size	= {255, 350},
		arr_area	= {472, 160},
		text_title	= lstr(386)
	})
	
	--    
	local grd_items = L_SetFormItems(form, {
		system_name	= "grdNPCstorage",			--   
		arr_area	= {10, 27},			--   
		arr_items	= {
			col = 6,							--  ,
			row = 8								--  
		},
	})
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labOwnerName", 0, 0, -1000, 0)
end
GetFormBank()


--         
function GenFormNPCForge()
	local form = GML_UI_CreateForm("frmNPCforge", FALSE, 325, 394, 240, 70, TRUE, FALSE)
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_Z)
	GML_UI_SetFormStyle(form, 2)
	GML_UI_SetIsDrag(form, TRUE)
	--GML_UI_SetAlpha(form, 200)

	--  
	local proNPCforgeBak = GML_UI_CreateCompent(form, PROGRESS_TYPE, "proNPCforgeBak", 137, 11, 30, 328)
	GML_UI_LoadImage(proNPCforgeBak, "texture/ui_morgan/forge/forge.png", NORMAL, 137, 11, 650, 11)

	local proNPCforge = GML_UI_CreateCompent(form, PROGRESS_TYPE, "proNPCforge", 137, 11, 30, 328)
	GML_UI_LoadImage(proNPCforge, "texture/ui_morgan/forge/forge.png", PROGRESS_PROGRESS, 137, 11, 650, 0)

	--  
	local imgBakForge = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgBakForge", 325, 394, 0, 0)
	GML_UI_LoadImage(imgBakForge, "texture/ui_morgan/forge/forge.png", NORMAL, 325, 394, 0, 0)

	--  (  )
	local labTitle = GML_UI_CreateCompent(form, LABELEX_TYPE, "labTitle", 400, 150, 10, 7)
	--GML_UI_SetCaption(labTitle, " ")
	--GML_UI_SetTextColor(labTitle, COLOR_WHITE)

	--    
	local imgMillingTitle = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgMillingTitle", 325, 316, 0, 0)
	GML_UI_LoadImage(imgMillingTitle, "texture/ui_morgan/forge/forge.png", NORMAL, 325, 316, 325, 0)

	-- 
	local btnClose = L_DrawClose(form, 325)

	--   
	local cmdForgeItem0 = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdForgeItem0", 33, 33, 147, 193) -- 
	local cmdForgeItem1 = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdForgeItem1", 33, 33, 59, 249) -- 
	local cmdForgeItem2 = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdForgeItem2", 33, 33, 232, 249) -- 

	-- 
	local labForgeGold = GML_UI_CreateCompent(form, LABELEX_TYPE, "labForgeGold", 72, 19, 236, 328)
	GML_UI_SetCaption(labForgeGold, "")
	GML_UI_SetTextColor(labForgeGold, COLOR_WHITE)

	--  
	local memForgeItemState = GML_UI_CreateCompent(form, MEMO_TYPE, "memForgeItemState", 297, 130, 12, 37)
	GML_UI_SetTextColor(memForgeItemState, COLOR_BLACK)
	GML_UI_SetMemoMaxNumPerRow(memForgeItemState, 24)
	GML_UI_SetMemoPageShowNum(memForgeItemState, 7)
	GML_UI_SetMemoRowHeight(memForgeItemState, 17)
	
	local lstForgeItemState = GML_UI_CreateCompent(form, LIST_TYPE, "lstForgeItemState", 297, 130, 12, 37)
	GML_UI_SetListRowHeight(lstForgeItemState, 17)
	GML_UI_SetListFontColor(lstForgeItemState, 4293591039, 4293591039)
	GML_UI_SetMargin(lstForgeItemState, 8, 3, 6, 0)
	GML_UI_SetIsShow(lstForgeItemState, TRUE)
	GML_UI_AddListText(lstForgeItemState, "")
	GML_UI_AddListText(lstForgeItemState, "")
	GML_UI_AddListText(lstForgeItemState, "")
	GML_UI_AddListText(lstForgeItemState, "")
	GML_UI_AddListText(lstForgeItemState, "")
	GML_UI_AddListText(lstForgeItemState, "")
	GML_UI_AddListText(lstForgeItemState, "")

	-- 
	L_DrawButton(form, "forging", 85, 357, "btnForgeYes")
	L_DrawButton(form, "fusion", 85, 357, "btnMillingYes")
	L_DrawButton(form, "no", 172, 357, "btnForgeNo")

	return form
end
GenFormNPCForge()


--        ,  
function GenFormMakeEquip()
	local form = GML_UI_CreateForm("frmMakeEquip", FALSE, 325, 394, 240, 70, TRUE, FALSE)
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_Z)
	GML_UI_SetFormStyle(form, 2)
	GML_UI_SetIsDrag(form, TRUE)

	--  
	local imgBakTop = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgBakTop", 325, 394, 0, 0)
	GML_UI_LoadImage(imgBakTop, "texture/ui_morgan/forge/forge.png", NORMAL, 325, 394, 650, 30)

	-- 
	local btnClose = L_DrawClose(form, 325)

	-- 
	local cmdRouLeau = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdRouLeau", 33, 33, 147, 131) -- 
	local cmdItem0 = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdItem0", 33, 33, 59, 187) 		--  1
	local cmdItem1 = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdItem1", 33, 33, 232, 187) 	--  2
	local cmdItem2 = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdItem2", 33, 33, 147, 244) 	--  3. 
	local cmdItem3 = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdItem3", 33, 33, 0, 0) 		--  4
	local cmdLastEquip = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdLastEquip", 33, 33, 0, 0) -- 

	GML_UI_SetHint(cmdItem0, lstr(393))
	GML_UI_SetHint(cmdItem1, lstr(394))
	GML_UI_SetHint(cmdItem2, lstr(395))
	GML_UI_SetHint(cmdRouLeau, lstr(396))

	-- 
	local labForgeGold = GML_UI_CreateCompent(form, LABELEX_TYPE, "labForgeGold", 70, 11, 130, 328)
	GML_UI_SetCaption(labForgeGold, "")
	GML_UI_SetTextColor(labForgeGold, COLOR_WHITE)

	-- 
	local labForgePersent = GML_UI_CreateCompent(form, LABELEX_TYPE, "labForgePersent", 28, 17, 234, 327)
	GML_UI_SetCaption(labForgePersent, "???")
	GML_UI_SetTextColor(labForgePersent, COLOR_WHITE)
	GML_UI_SetHint(labForgePersent, lstr(397))

	--  .  
	local memForgeItemState = GML_UI_CreateCompent(form, MEMO_TYPE, "memForgeItemState", 180, 77, 24, 286)
	GML_UI_SetTextColor(memForgeItemState, COLOR_BLACK)
	GML_UI_SetMemoMaxNumPerRow(memForgeItemState, 16)
	GML_UI_SetMemoPageShowNum(memForgeItemState, 4)
	GML_UI_SetMemoRowHeight(memForgeItemState, 18)

	local lstForgeItemState = GML_UI_CreateListView(form, "lstForgeItemState", 180, 77, 24, 286, 1, 2)
	GML_UI_SetListRowHeight(lstForgeItemState, 18)
	GML_UI_SetListFontColor(lstForgeItemState, 4293591039, 4293591039)
	GML_UI_SetMargin(lstForgeItemState, 8, 5, 0, 0)
	GML_UI_SetIsShow(lstForgeItemState, TRUE)
	GML_UI_AddListText(lstForgeItemState, "")
	GML_UI_AddListText(lstForgeItemState, "")
	GML_UI_AddListText(lstForgeItemState, "")
	GML_UI_AddListText(lstForgeItemState, "")

	-- 
	local btnForgeYes = L_DrawButton(form, "ok", 85, 357, "btnForgeYes")
	GML_UI_FormSetEnterButton(form, btnForgeYes)
	
	local btnForgeNo = L_DrawButton(form, "no", 172, 357, "btnForgeNo")

	return form
end
GenFormMakeEquip()


-- :  
function GenFormItemUpgr()
	--    
	local form = L_SetForm({
		system_name	= "frmUpgrade",
		arr_size	= {239, 338},
		text_title	= lstr(398)
	})
	
	local form_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgBakTop", 239, 316, 0, 22)
	GML_UI_LoadImage(form_bg, "texture/ui_morgan/form/form_bg_ItemUpgr.png", NORMAL, 239, 316, 0, 0)
	
	--   ()
	local aniSuccess = GML_UI_CreateCompent(form, ANIMAGE_TYPE, "aniSuccess", 210, 210, 13, 32)
	GML_UI_LoadAnimage(aniSuccess, "texture/ui_morgan/new_forge/aniSuccess.protect", 101, 210, 210, 0, 0, 30, 0, 29)
	
	--   ()
	local aniFail = GML_UI_CreateCompent(form, ANIMAGE_TYPE, "aniFail", 210, 210, 13, 32)
	GML_UI_LoadAnimage(aniFail, "texture/ui_morgan/new_forge/aniFail.protect", 94, 210, 210, 0, 0, 30, 0, 29)
	
	-- 
	local cmdMainItem = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdMainItem", 32, 32, 104, 61)
	GML_UI_SetHint( cmdMainItem, lstr(399) )-- 
	
	local cmdItem0 = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdItem0", 32, 32, 42, 121)
	GML_UI_SetHint( cmdItem0, lstr(400) )		-- 1
	
	local cmdItem1 = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdItem1", 32, 32, 165, 121)
	GML_UI_SetHint(cmdItem1, lstr(401))			-- 2
	
	-- 
	L_RowText(
		form, 
		"labPersent", 
		1,																			-- type (gold)
		lstr(402),	-- hint
		{44, 18},																	-- : width, height
		{98, 209}																	--  : xpos, ypos
	)
	
	-- 
	L_RowText(
		form, 
		"labPrice", 
		2,																			-- type (gold)
		lstr(403),	-- hint
		{110, 18},																	-- : width, height
		{65, 281}																	--  : xpos, ypos
	)
	
	-- 
	local labResult = GML_UI_CreateCompent(form, LABELEX_TYPE, "labResult", 191, 10, 24, 265)
	GML_UI_SetTextColor(labResult, COLOR_WHITE)
	
	-- 
	L_DrawButton2(form, "ok", 37, 309, "btnUpgrade")
	
	-- 
	L_DrawButton2(form, "no", 135, 309, "btnClose2")
end
GenFormItemUpgr()



-- 
function GenFormAlchemy()
	--    
	local form = L_SetForm({
		system_name	= "f_alchemy",
		arr_size	= {208, 368},
		text_title	= lstr(796)
	})
	
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_U)
	
	--- . 
	local bg_main = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_form", 202, 343, 3, 22)
	GML_UI_LoadImage(bg_main, "texture/ui_morgan/f_alchemy/bg.png", NORMAL, 202, 343, 0, 0)
		
	--   ()
	local ani_create_success = GML_UI_CreateCompent(form, ANIMAGE_TYPE, "ani_create_success", 56, 127, 76, 103)
	GML_UI_LoadAnimage(ani_create_success, "texture/ui_morgan/f_alchemy/create_success.protect", 80, 56, 127, 0, 0, 15, 0, 20)
	
	--   ()
	local ani_create_fail = GML_UI_CreateCompent(form, ANIMAGE_TYPE, "ani_create_fail", 56, 127, 76, 103)
	GML_UI_LoadAnimage(ani_create_fail, "texture/ui_morgan/f_alchemy/create_fail.protect", 80, 56, 127, 0, 0, 15, 0, 20)
	
	--	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "35452", 18, 114, 62, 147)
	--	GML_UI_LoadButtonAniImage(btn, "texture/ui_morgan/f_alchemy/ani_bg.protect", 51, 18, 114, 0, 0, 30, 0, 41)
	--	GML_UI_SetIgnoreScroll(btn, TRUE)
	--	GML_UI_DisableCursorReplace(btn)
	--		
	--	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "35452", 18, 114, 62+20, 147+5)
	--	GML_UI_LoadButtonAniImage(btn, "texture/ui_morgan/f_alchemy/ani_bg.protect", 51, 18, 114, 0, 0, 50, 0, 41)
	--	GML_UI_SetIgnoreScroll(btn, TRUE)
	--	GML_UI_DisableCursorReplace(btn)
	--	
	--	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "35452", 18, 114, 62+40, 147)
	--	GML_UI_LoadButtonAniImage(btn, "texture/ui_morgan/f_alchemy/ani_bg.protect", 51, 18, 114, 0, 0, 30, 0, 41)
	--	GML_UI_SetIgnoreScroll(btn, TRUE)
	--	GML_UI_DisableCursorReplace(btn)
	--	
	--	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "35452", 18, 114, 62+60, 147)
	--	GML_UI_LoadButtonAniImage(btn, "texture/ui_morgan/f_alchemy/ani_bg.protect", 51, 18, 114, 0, 0, 25, 0, 41)
	--	GML_UI_SetIgnoreScroll(btn, TRUE)
	--	GML_UI_DisableCursorReplace(btn)
	--	
	--	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "35452", 18, 114, 62+70, 147)
	--	GML_UI_LoadButtonAniImage(btn, "texture/ui_morgan/f_alchemy/ani_bg.protect", 51, 18, 114, 0, 0, 20, 0, 41)
	--	GML_UI_SetIgnoreScroll(btn, TRUE)
	--	GML_UI_DisableCursorReplace(btn)
	
	--  1
	L_GenItem(form, {
		sys_name	= "item_comp_1",
		--a_size		= {24, 24},
		a_area		= {40, 113},
		a_bg_1		= {alfa = 60},
		--a_bg_2		= {path = "10152", alfa = 40},
		hint		= lstr(799),
	})
	
	--  2
	L_GenItem(form, {
		sys_name	= "item_comp_2",
		--a_size		= {24, 24},
		a_area		= {86, 67},
		a_bg_1		= {alfa = 60},
		--a_bg_2		= {path = "11231", alfa = 40},
		hint		= lstr(800),
	})
	
	--  3
	L_GenItem(form, {
		sys_name	= "item_comp_3",
		--a_size		= {24, 24},
		a_area		= {132, 113},
		a_bg_1		= {alfa = 60},
		--a_bg_2		= {path = "11232", alfa = 40},
		hint		= lstr(801),
	})
	
	-- 
	L_GenItem(form, {
		sys_name	= "item_plan",
		--a_size		= {24, 24},
		a_area		= {86, 113},
		a_bg_1		= {alfa = 100},
		a_bg_2		= {path = "9407", alfa = 100},
		hint		= lstr(802),
	})

	
	
	--  
	L_GenItem(form, {
		sys_name	= "item_other",
		a_size		= {28, 28},
		a_area		= {90, 159},
		a_bg_1		= {alfa = 40},
		--a_bg_2		= {path = "855", alfa = 60},
		hint		= lstr(804),
	})
	
	
	-- 
	L_GenItem(form, {
		sys_name	= "item_final",
		--a_size		= {24, 24},
		a_area		= {86, 230},
		a_bg_1		= {alfa = 100},
		--a_bg_2		= {path = "11228", alfa = 80},
		hint		= lstr(803),
	})
	
	-- 
	L_RowText(
		form, 
		"lab_chance", 
		1,																			-- type (gold)
		lstr(798),	-- hint
		{39, 18},																	-- : width, height
		{56 + 28, 251 + 18 + 10},																	--  : xpos, ypos
		1,
		"0%"
	)
	
	-- 
	L_RowText(
		form, 
		"lab_cost", 
		2,																			-- type (gold)
		lstr(403),	-- hint
		{67, 18},																	-- : width, height
		{70, 289 + 28},																	--  : xpos, ypos
		2,
		"500"
	)
	
	--  ""
	L_StaticBtn(form, {
		system_name			= "btn_create",													--   
		text				= lstr(797),										-- ""   
		hint				= "",
		arr_area			= {70, 309 + 28},															--  
		modal_result		= 0,
	})
end
GenFormAlchemy()


--  ( )
function GenFormForge()
	--    
	local form = L_SetForm({
		system_name	= "f_forge",
		arr_size	= {208, 368},
		text_title	= lstr(818)
	})
	
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_U)
	
	--- . 
	local bg_main = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_form", 202, 343, 3, 22)
	GML_UI_LoadImage(bg_main, "texture/ui_morgan/f_forge/bg.png", NORMAL, 202, 343, 0, 0)
	
	
	--	-- 
	--	local btn_anim = GML_UI_CreateCompent(form, BUTTON_TYPE, "", 90, 77, 59, 171, 1)
	--	GML_UI_LoadButtonAniImage(btn_anim, "texture/ui_morgan/f_forge/fire.protect", 9, 90, 77, 0, 0, 50, 0, 1)

	
	
	---   
	local bg_main = GML_UI_CreateCompent(form, IMAGE_TYPE, "channels_anym", 66, 86, 71, 122)
	GML_UI_LoadImage(bg_main, "texture/ui_morgan/f_forge/channels_anym.png", NORMAL, 66, 86, 0, 0)
	
	
	--   ()
	local ani_create_success = GML_UI_CreateCompent(form, ANIMAGE_TYPE, "ani_create_success", 56, 76, 76, 127)
	GML_UI_LoadAnimage(ani_create_success, "texture/ui_morgan/f_forge/create_success.protect", 80, 56, 76, 0, 0, 25, 0, 20)
	
	--   ()
	local ani_create_fail = GML_UI_CreateCompent(form, ANIMAGE_TYPE, "ani_create_fail", 56, 76, 76, 127)
	GML_UI_LoadAnimage(ani_create_fail, "texture/ui_morgan/f_forge/create_fail.protect", 80, 56, 76, 0, 0, 25, 0, 20)
	
	-- 
	L_GenItem(form, {
		sys_name	= "item_gem",
		--a_size		= {24, 24},
		a_area		= {40, 112},
		a_bg_1		= {alfa = 100},
		a_bg_2		= {path = "861", alfa = 40},
		hint		= lstr(815),
	})
	
	--  ()
	L_GenItem(form, {
		sys_name	= "item_cat",
		--a_size		= {24, 24},
		a_area		= {132, 112},
		a_bg_1		= {alfa = 100},
		a_bg_2		= {path = "9361", alfa = 40},
		hint		= lstr(816),
	})
	
	-- 
	L_GenItem(form, {
		sys_name	= "item_ansil",
		--a_size		= {24, 24},
		a_area		= {86, 203},
		a_bg_1		= {alfa = 100},
		a_bg_2		= {path = "162", alfa = 40},
		hint		= lstr(817),
	})
	

	
	-- 
	L_RowText(
		form, 
		"lab_chance", 
		1,																			-- type (gold)
		lstr(798),	-- hint
		{39, 18},																	-- : width, height
		{56 + 28, 251 + 18 + 10},																	--  : xpos, ypos
		1,
		"0%"
	)
	
	-- 
	L_RowText(
		form, 
		"lab_cost", 
		2,																			-- type (gold)
		lstr(403),	-- hint
		{67, 18},																	-- : width, height
		{70, 289 + 28},																	--  : xpos, ypos
		2,
		"500"
	)
	
	--  ""
	L_StaticBtn(form, {
		system_name			= "btn_create",													--   
		text				= lstr(814),										-- ""   
		hint				= "",
		arr_area			= {70, 309 + 28},															--  
		modal_result		= 0,
	})
end
GenFormForge()

--  
function GenFormComb()
	--    
	local form = L_SetForm({
		system_name	= "f_comb",
		arr_size	= {208, 368},
		text_title	= lstr(824)
	})
	
	--- 
	local bg_main = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_form", 202, 343, 3, 22)
	GML_UI_LoadImage(bg_main, "texture/ui_morgan/f_comb/bg.png", NORMAL, 202, 343, 0, 0)
	
	
	--  
	local bg_form_anim = GML_UI_CreateCompent(form, ANIMAGE_TYPE, "bg_form_anim", 202, 343, 3, 22)
	GML_UI_LoadAnimage(bg_form_anim, "texture/ui_morgan/f_comb/bg_anim.protect", 14, 202, 343, 0, 0, 15, 0, 14)
	
	---   
	local channels_anym = GML_UI_CreateCompent(form, IMAGE_TYPE, "channels_anym", 59, 89, 77- 3, 141)
	GML_UI_LoadImage(channels_anym, "texture/ui_morgan/f_comb/channels_anym.png", NORMAL, 59, 89, 0, 0)
	
	---    
	local channels_bg_anym = GML_UI_CreateCompent(form, IMAGE_TYPE, "channels_bg_anym", 49, 79, 83- 3, 146)
	GML_UI_LoadImage(channels_bg_anym, "texture/ui_morgan/f_comb/channels_anym_bg.png", NORMAL, 49, 79, 0, 0)
	
	---    
	local bg_cannal_succ = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_channels_success", 47, 79, 80, 146)
	GML_UI_LoadImage(bg_cannal_succ, "texture/ui_morgan/f_comb/bg_cannal_succ.png", NORMAL, 47, 79, 0, 0)
	
	GML_UI_SetIsShow(bg_cannal_succ, FALSE)
	
	--  
	local ani_create = GML_UI_CreateCompent(form, ANIMAGE_TYPE, "ani_create", 47, 79, 80, 146)
	GML_UI_LoadAnimage(ani_create, "texture/ui_morgan/f_comb/ani_create.protect", 40, 47, 79, 0, 0, 5, 0, 20)
	
	--   ()
	local ani_create_success = GML_UI_CreateCompent(form, ANIMAGE_TYPE, "ani_create_success", 47, 79, 80, 146)
	GML_UI_LoadAnimage(ani_create_success, "texture/ui_morgan/f_comb/create_success.protect", 25, 47, 79, 0, 0, 5, 0, 20)
	
	--   ()
	local ani_create_fail = GML_UI_CreateCompent(form, ANIMAGE_TYPE, "ani_create_fail", 47, 79, 80, 146)
	GML_UI_LoadAnimage(ani_create_fail, "texture/ui_morgan/f_comb/create_fail.protect", 65, 47, 79, 0, 0, 5, 0, 20)
	
	--  1
	L_GenItem(form, {
		sys_name	= "item_gem_1",
		--a_size		= {24, 24},
		a_area		= {60- 3, 225},
		a_bg_1		= {alfa = 100},
		a_bg_2		= {path = "861", alfa = 40},
		hint		= lstr(823),
	})
	
	--  2
	L_GenItem(form, {
		sys_name	= "item_gem_2",
		--a_size		= {24, 24},
		a_area		= {118- 3, 225},
		a_bg_1		= {alfa = 100},
		a_bg_2		= {path = "861", alfa = 40},
		hint		= lstr(822),
	})
	
	-- 
	L_GenItem(form, {
		sys_name	= "item_scroll",
		--a_size		= {24, 24},
		a_area		= {89- 3, 166},
		a_bg_1		= {alfa = 100},
		a_bg_2		= {path = "9072", alfa = 40},
		hint		= lstr(821),
	})
	
	-- 
	L_GenItem(form, {
		sys_name	= "item_finish_item",
		--a_size		= {24, 24},
		a_area		= {89 - 3, 110},
		a_bg_1		= {alfa = 100},
		--a_bg_2		= {path = "861", alfa = 40},
		hint		= lstr(820),
	})
	

	
	-- 
	L_RowText(
		form, 
		"lab_chance", 
		1,																			-- type (gold)
		lstr(798),	-- hint
		{41, 18},																	-- : width, height
		{54 - 6, 309},																	--  : xpos, ypos
		1,
		"0%"
	)
	
	-- 
	L_RowText(
		form, 
		"lab_cost", 
		2,																			-- type (gold)
		lstr(403),	-- hint
		{69, 18},																	-- : width, height
		{95 - 4, 309},																	--  : xpos, ypos
		2,
		"500"
	)
	
	--  ""
	L_StaticBtn(form, {
		system_name			= "btn_create",													--   
		text				= lstr(819),										-- ""   
		hint				= "",
		arr_area			= {54 - 6, 329},															--  
		size				= {112, 18},
		bg_path				= "texture/ui_morgan/f_comb/btn.png",
		modal_result		= 0,
	})
end
GenFormComb()


--  
function GenFormSeaTrade()
	--  
	local frmSeaTrade = GML_UI_CreateForm("frmSeaTrade", FALSE, 406, 394, 256, 140, TRUE, FALSE)
	GML_UI_LoadFormImage(frmSeaTrade, "texture/ui/seatrade.tga", 406, 394, 0, 0, "", 0, 0)
	GML_UI_ShowForm(frmSeaTrade, FALSE)
	GML_UI_AddFormToTemplete(frmSeaTrade, 1)
	GML_UI_SetIsDrag(frmSeaTrade, TRUE)

	-- 
	L_DrawTitle(frmSeaTrade, lstr(404))

	-- 
	L_DrawClose(frmSeaTrade, 406)

	--   
	local grdItemSale = GML_UI_CreateCompent(frmSeaTrade, GOODS_GRID_TYPE, "grdItemSale", 392, 176, 0, 0)
	GML_UI_SetGridSpace(grdItemSale, 10, 5)
	GML_UI_SetGridContent(grdItemSale, 6, 4)
	GML_UI_SetGridUnitSize(grdItemSale, 85, 78)
	GML_UI_SetMargin(grdItemSale, 10, 10, 0, 0)

	-- 
	L_DrawScroll(grdItemSale)

	--   
	local grdItemBuy = GML_UI_CreateCompent(frmSeaTrade, GOODS_GRID_TYPE, "grdItemBuy", 392, 176, 0, 0)
	GML_UI_SetGridSpace(grdItemBuy, 10, 5)
	GML_UI_SetGridContent(grdItemBuy, 6, 4)
	GML_UI_SetGridUnitSize(grdItemBuy, 85, 78)
	GML_UI_SetMargin(grdItemBuy, 10, 10, 0, 0)

	-- 
	L_DrawScroll(grdItemBuy)

	--  
	local pgeTrade = GML_UI_CreateCompent(frmSeaTrade, PAGE_TYPE, "pgeTrade", 342, 176, 12, 58)
	GML_UI_SetPageButton(pgeTrade, PAGE_BUTTON_CUSTOM, 69, 41)

	--  
	local Itemsale = GML_UI_CreatePageItem(pgeTrade)
	local ttlSale = GML_UI_GetPageItemObj(Itemsale, PAGE_ITEM_TITLE)
	GML_UI_LoadImage(ttlSale, "texture/ui/seatrade.tga", PAGE_ITEM_TITLE_NORMAL, 70, 22, 0, 400)
	GML_UI_LoadImage(ttlSale, "texture/ui/seatrade.tga", PAGE_ITEM_TITLE_ACTIVE, 70, 22, 70, 400)
	GML_UI_SetPos(ttlSale, 0, -24)
	GML_UI_SetSize(ttlSale, 70, 22)
	GML_UI_AddCompent(Itemsale, grdItemSale)

	--  
	local Itembuy = GML_UI_CreatePageItem(pgeTrade)
	local ttlBuy = GML_UI_GetPageItemObj(Itembuy, PAGE_ITEM_TITLE)
	GML_UI_LoadImage(ttlBuy, "texture/ui/seatrade.tga", PAGE_ITEM_TITLE_NORMAL, 70, 22, 0, 422)
	GML_UI_LoadImage(ttlBuy, "texture/ui/seatrade.tga", PAGE_ITEM_TITLE_ACTIVE, 70, 22, 70, 422)
	GML_UI_SetPos(ttlBuy, 72, -24)
	GML_UI_SetSize(ttlBuy, 70, 22)
	GML_UI_AddCompent(Itembuy, grdItemBuy)
end
GenFormSeaTrade()

--  
function GenFormBlackTrade()
	--  
	local frmBlackTrade = GML_UI_CreateForm("frmBlackTrade", FALSE, 662, 394, 70, 70, TRUE, FALSE)
	GML_UI_LoadFormImage(frmBlackTrade, "texture/ui_morgan/blacktrade/form.png", 662, 394, 0, 0, "", 0, 0)
	GML_UI_ShowForm(frmBlackTrade, FALSE)
	GML_UI_AddFormToTemplete(frmBlackTrade, 1)
	GML_UI_SetIsDrag(frmBlackTrade, TRUE)

	-- 
	L_DrawTitle(frmBlackTrade, lstr(405))

	-- 
	L_DrawClose(frmBlackTrade, 662)

	--  
	local grdItemSale = GML_UI_CreateCompent(frmBlackTrade, GOODS_GRID_TYPE, "grdItemSale", 646, 256, 14, 46)
	GML_UI_SetGridSpace(grdItemSale, 28, 17)
	GML_UI_SetGridContent(grdItemSale, 14, 3)
	GML_UI_SetGridUnitSize(grdItemSale, 182, 68)
	GML_UI_SetMargin(grdItemSale, 10, 0, 0, 0)

	-- 
	L_DrawScroll(grdItemSale)

	--  
	local grdItemBuy = GML_UI_CreateCompent(frmBlackTrade, GOODS_GRID_TYPE, "grdItemBuy", 458, 44, 79, 327)
	GML_UI_SetGridSpace(grdItemBuy, 14, 0)
	GML_UI_SetGridContent(grdItemBuy, 1, 11)
	GML_UI_SetGridUnitSize(grdItemBuy, 32, 32)
	GML_UI_SetMargin(grdItemBuy, 6, 7, 0, 0)
end
GenFormBlackTrade()
