----
-- :   
----

function GenForm_Trade()
	local form = L_SetForm({
		system_name	= "frmPlayertrade",
		arr_size	= {277, 368},
		text_title	= lstr(741)
	})
	
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_Y)
	GML_UI_FormSetIsEscClose(form, FALSE)
	
	----
	--   
	----
	
	-- 
	L_Text(form, {
		system_name		= "labPlayertradeName",
		arr_size		= {0, 0},
		arr_area		= {0, 0},
		--hint			= "",
	
		arr_text	= {
			text			= "",
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	--  " :"
	L_Text(form, {
		--system_name		= "lable",
		arr_size		= {256, 13},
		arr_area		= {10, 22 + 7},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(742),
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	
	--       
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 22 + 23}, arr_size = {256, 124}, alpha = 100
	})

	--    
	L_SetFormItems(form, {
		system_name	= "grdBuy",			--   
		arr_area	= {21, 22 + 34},		--   
		arr_items	= {
			col = 6,						--  ,
			row = 2							--  
		},
	})
	
	--  
	L_RowText(
		form, 
		"invOtherCrystals", 
		4,																-- type (gold)
		"",	-- hint (  )
		{115, 18},														-- : width, height
		{21, 22 + 118}														--  : xpos, ypos
	)
	
	--   
	L_RowText(
		form, 
		"labOtherGold", 
		2,																-- type (gold)
		"",	-- hint (  )
		{115, 18},														-- : width, height
		{141, 22 + 118}														--  : xpos, ypos
	)
	
	
	--       
	local bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_trade_wait", 254, 122, 11, 46)
	GML_UI_LoadImage(bg, "texture/ui_morgan/form/bg_trade_wait.png", NORMAL, 254, 122, 0, 0)
	GML_UI_SetAlpha(bg, 220)
	
	--  "  "
	L_Text(form, {
		system_name		= "text_trade_wait",
		arr_size		= {256, 13},
		arr_area		= {10, 94},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(751),
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	----
	--  
	----
	
	--  " :"
	L_Text(form, {
		--system_name		= "lable",
		arr_size		= {256, 13},
		arr_area		= {10, 22 + 154},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(743),
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	--     
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 22 + 170}, arr_size = {256, 124}, alpha = 100
	})

	
	--    
	L_SetFormItems(form, {
		system_name	= "grdSale",			--   
		arr_area	= {21, 22 + 181},		--   
		arr_items	= {
			col = 6,						--  ,
			row = 2							--  
		},
	})
	
	--  
	L_RowText(
		form, 
		"invCountCrystals", 
		4,																-- type (gold)
		"",	-- hint (  )
		{115, 18},														-- : width, height
		{21, 22 + 265}														--  : xpos, ypos
	)
	
	--  " "
	local btn_add_crystals = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnCrystals", 14, 14, 120, 22 + 267)
	GML_UI_LoadButtonImage(btn_add_crystals, "texture/ui_morgan/buttons_14X14.png", 14, 14, 0, 14, TRUE)
	GML_UI_SetHint(btn_add_crystals, lstr(744))
	
	--   
	L_RowText(
		form, 
		"labSelfGold", 
		2,																-- type (gold)
		"",	-- hint (  )
		{115, 18},														-- : width, height
		{141, 22 + 265}														--  : xpos, ypos
	)
	
	--  " "
	local btn_add_crystals = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnGold", 14, 14, 240, 22 + 267)
	GML_UI_LoadButtonImage(btn_add_crystals, "texture/ui_morgan/buttons_14X14.png", 14, 14, 0, 14, TRUE )
	GML_UI_SetHint(btn_add_crystals, lstr(745))
	
	
	-- -
	L_TextArea(form, {
		cpt_arr_area	= {10, 22 + 319},
		--cpt_hint		= "",
		--cpt_label_type	= LABELEX_TYPE,
		
		arr_text			=	{
			-- : "  "
			lstr(746),
			
			-- : " 65   185 "
			lstr(747),
		},
		
		text_width	= 256,
		text_hight			= 11,
		text_font			= ARIAL_FONT,
		text_color			= COLOR_GRAY,
		text_shadow			= FALSE,
		--text_shadow_color	= COLOR_BLACK,
		text_center			= 1,
		--text_right			= 0,
	})
	
	--  ""
	L_StaticBtn(form, {
		system_name			= "btnYes",					--   
		text				= lstr(748),						-- ""   
		--hint				= lstr(519),	-- ",   "   
		arr_area			= {10, 22 + 299},					--  
		--text_system_name	= "f_stickers_btn_add_text",		--   
		modal_result		= 0,
	})
	
	
	--  " "
	L_StaticBtn(form, {
		system_name			= "btnTrade",								--   
		size				= {112, 17},
		bg_path				= "texture/ui_morgan/btn/112_17.png",
		text				= lstr(749),								-- ""   
		--hint				= lstr(734),								-- ",      "   
		arr_area			= {82, 22 + 299},										--  
		--text_system_name	= "f_stickers_btn_add_text",		--   
		modal_result		= 0,
	})
	
	
	--  ""
	L_StaticBtn(form, {
		system_name			= "btnNo",					--   
		text				= lstr(750),						-- ""   
		--hint				= lstr(519),	-- ",   "   
		arr_area			= {199, 22 + 299},					--  
		--text_system_name	= "f_stickers_btn_add_text",		--   
		modal_result		= 0,
	})
	
	
	
	-- ,   
	GML_UI_CreateCompent(form, CHECK_TYPE, "chkYes", 11, 12, 124, 202)
	
	-- ,   
	GML_UI_CreateCompent(form, CHECK_TYPE, "chkTrade", 11, 12, 168, 202)
	
end
GenForm_Trade()

function GenForm_TradeEnterCrystals()
	local form = L_SetForm({
		system_name	= "f_trade_enter_cry",
		arr_size	= {197, 113 + 20},
		text_title	= lstr(752)
	})
	
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_Y)
	
	--  " "
	L_Text(form, {
		--system_name		= "",
		arr_size		= {197, 13},
		arr_area		= {0, 30},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(753),
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	--  
	L_OldRowInput(
		form, 
		"input", 
		6,																-- type (2 --    )
		10,																--   
		"",																-- hint
		{157, 18},														-- : width, height
		{20, 48}														--  : xpos, ypos
	)
	
	--    (-10%):
	L_Text(form, {
		--system_name		= "",
		arr_size		= {197, 13},
		arr_area		= {0, 70},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(754),
			font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	-- -  
	L_Text(form, {
		system_name		= "count_cry",
		arr_size		= {197, 13},
		arr_area		= {0, 68 + 14},
		--hint			= "",
	
		arr_text	= {
			text			= "",
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	-- 
	local btnYes = L_DrawButton2(form, "yes", 19, 99, "btnYes")
	GML_UI_FormSetEnterButton(form, btnYes)
	
	-- 
	L_DrawButton2(form, "no", 109, 99, "btnNo")
end
GenForm_TradeEnterCrystals()

----
-- :  
----
function GetFormSmithyPress()
	local form = L_SetForm({
		system_name	= "f_smithy_press",
		arr_size	= {222, 205},
		text_title	= lstr(735)
	})
	
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, 1)
	GML_UI_SetIsDrag(form, TRUE)
	GML_UI_SetFormStyle(form, 0)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_Y)
	
	-- . 
	local bg_main = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_form", 216, 179, 3, 22)
	GML_UI_LoadImage(bg_main, "texture/ui_morgan/smithy_press/bg_form.png", NORMAL, 216, 179, 0, 0)
	
	--  " ,"
	L_Text(form, {
		--system_name		= "lable",
		arr_size		= {202, 13},
		arr_area		= {10, 27},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(736),
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	--  "  "
	L_Text(form, {
		--system_name		= "lable",
		arr_size		= {202, 13},
		arr_area		= {10, 38},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(737),
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	-- 
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 59}, arr_size = {202, 114}, alpha = 90
	})
	
	for _i = 1, 10 do
		local pos_x, pos_y = 20, 69
		if _i <= 5 then
			pos_x, pos_y = pos_x + ((34 + 3) * (_i - 1)), pos_y
		else
			pos_x, pos_y = pos_x + ((34 + 3) * ((_i - 5) - 1)), pos_y + (34 + 3)
		end
		
		L_SetItemBG(form, {
			arr_size			= {30, 30},
			arr_area			= {pos_x, pos_y},
			--arr_bg_second		= "",
			arr_bg_first		= {alfa = 100},
			--arr_bg_second		= {path = "item_bg_7363", alfa = 30},
		})
		
		GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "item_".._i, 32, 32, pos_x + 1, pos_y + 1)
	end
	
	-- 
	L_RowText(
		form, 
		"need_gold", 
		2,																-- type (gold)
		"",	-- hint (  )
		{86, 18},														-- : width, height
		{20, 145}														--  : xpos, ypos
	)
	
	--  ""
	L_StaticBtn(form, {
		system_name			= "btn_compress",								--   
		size				= {86, 18},
		bg_path				= "texture/ui_morgan/smithy_press/btn.png",
		text				= lstr(738),								-- ""   
		--hint				= lstr(734),								-- ",      "   
		arr_area			= {116, 145},										--  
		--text_system_name	= "f_stickers_btn_add_text",		--   
	})
	
	L_TextArea(form, {
		cpt_arr_area	= {10, 173},
		--cpt_hint		= "",
		--cpt_label_type	= LABELEX_TYPE,
		
		arr_text			=	{
			-- : "  "
			lstr(739),
			
			-- : " 65   185 "
			lstr(740),
		},
		
		text_width	= 202,
		--text_hight			= 12,
		text_font			= ARIAL_FONT,
		text_color			= COLOR_GRAY3,
		text_shadow			= FALSE,
		--text_shadow_color	= COLOR_BLACK,
		text_center			= 1,
		--text_right			= 0,
	})
	
	
end
GetFormSmithyPress()

----
-- : 
----

function GenFormFishing()
	local form = GML_UI_CreateForm("f_fishing", FALSE, 42, 377, 500, 200, TRUE, FALSE)
	GML_UI_ShowForm(form, FALSE)
	GML_UI_SetIsDrag(form, FALSE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_FormSetIsEscClose(form, FALSE)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_Y)
	
	--  
	local form_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "form_bg", 42, 377, 0, 0)
	GML_UI_LoadImage(form_bg, "texture/ui_morgan/fishing/form_bg.png", NORMAL, 42, 377, 0, 0)
	
	-- 
	local slider = GML_UI_CreateCompent(form, IMAGE_TYPE, "slider", 26, 102, 3, 272)
	GML_UI_LoadImage(slider, "texture/ui_morgan/fishing/slider.png", NORMAL, 26, 102, 0, 0)
	
	-- 
	local fish = GML_UI_CreateCompent(form, IMAGE_TYPE, "fish", 26, 25, 3, 349)
	GML_UI_LoadImage(fish, "texture/ui_morgan/fishing/fish.png", NORMAL, 26, 25, 0, 0)
	
	--  
	local progress_bar = GML_UI_CreateCompent(form, PROGRESS_TYPE, "progress_bar", 8, 373, 32, 2)
	GML_UI_LoadScaleImage(progress_bar, "texture/ui_morgan/fishing/progress_bar.png", PROGRESS_PROGRESS, 8, 373, 0, 0, 1.0, 1.0)
	GML_UI_SetHint(progress_bar, "")
	GML_UI_SetProgressHintStyle(progress_bar, PROGRESS_HINT_NUM)
	GML_UI_SetProgressStyle(progress_bar, 1) -- Vertical
	
end
GenFormFishing()

----
-- : TowerDefense
----

function GenFormTDInfo()
	local form = GML_UI_CreateForm("f_TDInfo", FALSE, 324, 59, 0, 86, TRUE, FALSE)
	GML_UI_ShowForm(form, TRUE)
	GML_UI_SetIsDrag(form, FALSE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_SetFormStyle(form, 13)
	GML_UI_FormSetIsEscClose(form, FALSE)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_Y)
	
	--  --
	
	-- 
	L_CreateBG({
		form_name = form, arr_pos_area = {11, 6}, arr_size = {62, 15},
	})
	
	-- 
	local icon_hp = GML_UI_CreateCompent(form, IMAGE_TYPE, "icon_hp", 24, 24, 0, 2)
	GML_UI_LoadImage(icon_hp, "texture/ui_morgan/towerdefence/bg_heart.png", NORMAL, 24, 24, 0, 0)
	
	-- 
	L_Text(form, {
		system_name		= "text_hp",
		arr_size		= {48, 11},
		arr_area		= {24, 6 + 4},
		--hint			= "",
	
		arr_text	= {
			text			= "20/20",
			font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	
	-- -  
	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_hint", 73, 22, 0, 2)
	GML_UI_SetHint(btn, lstr(196))
	
	--  --
	
	-- 
	L_CreateBG({
		form_name = form, arr_pos_area = {11, 32}, arr_size = {62, 15},
		--castom_path = "texture/ui_morgan/form/bg_3.png"
	})
	
	-- 
	local icon_money = GML_UI_CreateCompent(form, IMAGE_TYPE, "icon_money", 24, 24, 0, 28)
	GML_UI_LoadImage(icon_money, "texture/ui_morgan/towerdefence/bg_money.png", NORMAL, 24, 24, 0, 0)
	
	-- 
	L_Text(form, {
		system_name		= "text_money",
		arr_size		= {48, 11},
		arr_area		= {24, 36},
		--hint			= "",
	
		arr_text	= {
			text			= "12",
			font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	-- -  
	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_hint", 73, 22, 0, 28)
	GML_UI_SetHint(btn, lstr(502))
	
	
	--  --
	
	local arr_tower_data = {
		[1] = {
			tower_model_id	= 1886,
			tower_cost		= 3,
			tower_name		= lstr(503),
			tower_hint		= lstr(504),
			tower_bind		= "Alt+1",
		},
		[2] = {
			tower_model_id	= 1887,
			tower_cost		= 6,
			tower_name		= lstr(505),
			tower_hint		= lstr(506),
			tower_bind		= "Alt+2",
		},
		[3] = {
			tower_model_id	= 1888,
			tower_cost		= 7,
			tower_name		= lstr(507),
			tower_hint		= lstr(508),
			tower_bind		= "Alt+3",
		},
		[4] = {
			tower_model_id	= 1889,
			tower_cost		= 8,
			tower_name		= lstr(509),
			tower_hint		= lstr(510),
			tower_bind		= "Alt+4",
		},
	}
	
	
	for i = 1, #arr_tower_data do
		--   
		L_CreateBG({
			form_name = form, arr_pos_area = {84 + (62 * (i - 1)), 4}, arr_size = {60, 45},
			castom_path = "texture/ui_morgan/form/bg_7.png"
		})
		
		GML_UI_CreateCompent(form, UI3D_COMPENT, "3d_tower_"..arr_tower_data[i].tower_model_id, 60, 45, 84 + (62 * (i - 1)), 4)
		
		--   
		L_CreateBG({
			form_name = form, arr_pos_area = {84 + (62 * (i - 1)), 36}, arr_size = {60, 14},
			castom_path = "texture/ui_morgan/form/bg_7.png"
		})
		
		--  
		local icon_money = GML_UI_CreateCompent(form, IMAGE_TYPE, "icon_money", 8, 8, 105 + (62 * (i - 1)), 40)
		GML_UI_LoadImage(icon_money, "texture/ui_morgan/towerdefence/bg_money.png", NORMAL, 24, 24, 0, 0)
		
		--  
		L_Text(form, {
			system_name	= "tower_cost_"..i,
			arr_size	= {20, 11},
			arr_area	= {116  + (62 * (i - 1)), 40},
			--hint		= "",
			
			arr_text	= {
				text			= arr_tower_data[i].tower_cost,
				font			= MINI_FONT,
				--color			= COLOR_WHITE,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				--center		= 1,
			}
		})
		
		local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_tower_"..arr_tower_data[i].tower_model_id, 60, 46, 84 + (62 * (i - 1)), 4)
		GML_UI_LoadButtonImage(btn, "texture/ui_morgan/towerdefence/btn_tower.png", 60, 46, 0, 0, TRUE)
		GML_UI_SetHint(btn, arr_tower_data[i].tower_name.."\n\n"..arr_tower_data[i].tower_hint..lstr(511)..arr_tower_data[i].tower_bind)
		
	end
	
	

end
GenFormTDInfo()


function GetFormTDTower()
	local form = L_SetForm({
		system_name	= "f_TDTower",
		arr_size	= {249, 399- 37},
		text_title	= lstr(512)
	})
	
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, 1)
	GML_UI_SetIsDrag(form, TRUE)
	GML_UI_SetFormStyle(form, 0)
	
	-- 
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 32}, arr_size = {229, 304- 37},
	})
	
	--  
	L_Text(form, {
		system_name		= "tower_name",
		arr_size		= {229, 13},
		arr_area		= {10, 42},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(513),
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	L_hr(form, {
		width		= 229,
		height		= 1,
		arr_area	= {10, 60},
		alfa		= 50
	})
	
	GML_UI_CreateCompent(form, UI3D_COMPENT, "3d_tower", 229, 150, 10, 65)
	
	--   1
	L_TextArea(form, {
		cpt_arr_area	= {10, 201 + 22},
		cpt_sys_name	= "tower_desc_1",
		--cpt_hint		= "",
		--cpt_label_type	= LABELEX_TYPE,
		
		arr_text			=	{
			lstr(514),
			lstr(515),
			lstr(516),
			"",
		},
		
		text_width	= 229,
		text_hight			= 14,
		text_font			= DEFAULT_FONT,
		text_color			= COLOR_WHITE,
		text_shadow			= FALSE,
		--text_shadow_color	= COLOR_BLACK,
		text_center			= 1,
		--text_right			= 0,
	})
	
	L_hr(form, {
		width		= 229,
		height		= 1,
		arr_area	= {10, 270},
		alfa		= 50
	})
	
	--   2
	L_TextArea(form, {
		cpt_arr_area	= {10, 278},
		cpt_sys_name	= "tower_desc_2",
		--cpt_hint		= "",
		--cpt_label_type	= LABELEX_TYPE,
		
		arr_text			=	{
			lstr(517),
			"0$",
			"",
			"",
		},
		
		text_width	= 139,
		text_hight			= 14,
		text_font			= DEFAULT_FONT,
		text_color			= COLOR_WHITE,
		text_shadow			= FALSE,
		--text_shadow_color	= COLOR_BLACK,
		text_center			= 1,
		--text_right			= 0,
	})
	
	--  ""
	L_StaticBtn(form, {
		system_name			= "btn_tower_upd",					--   
		text				= lstr(518),						-- ""   
		hint				= lstr(519),	-- ",   "   
		arr_area			= {148, 276},					--  
		--text_system_name	= "f_stickers_btn_add_text",		--   
	})
	
	--    
	L_TextArea(form, {
		cpt_arr_area	= {10, 320 + 22 - 37},
		cpt_sys_name	= "tower_desc_3",
		--cpt_hint		= "",
		--cpt_label_type	= LABELEX_TYPE,
		
		arr_text			=	{
			lstr(520),
			lstr(521),
			"",
			"",
		},
		
		text_width	= 229,
		--text_hight			= 12,
		text_font			= DEFAULT_FONT,
		text_color			= COLOR_GRAY3,
		text_shadow			= FALSE,
		--text_shadow_color	= COLOR_BLACK,
		text_center			= 1,
		--text_right			= 0,
	})

	--  ""
	L_StaticBtn(form, {
		system_name			= "btn_tower_remove",					--   
		text				= lstr(522),						-- ""   
		hint				= lstr(523),	-- ",   "   
		arr_area			= {91, 22 + 350- 37},					--  
		--text_system_name	= "f_stickers_btn_add_text",		--   
	})
end
GetFormTDTower()

----
-- : 
----
function GetFormPetInfo()
	local form = L_SetForm({
		system_name	= "f_pet_info",
		arr_size	= {255, 410 - 130},
		text_title	= lstr(524)
	})
	
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, 1)
	GML_UI_SetIsDrag(form, TRUE)
	GML_UI_SetFormStyle(form, 0)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_Y)
	
	-- 
	
	--  
	local bg_main = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgMain5", 249, 254, 3, 22)
	GML_UI_LoadImage(bg_main, "texture/ui_morgan/pet_collar/bg_pet.png", NORMAL, 249, 254, 0, 0)
	
	
	GML_UI_CreateCompent(form, UI3D_COMPENT, "pet_3D", 249, 236, 3, 22+ 24)
	
	
	--  
	L_Text(form, {
		system_name		= "pet_name",
		arr_size		= {235, 13},
		arr_area		= {10, 10 + 22},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(525),
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	--   
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 188}, arr_size = {235, 83}, alpha = 80
	})
	
	L_SetItemBG(form, {
		arr_size			= {34, 34},
		arr_area			= {20, 198},
		--arr_bg_second		= "",
		arr_bg_first		= {alfa = 100},
		arr_bg_second		= {path = "item_bg_13601", alfa = 30},
	})
	
	local cmpt = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "pet_item_collar", 32, 32, 23, 201)
	
	--  
	L_Text(form, {
		system_name		= "pet_collar_name",
		arr_size		= {170, 13},
		arr_area		= {65, 198},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(526),
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center			= 1,
		}
	})
	
	--  : 
	L_Text(form, {
		system_name		= "pet_collar_desc_1",
		arr_size		= {170, 13},
		arr_area		= {65, 210},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(527),
			--font			= ARIAL_FONT,
			color			= COLOR_GRAY3,
			shadow			= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center			= 1,
		}
	})
	
	-- .. ::
	L_Text(form, {
		system_name		= "pet_collar_desc_2",
		arr_size		= {170, 13},
		arr_area		= {65, 223},
		--hint			= "",
	
		arr_text	= {
			text			= ".. ::",
			--font			= ARIAL_FONT,
			color			= COLOR_GRAY3,
			shadow			= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center			= 1,
		}
	})
	
	L_hr(form, {
		width		= 233,
		height		= 1,
		arr_area	= {11, 243},
		alfa		= 40
	})
	
	
	--  ""
	L_StaticBtn(form, {
		system_name			= "btn_pet_settings",								--   
		size				= {215, 17},
		bg_path				= "texture/ui_morgan/pet_collar/btn.png",
		text				= lstr(528),								-- ""   
		hint				= lstr(529),	-- ",   "   
		arr_area			= {20, 249},										--  
		--text_system_name	= "f_stickers_btn_add_text",		--   
	})
	
	--	--    
	--	L_SetFormItems(form, {
	--		system_name	= "pet_items",			--   
	--		arr_area	= {10, 277 + 5},			--   
	--		arr_items	= {
	--			col = 6,						--  ,
	--			row = 3							--  
	--		},
	--	})
	
	
end
GetFormPetInfo()

----
-- : 
----
function GetFormExtractor()
	local form = L_SetForm({
		system_name	= "f_extractor",
		arr_size	= {282, 146},
		text_title	= lstr(731)
	})
	
	GML_UI_ShowForm(form, TRUE)
	GML_UI_AddFormToTemplete(form, 1)
	GML_UI_SetIsDrag(form, TRUE)
	GML_UI_SetFormStyle(form, 0)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_Y)
	
	-- . 
	local bg_main = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgMain5", 276, 120, 3, 22)
	GML_UI_LoadImage(bg_main, "texture/ui_morgan/form/form_bg_extractor.png", NORMAL, 276, 120, 0, 0)
	GML_UI_SetAlpha(bg_main,150)
		
	-- . 
	local bg_main = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgMain5", 262, 15, 10, 31)
	GML_UI_LoadImage(bg_main, "texture/ui_morgan/form/form_bg_extractor_lable.png", NORMAL, 262, 15, 0, 0)
	--GML_UI_SetAlpha(bg_main,150)
	
	--  "  "
	L_Text(form, {
		system_name		= "lable",
		arr_size		= {262, 13},
		arr_area		= {10, 10 + 22},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(732),
			--font			= ARIAL_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
	
	-- 
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 28+22}, arr_size = {262, 86}, alpha = 90
	})
	
	L_SetItemBG(form, {
		arr_size			= {34, 34},
		arr_area			= {56, 67},
		--arr_bg_second		= "",
		arr_bg_first		= {alfa = 100},
		arr_bg_second		= {path = "item_bg_7363", alfa = 30},
	})
	
	GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "item_1", 32, 32, 56 + 3, 67 + 3)
	
	L_SetItemBG(form, {
		arr_size			= {34, 34},
		arr_area			= {100, 22 + 45},
		--arr_bg_second		= "",
		arr_bg_first		= {alfa = 100},
		arr_bg_second		= {path = "item_bg_7363", alfa = 30},
	})
	
	GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "item_2", 32, 32, 100 + 3, 67 + 3)
	
	L_SetItemBG(form, {
		arr_size			= {34, 34},
		arr_area			= {144, 22 + 45},
		--arr_bg_second		= "",
		arr_bg_first		= {alfa = 100},
		arr_bg_second		= {path = "item_bg_7363", alfa = 30},
	})
	
	GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "item_3", 32, 32, 144 + 3, 67 + 3)
	
	L_SetItemBG(form, {
		arr_size			= {34, 34},
		arr_area			= {188, 22 + 45},
		--arr_bg_second		= "",
		arr_bg_first		= {alfa = 100},
		arr_bg_second		= {path = "item_bg_7363", alfa = 30},
	})
	
	GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "item_4", 32, 32, 188 + 3, 67 + 3)
	
	--  ""
	L_StaticBtn(form, {
		system_name			= "btn_connect",								--   
		--size				= {82, 17},
		--bg_path				= "texture/ui_morgan/pet_collar/btn.png",
		text				= lstr(733),								-- ""   
		hint				= lstr(734),								-- ",      "   
		arr_area			= {98 + 9, 87 + 22 + 2},										--  
		--text_system_name	= "f_stickers_btn_add_text",		--   
	})
	
end
GetFormExtractor()


-- :  
function GetFormPetCollarSettings()
	local form = L_SetForm({
		system_name	= "f_pet_collar_settings",
		arr_size	= {343, 263},
		arr_area	= {0, 185},
		--    
		text_title	= lstr(530)
	})
	GML_UI_SetFormStyle(form, 2)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_U)
	
	
	-- 
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 32}, arr_size = {323, 194+ 5}
	})
	
	--  " "
	L_Text(form, {
		--system_name	= "",
		arr_size	= {303, 12},
		arr_area	= {20, 37 + 5},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(531),
			--font			= ITEMS_NAME,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
		}
	})
	
	--    "  "
	L_OldRowInput(
		form, 
		"inp_search_item", 
		1,																-- type (1 --   )
		32,																--   
		"",																-- hint
		{199, 18},														-- : width, height
		{72, 54+ 5}														--  : xpos, ypos
	)
	
	--  " "
	local btnStockSearchCancle = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_search_item_cancle", 14, 14, 239, 55+ 5)
	GML_UI_LoadButtonImage(btnStockSearchCancle, "texture/ui_morgan/buttons.png", 14, 14, 0, 141, TRUE)
	GML_UI_SetHint(btnStockSearchCancle, lstr(532))
	
	--  " "
	local btnStockSearch = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_search_item", 14, 14, 255, 55+ 5)
	GML_UI_LoadButtonImage(btnStockSearch, "texture/ui_morgan/buttons.png", 14, 14, 0, 183, TRUE)
	GML_UI_SetHint(btnStockSearch, lstr(533))
	GML_UI_FormSetEnterButton(form, btnStockSearch)
	
	
	for i = 1, 8 do
		local area_x = 20 + ((i - 1) * 38)
		local area_y = 81 + 5
		
		--   
		L_GenItemBG(form, {arr_area = {area_x, area_y}})
	end
	
	--    #
	local mountsGrid = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, "grd_items_1", 302, 50, 22, 83+ 5)
	GML_UI_SetGridSpace(mountsGrid, 6, 3)
	GML_UI_SetGridContent(mountsGrid, 1, 8)
	GML_UI_SetGridUnitSize(mountsGrid, 32, 32)
	GML_UI_SetMargin(mountsGrid, 0, 0, 0, 0)
	L_DrawScroll(mountsGrid, 150, 2)
	
	-- 
	L_GenPag(form, {system_name = "pgs_items", arr_area = {0, 122+ 5}, width = 343, width_text_bg = 47})
	
	----  
	L_hr(form, {
		width		= 321,
		arr_area	= {11, 147+ 5},
		alfa		= 50,
	})
	
	--  "  1 :"
	L_Text(form, {
		--system_name	= "",
		arr_size	= {303, 12},
		arr_area	= {20, 158+ 5},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(534),
			--font			= ITEMS_NAME,
			--color			= COLOR_GRAY3,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
		}
	})

	
	for i = 1, 8 do
		local area_x = 20 + ((i - 1) * 38)
		local area_y = 181 + 5
		
		--   
		L_GenItemBG(form, {arr_area = {area_x, area_y}})
	end
	
	--    #
	local mountsGrid = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, "grd_items_2", 302, 50, 22, 183+ 5)
	GML_UI_SetGridSpace(mountsGrid, 6, 3)
	GML_UI_SetGridContent(mountsGrid, 1, 8)
	GML_UI_SetGridUnitSize(mountsGrid, 32, 32)
	GML_UI_SetMargin(mountsGrid, 0, 0, 0, 0)
	L_DrawScroll(mountsGrid, 150, 2)
	
	
	-- : 
	L_btn(form, {
		system_name	= "btn_save",
		text		= lstr(535),
		width		= nil,
		arr_area	= {138, 231+ 5},
		hint		= nil,
		action_id	= nil,
	})
	
end
GetFormPetCollarSettings()


----
-- :  
----
function GenFormStickers()
	--    
	local form = L_SetForm({
		system_name	= "f_stickers",
		arr_size	= {232, 349 + 26 + 27},
		text_title	= lstr(536)
	})
	
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_K) 
	GML_UI_SetFormStyle(form, 0)
	
	--  
	local bg_main = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgMain5", 226, 376, 3, 22)
	GML_UI_LoadImage(bg_main, "texture/ui_morgan/form/form_bg_stickers.png", NORMAL, 226, 376, 0, 0)
	
	--  " -    " 
	L_Text(form, {
		--system_name	= "",
		arr_size	= {226, 12},
		arr_area	= {3, 22 + 9},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(537),
			--font			= FONT14,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
		}
	})
	
	--  1  (  )
	L_Text(form, {
		--system_name	= "",
		arr_size	= {226, 12},
		arr_area	= {3, 22 + 23},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(538),
			font			= DEFAULT_FONT,
			color			= COLOR_GRAY3,
			shadow		= FALSE,
			--shadow_color	= COLOR_GREY,
			center		= 1,
			--right	= 1,
		}
	})
	
	--  2  (   )
	L_Text(form, {
		--system_name	= "",
		arr_size	= {226, 12},
		arr_area	= {3, 22 + 23 + 12},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(539),
			font			= DEFAULT_FONT,
			color			= COLOR_GRAY3,
			shadow		= FALSE,
			--shadow_color	= COLOR_GREY,
			center		= 1,
			--right	= 1,
		}
	})
	
	--    
	L_hr(form, {
		width		= 228,
		height		= 22,
		arr_area	= {2, 38 + 13 + 22},
		alfa		= 90
	})
	
	--  " " 
	L_Text(form, {
		system_name	= "f_stickers_name",
		arr_size	= {226, 12},
		arr_area	= {3, 44 + 13 + 22},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(540),
			--font			= FONT14,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
		}
	})
	
	--   
	GML_UI_CreateCompent(form, IMAGE_TYPE, "f_stickers_img", 128, 128, 46, 28 + 40 + 5 + 27)
	
	
	--  ""
	L_StaticBtn(form, {
		system_name			= "f_stickers_btn_add",																						--   
		text				= lstr(541),																				-- ""   
		hint				= lstr(542),	-- ",   "   
		arr_area			= {82, 206 + 27},																									--  
		--text_system_name	= "f_stickers_btn_add_text",																						--   
	})
	
	--   
	local f_stickers_grid = GML_UI_CreateCompent(form, SKILLS_GRID_TYPE, "f_stickers_grid", 216, 142, 14, 74 + 128 + 26 + 27)
	GML_UI_SetGridSpace(f_stickers_grid, 3, 3)
	GML_UI_SetGridContent(f_stickers_grid, 8, 6)
	GML_UI_SetGridUnitSize(f_stickers_grid, 32, 32)
	GML_UI_SetMargin(f_stickers_grid, 0, 0, 0, 0)
	L_DrawScroll(f_stickers_grid, 150, 2)
end
GenFormStickers()

----
-- :  
----
function GenFormMaunts()
	--    
	local form = L_SetForm({
		system_name	= "formMaunts",
		arr_size	= {440, 246 - 4 - 3},
		text_title	= lstr(543),
	})
	
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_J) 
	GML_UI_SetFormStyle(form, 0)
	
	--   
	local img = GML_UI_CreateCompent(form, IMAGE_TYPE, "f_mounts_bg", 434, 213, 3, 22)
	GML_UI_LoadImage(img, "texture/ui_morgan/form/bg_mount/default.png", NORMAL, 434, 213, 0, 0)
	
	--  "  " 
	L_Text(form, {
		--system_name	= "",
		arr_size	= {220, 12},
		arr_area	= {10 + 2, 22 + 9},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(544),
			--font			= FONT14,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
		}
	})
	
	--  1  (   )
	L_Text(form, {
		--system_name	= "",
		arr_size	= {216, 12},
		arr_area	= {10 + 2, 22 + 23},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(545),
			font			= DEFAULT_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
			--right	= 1,
		}
	})
	
	--  2  (   )
	L_Text(form, {
		--system_name	= "",
		arr_size	= {216, 12},
		arr_area	= {10 + 2, 22 + 23 + 12},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(546),
			font			= DEFAULT_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
			--right	= 1,
		}
	})
	
	--   
	local mountsGrid = GML_UI_CreateCompent(form, MOUNTS_GRID_TYPE, "mountsGrid", 216, 142, 14, 74)
	GML_UI_SetGridSpace(mountsGrid, 3, 3)
	GML_UI_SetGridContent(mountsGrid, 10, 6)
	GML_UI_SetGridUnitSize(mountsGrid, 32, 32)
	GML_UI_SetMargin(mountsGrid, 0, 0, 0, 0)
	L_DrawScroll(mountsGrid, 150, 2)
	
	-- 3D 
	
	----   
	--L_CreateBG({
	--	form_name = form, arr_pos_area = {232, 5 + 22}, arr_size = {193 + 4, 184 - 11 + 29}
	--})
	
	-- 3D 
	GML_UI_CreateCompent(form, UI3D_COMPENT, "maunts3D", 196, 173, 233, 28)

	L_hr(form, {
		width		= 198,
		height		= 22,
		arr_area	= {231, 38},
		alfa		= 80
	})
	
	--  " " 
	L_Text(form, {
		system_name	= "baseMountName",
		arr_size	= {196, 12},
		arr_area	= {233, 44},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(547),
			--font			= FONT14,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
		}
	})

	
end
GenFormMaunts()

----
-- :  
----
function GenFormSinmaraNeck()
	--    
	local form = L_SetForm({
		system_name	= "formSinmaraNeck",
		arr_size	= {272, 230},
		text_title	= lstr(548)
	})
	
	GML_UI_SetFormStyle(form, 0)
	
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_K) 
	
	local bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 266, 205, 3 - 5, 22)
	GML_UI_LoadImage(bg, "texture/ui_morgan/form/form_bg_sinmara_neck.png", NORMAL, 272, 208, 0, 0)
	
	L_GenItemBG(form, {arr_area = {86, 27}, bg_second = "item_bg__neck"})
	GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "formSinmaraNeck_slot_1", 32, 32, 86+2, 27+2)
	
	L_GenItemBG(form, {arr_area = {146, 27}, bg_second = "item_bg_13316"})
	GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "formSinmaraNeck_slot_2", 32, 32, 146+2, 27+2)
	
	
	--  "  :"
	L_Text(form, {
		--system_name	= "",
		arr_size	= {161, 12},
		arr_area	= {45, 73},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(549),
			--font			= FONT14,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
		}
	})
	
	-- - 
	L_Text(form, {
		system_name	= "labCountPoint",
		arr_size	= {20, 12},
		arr_area	= {211, 73},
		--hint		= "",
		
		arr_text	= {
			text			= "15",
			--font			= FONT14,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
		}
	})
	
	
	local start_x_left	= 46
	local start_x_right	= 146
	local start_y		= 95
	
	----
	-- 
	----
	
	L_LableText(form, {
		arr_area			= {start_x_left, start_y},
		width				= 78,
		
		text				= "0",
		text_center			= TRUE,
		text_system_name	= "labHIT",
		text_shadow			= FALSE,
		
		title				= lstr(550),
		--title_color			= COLOR_GRAY4,
		title_center		= TRUE,
		title_shadow		= FALSE,
	})
	
	--   "-"
	local btn_no_sub = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_left + 1, start_y + 14)
	GML_UI_LoadImage(btn_no_sub, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155 + 14)
	
	--   "-"
	local btn_sub = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnHIT_sub", 14, 14, start_x_left + 1, start_y + 14)
	GML_UI_LoadButtonImage(btn_sub, "texture/ui_morgan/buttons.png", 14, 14, 0, 155 + 14, TRUE)
	
	--   "+"
	local btn_no_add = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_left + 63, start_y + 14)
	GML_UI_LoadImage(btn_no_add, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155)
	
	--   "+"
	local btn_add = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnHIT_add", 14, 14, start_x_left + 63, start_y + 14)
	GML_UI_LoadButtonImage(btn_add, "texture/ui_morgan/buttons.png", 14, 14, 0, 155, TRUE)
	
	----
	-- 
	----
	
	local pos_y_cor = 36
	
	L_LableText(form, {
		arr_area			= {start_x_left, start_y + pos_y_cor},
		width				= 78,
		
		text				= "0",
		text_center			= TRUE,
		text_system_name	= "labFLEE",
		text_shadow			= FALSE,
		
		title				= lstr(551),
		--title_color			= COLOR_GRAY4,
		title_center		= TRUE,
		title_shadow		= FALSE,
	})
	
	--   "-"
	local btn_no_sub = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_left + 1, start_y + 14 + pos_y_cor)
	GML_UI_LoadImage(btn_no_sub, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155 + 14)
	
	--   "-"
	local btn_sub = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnFLEE_sub", 14, 14, start_x_left + 1, start_y + 14 + pos_y_cor)
	GML_UI_LoadButtonImage(btn_sub, "texture/ui_morgan/buttons.png", 14, 14, 0, 155 + 14, TRUE)
	
	--   "+"
	local btn_no_add = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_left + 63, start_y + 14 + pos_y_cor)
	GML_UI_LoadImage(btn_no_add, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155)
	
	--   "+"
	local btn_add = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnFLEE_add", 14, 14, start_x_left + 63, start_y + 14 + pos_y_cor)
	GML_UI_LoadButtonImage(btn_add, "texture/ui_morgan/buttons.png", 14, 14, 0, 155, TRUE)
	
	
	----
	-- 
	----
	
	local pos_y_cor = 36 * 2
	
	L_LableText(form, {
		arr_area			= {start_x_left, start_y + pos_y_cor},
		width				= 78,
		
		text				= "0",
		text_center			= TRUE,
		text_system_name	= "labDEF",
		text_shadow			= FALSE,
		
		title				= lstr(552),
		--title_color			= COLOR_GRAY4,
		title_center		= TRUE,
		title_shadow		= FALSE,
	})
	
	--   "-"
	local btn_no_sub = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_left + 1, start_y + 14 + pos_y_cor)
	GML_UI_LoadImage(btn_no_sub, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155 + 14)
	
	--   "-"
	local btn_sub = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnDEF_sub", 14, 14, start_x_left + 1, start_y + 14 + pos_y_cor)
	GML_UI_LoadButtonImage(btn_sub, "texture/ui_morgan/buttons.png", 14, 14, 0, 155 + 14, TRUE)
	
	--   "+"
	local btn_no_add = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_left + 63, start_y + 14 + pos_y_cor)
	GML_UI_LoadImage(btn_no_add, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155)
	
	--   "+"
	local btn_add = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnDEF_add", 14, 14, start_x_left + 63, start_y + 14 + pos_y_cor)
	GML_UI_LoadButtonImage(btn_add, "texture/ui_morgan/buttons.png", 14, 14, 0, 155, TRUE)
	
	----
	-- 
	----
	
	L_LableText(form, {
		arr_area			= {start_x_right, start_y},
		width				= 78,
		
		text				= "0",
		text_center			= TRUE,
		text_system_name	= "labASPD",
		text_shadow			= FALSE,
		
		title				= lstr(553),
		--title_color			= COLOR_GRAY4,
		title_center		= TRUE,
		title_shadow		= FALSE,
	})
	
	--   "-"
	local btn_no_sub = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_right + 1, start_y + 14)
	GML_UI_LoadImage(btn_no_sub, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155 + 14)
	
	--   "-"
	local btn_sub = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnASPD_sub", 14, 14, start_x_right + 1, start_y + 14)
	GML_UI_LoadButtonImage(btn_sub, "texture/ui_morgan/buttons.png", 14, 14, 0, 155 + 14, TRUE)
	
	--   "+"
	local btn_no_add = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_right + 63, start_y + 14)
	GML_UI_LoadImage(btn_no_add, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155)
	
	--   "+"
	local btn_add = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnASPD_add", 14, 14, start_x_right + 63, start_y + 14)
	GML_UI_LoadButtonImage(btn_add, "texture/ui_morgan/buttons.png", 14, 14, 0, 155, TRUE)
	
	----
	-- . 
	----
	
	local pos_y_cor = 36
	
	L_LableText(form, {
		arr_area			= {start_x_right, start_y + pos_y_cor},
		width				= 78,
		
		text				= "0",
		text_center			= TRUE,
		text_system_name	= "labMaxHP",
		text_shadow			= FALSE,
		
		title				= lstr(554),
		--title_color			= COLOR_GRAY4,
		title_center		= TRUE,
		title_shadow		= FALSE,
	})
	
	--   "-"
	local btn_no_sub = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_right + 1, start_y + 14 + pos_y_cor)
	GML_UI_LoadImage(btn_no_sub, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155 + 14)
	
	--   "-"
	local btn_sub = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnMaxHP_sub", 14, 14, start_x_right + 1, start_y + 14 + pos_y_cor)
	GML_UI_LoadButtonImage(btn_sub, "texture/ui_morgan/buttons.png", 14, 14, 0, 155 + 14, TRUE)
	
	--   "+"
	local btn_no_add = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_right + 63, start_y + 14 + pos_y_cor)
	GML_UI_LoadImage(btn_no_add, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155)
	
	--   "+"
	local btn_add = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnMaxHP_add", 14, 14, start_x_right + 63, start_y + 14 + pos_y_cor)
	GML_UI_LoadButtonImage(btn_add, "texture/ui_morgan/buttons.png", 14, 14, 0, 155, TRUE)
	
	
	----
	-- . 
	----
	
	local pos_y_cor = 36 * 2
	
	L_LableText(form, {
		arr_area			= {start_x_right, start_y + pos_y_cor},
		width				= 78,
		
		text				= "0",
		text_center			= TRUE,
		text_system_name	= "labMaxSP",
		text_shadow			= FALSE,
		
		title				= lstr(555),
		--title_color			= COLOR_GRAY4,
		title_center		= TRUE,
		title_shadow		= FALSE,
	})
	
	--   "-"
	local btn_no_sub = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_right + 1, start_y + 14 + pos_y_cor)
	GML_UI_LoadImage(btn_no_sub, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155 + 14)
	
	--   "-"
	local btn_sub = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnMaxSP_sub", 14, 14, start_x_right + 1, start_y + 14 + pos_y_cor)
	GML_UI_LoadButtonImage(btn_sub, "texture/ui_morgan/buttons.png", 14, 14, 0, 155 + 14, TRUE)
	
	--   "+"
	local btn_no_add = GML_UI_CreateCompent(form, IMAGE_TYPE, "GenImg_"..math.random(1,10000), 14, 14, start_x_right + 63, start_y + 14 + pos_y_cor)
	GML_UI_LoadImage(btn_no_add, "texture/ui_morgan/buttons.png", NORMAL, 14, 14, 42, 155)
	
	--   "+"
	local btn_add = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnMaxSP_add", 14, 14, start_x_right + 63, start_y + 14 + pos_y_cor)
	GML_UI_LoadButtonImage(btn_add, "texture/ui_morgan/buttons.png", 14, 14, 0, 155, TRUE)
	
	
	local arr_data = {
		system_name		= "btnAction",									--   
		text			= lstr(556),		-- ""   
		hint			= "",
		arr_area		= {98, 202},									--  
	}
	L_StaticBtn(form, arr_data)
end
GenFormSinmaraNeck()


----
-- :  -
----
function GenFormStore()
	--    
	local form = L_SetForm({
		system_name	= "formStore",
		arr_size	= {800, 550},
		text_title	= lstr(762)
	})
	
	GML_UI_SetIsDrag(form, FALSE)
	GML_UI_SetFormStyle(form, 0)
	
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_J)
	
	
	--   
	--L_CreateBG({
	--	form_name = form, arr_pos_area = {4, 22}, arr_size = {600, 59}
	--})
	
	local bg_header = GML_UI_CreateCompent(form, IMAGE_TYPE, "storeBgHeader"..math.random(1,10000), 794, 59, 4, 22)
	GML_UI_LoadImage(bg_header, "texture/ui_morgan/store/header_1_bg.png", NORMAL, 794, 59, 0, 0)
	--GML_UI_LoadImage(bg_header, "texture/ui_morgan/store/header_5_bg.png", NORMAL, 794, 59, 0, 0)
	--GML_UI_LoadImage(bg_header, "texture/ui_morgan/store/header_3_bg.png", NORMAL, 794, 59, 0, 0)
	--GML_UI_LoadImage(bg_header, "texture/ui_morgan/store/header_4_bg.png", NORMAL, 794, 59, 0, 0)
	--GML_UI_LoadAnimage(form, "texture/ui_morgan/store/ShopHeader_1.2.protect", 27, 797, 59, 0, 0, 27, 0, 29)
	
	--local img = GML_UI_CreateCompent(form, IMAGE_TYPE, "storeBif", 78, 57, 38, 24)
	--GML_UI_LoadImage(img, "texture/ui_morgan/store/header_2_bif.png", NORMAL, 78, 57, 0, 0)
	
	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "", 794, 59, 4, 22)
	GML_UI_LoadButtonAniImage(btn, "texture/ui_morgan/store/ShopHeader.protect", 26, 797, 59, 0, 0, 50, 0, 1)

	--  " -" ()
	L_Text(form, {
		--system_name	= "",
		arr_size	= {195, 24},
		arr_area	= {121, 33},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(557),
			font			= FONT18,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
		}
	})
	
	
	--  " ,   !" ()
	L_Text(form, {
		--system_name	= "",
		arr_size	= {260, 16},
		arr_area	= {121, 55},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(558),
			font			= FONT14,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
		}
	})
	
	----  " ,   !" ()
	--L_Text(form, {
	--	--system_name	= "",
	--	arr_size	= {260, 16},
	--	arr_area	= {121 + 40, 55 + 3},
	--	--hint		= "",
	--	
	--	arr_text	= {
	--		text			= "   \"% 11.11 %\"!",
	--		font			= FONT14,
	--		--color			= COLOR_WHITE,
	--		shadow		= FALSE,
	--		--shadow_color	= COLOR_WHITE,
	--		--center		= 1,
	--	}
	--})
	
	--  " :" ()
	L_Text(form, {
		--system_name	= "",
		arr_size	= {128, 12},
		arr_area	= {664, 35},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(559),
			--font			= FONT14,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
		}
	})
	
	--  
	L_RowText(
		form, 
		"storeCountCrystals", 
		4,																-- type (gold)
		"",	-- hint (  )
		{128, 18},														-- : width, height
		{663, 49}														--  : xpos, ypos
	)
	
	--  " "
	local btn_add_crystals = GML_UI_CreateCompent(form, BUTTON_TYPE, "storeAddCrystals", 14, 14, 775, 51)
	GML_UI_LoadButtonImage(btn_add_crystals, "texture/ui_morgan/buttons.png", 14, 14, 0, 155, TRUE)
	GML_UI_SetHint(btn_add_crystals, lstr(560))
	GML_UI_AddButtonLink(btn_add_crystals, "https://worldofmorgan.com/donate/")
	
	
	--   
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 91}, arr_size = {128, 421},
		castom_path = "texture/ui_morgan/form/bg_3.png"
	})
	
	
	--  
	local form_tree_menu = GML_UI_CreateCompent(form, TREE_TYPE, "storeTreeMenu", 142, 411, 11, 96)
	GML_UI_SetTextColor(form_tree_menu, COLOR_WHITE)
	
	GML_UI_TreeLoadImage(form_tree_menu, enumTreeAddImage, "texture/ui_morgan/buttons_12X12.png", 12, 12, 0, 0, 12, 12)
	GML_UI_TreeLoadImage(form_tree_menu, enumTreeSubImage, "texture/ui_morgan/buttons_12X12.png", 12, 12, 0, 12, 12, 12)
	
	L_DrawScroll(form_tree_menu, nil, 10)
	GML_UI_SetIsDrag(form_tree_menu, FALSE)
	
	--  
	local id_lot = 0
	for i = 1, 4 do
		for i2 = 1, 2 do
			id_lot = id_lot + 1
			
			local start_x = 143 + (229 * (i2 - 1))
			local start_y = 91 + (106 * (i - 1))
			
			--   
			L_CreateBG({
				form_name = form, arr_pos_area = {start_x, start_y}, arr_size = {226, 103}
			})
			
			--  
			L_Text(form, {
				system_name	= "storeItemTitle_"..id_lot,
				arr_size	= {217, 13},
				arr_area	= {start_x + 4, start_y + 8},
				--hint		= "",
				
				arr_text	= {
					text			= "sys.name: storeItemTitle_"..i,
					font			= DEFAULT_FONT,
					--color			= COLOR_WHITE,
					shadow			= FALSE,
					--shadow_color	= COLOR_WHITE,
					center		= 1,
				}
			})
			
			-- 
			L_Text(form, {
				system_name	= "storeItemRemain_"..id_lot,
				arr_size	= {216, 12},
				arr_area	= {start_x + 5, start_y + 67},
				hint		= lstr(561),
				
				arr_text	= {
					text			= i.." ",
					font			= MINI_FONT,
					--color			= COLOR_GRAY,
					shadow		= FALSE,
					--shadow_color	= COLOR_WHITE,
					--center		= 1,
					right	= 1,
				}
			})
			
			--   
			for i3 = 1, 5 do
				L_ItemBG(form, {start_x + 5 + (44 * (i3 - 1)), start_y + 24}, "texture/ui_morgan/form/items/item_bg__border_1.png", "storeItemSlotBG_"..id_lot.."_"..i3)
			end
			
			local grdStockBag = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, "storeItemSlot_"..id_lot, 212, 40, start_x + 9, start_y + 28)
			GML_UI_SetGridSpace(grdStockBag, 12, 0)
			GML_UI_SetGridContent(grdStockBag, 1, 5)
			GML_UI_SetGridUnitSize(grdStockBag, 32, 32)
			--GML_UI_SetMargin(grdStockBag, 0, 0, 0, 0)
			GML_UI_SetIsDrag(grdStockBag, FALSE)
			
			-- 
			local sale_1 = GML_UI_CreateCompent(form, IMAGE_TYPE, "storeSale_1_"..id_lot, 39, 18, start_x + 7, start_y + 79)
			GML_UI_LoadImage(sale_1, "texture/ui_morgan/store/di_hit.png", NORMAL, 39, 18, 0, 0)
			
			-- , 
			L_Text(form, {
				system_name	= "storeSale_1_text_"..id_lot,
				arr_size	= {27, 12},
				arr_area	= {start_x + 19, start_y + 82},
				hint		= lstr(562),
				
				arr_text	= {
					text			= lstr(563),
					--font			= MINI_FONT,
					--color			= COLOR_WHITE,
					shadow			= FALSE,
					--shadow_color	= COLOR_WHITE,
					center			= 1,
					--right			= 1,
					--money			= 1,
				}
			})
			
			
			-- 
			local sale_2 = GML_UI_CreateCompent(form, IMAGE_TYPE, "storeSale_2_"..id_lot, 70, 18, start_x + 7, start_y + 79)
			GML_UI_LoadImage(sale_2, "texture/ui_morgan/store/di_exclusive.png", NORMAL, 70, 18, 0, 0)
			
			-- , 
			L_Text(form, {
				system_name	= "storeSale_2_text_"..id_lot,
				arr_size	= {70, 12},
				arr_area	= {start_x + 7, start_y + 82},
				hint		= lstr(564),
				
				arr_text	= {
					text			= lstr(565),
					--font			= MINI_FONT,
					--color			= COLOR_WHITE,
					shadow			= FALSE,
					--shadow_color	= COLOR_WHITE,
					center			= 1,
					--right			= 1,
					--money			= 1,
				}
			})
			
			-- 
			local sale_3 = GML_UI_CreateCompent(form, IMAGE_TYPE, "storeSale_3_"..id_lot, 33, 18, start_x + 7, start_y + 79)
			GML_UI_LoadImage(sale_3, "texture/ui_morgan/store/di_text.png", NORMAL, 29, 18, 0, 0)
			
			-- , 
			L_Text(form, {
				system_name	= "storeSale_3_text_"..id_lot,
				arr_size	= {33, 12},
				arr_area	= {start_x + 8, start_y + 84},
				hint		= lstr(566),
				
				arr_text	= {
					text			= "-50%",
					font			= FONT14,
					color			= color("#FFFFFFFF"),
					shadow		= FALSE,
					--shadow_color	= COLOR_WHITE,
					center		= 1,
					--right		= 1,
					--money		= 1,
				}
			})
			
			
			--    
			local sale_4 = GML_UI_CreateCompent(form, IMAGE_TYPE, "storeSale_4_"..id_lot, 63, 18, start_x + 7, start_y + 79)
			GML_UI_LoadImage(sale_4, "texture/ui_morgan/store/di_text_time.png", NORMAL, 55, 18, 0, 0)
			
			--    , 
			L_Text(form, {
				system_name	= "storeSale_4_text_"..id_lot,
				arr_size	= {63, 12},
				arr_area	= {start_x + 7, start_y + 83},
				hint		= lstr(567),
				
				arr_text	= {
					text			= "00:00:00",
					--font			= MINI_FONT,
					--color			= COLOR_WHITE,
					shadow		= FALSE,
					--shadow_color	= COLOR_WHITE,
					center		= 1,
					--right		= 1,
					--money		= 1,
				}
			})
			
			-- 
			L_Text(form, {
				system_name	= "storeItemCost_"..id_lot,
				arr_size	= {66, 12},
				arr_area	= {start_x + 89, start_y + 83},
				hint		= lstr(568),
				
				arr_text	= {
					text			= (i * 10) .. "",
					--font			= DEFAULT_FONT,
					--color			= COLOR_WHITE,
					shadow		= FALSE,
					--shadow_color	= COLOR_WHITE,
					--center		= 1,
					right		= 1,
					money		= 1,
				}
			})
			
			local img_cr_lot = GML_UI_CreateCompent(form, IMAGE_TYPE, "storeBifCr"..math.random(1,10000), 12, 12, start_x + 156, start_y + 83)
			GML_UI_LoadImage(img_cr_lot, "texture/ui_morgan/buttons.png", NORMAL, 12, 12, 12, 61)
			
			--     
			L_OldRowInput(
				form, 
				"storeItemInpCount_"..id_lot, 
				1,																-- type (1 --   )
				3,																--   
				lstr(569),																-- hint
				{49, 18},														-- : width, height
				{start_x + 172, start_y + 79}										--  : xpos, ypos
			)
			
			
			--   
			local btnStoreBuy = GML_UI_CreateCompent(form, BUTTON_TYPE, "storeItemBtnBuy_"..id_lot, 14, 14, start_x + 205, start_y + 81)
			GML_UI_LoadButtonImage(btnStoreBuy, "texture/ui_morgan/buttons_14X14.png", 14, 14, 57, 168, TRUE)
			GML_UI_SetHint(btnStoreBuy, lstr(570))
			
			
			--   
			L_CreateBG({
				form_name = form, arr_pos_area = {start_x, start_y}, arr_size = {226, 103}, 
				system_name = "storeLotOverBG_"..id_lot,
				castom_path = "texture/ui_morgan/form/bg_3.png"
			})
		end
	end
	
	
	----
	-- 
	----
	local start_area = {x = 603, y = 91}
	
	
	--   
	L_CreateBG({
		form_name = form, arr_pos_area = {start_area.x, start_area.y}, arr_size = {187, 316},
		castom_path = "texture/ui_morgan/form/bg_3.png"
	})
	
	local img = GML_UI_CreateCompent(form, IMAGE_TYPE, "store_bg_cha", 186, 314, start_area.x + 1, start_area.y + 1)
	GML_UI_LoadImage(img, "texture/ui_morgan/store/cha_bg.png", NORMAL, 186, 314, 0, 0)
	
	
	
	--  ""
	L_Text(form, {
		--system_name	= "storeItemRemain_"..id_lot,
		arr_size	= {187, 12},
		arr_area	= {start_area.x, start_area.y + 8},
		hint		= "",
		
		arr_text	= {
			text			= lstr(583),
			--font			= FONT14,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
			--right	= 1,
		}
	})
	
	--  "   "
	L_Text(form, {
		--system_name	= "storeItemRemain_"..id_lot,
		arr_size	= {187, 12},
		arr_area	= {start_area.x, start_area.y + 24},
		hint		= "",
		
		arr_text	= {
			text			= lstr(584),
			font			= MINI_FONT,
			color			= COLOR_GRAY4,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
			--right	= 1,
		}
	})
	
	--  "   ."
	L_Text(form, {
		--system_name	= "storeItemRemain_"..id_lot,
		arr_size	= {187, 12},
		arr_area	= {start_area.x, start_area.y + 36},
		hint		= "",
		
		arr_text	= {
			text			= lstr(585),
			font			= MINI_FONT,
			color			= COLOR_GRAY4,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
			--right	= 1,
		}
	})
	
	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "3542452", 192, 100, start_area.x + 1, start_area.y + 130)
	GML_UI_LoadButtonAniImage(btn, "texture/ui_morgan/inventory/cha_bg_anim_16_back.protect", 32, 192, 100, 0, 0, 35, 5000, 7)
	GML_UI_SetIgnoreScroll(btn, TRUE)
	GML_UI_DisableCursorReplace(btn)


	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, "3542452", 192, 100, start_area.x + 1, start_area.y + 126)
	GML_UI_LoadButtonAniImage(btn, "texture/ui_morgan/inventory/cha_bg_anim_16_front.protect", 32, 192, 100, 0, 0, 35, 5000, 7)
	GML_UI_SetIgnoreScroll(btn, TRUE)
	GML_UI_DisableCursorReplace(btn)
	GML_UI_SetHint(btn, lstr(784))
	
	local storeBtnLeft3D = GML_UI_CreateCompent(form, BUTTON_TYPE, "storeBtnLeft3D", 25, 8, start_area.x + 10 + 9 + 10 + 5 + 2, start_area.y + 208 - 15 - 20 + 55 - 21-2 + 4 + 2)
	GML_UI_LoadButtonImage(storeBtnLeft3D, "texture/ui_morgan/buttons.png", 37, 16, 0, 309, TRUE)
	GML_UI_SetHint(storeBtnLeft3D, lstr(780))
	
	local storeBtnRight3D = GML_UI_CreateCompent(form, BUTTON_TYPE, "storeBtnRight3D", 25, 8, start_area.x + 142 - 9 - 10 + 6 -2, start_area.y + 208 - 15 - 20 + 55 - 21-2 + 5)
	GML_UI_LoadButtonImage(storeBtnRight3D, "texture/ui_morgan/buttons.png", 37, 16, 0, 325, TRUE)
	GML_UI_SetHint(storeBtnRight3D, lstr(780))
	
		-- 3D 
	GML_UI_CreateCompent(form, UI3D_COMPENT, "storeCha3D", 0, 0, start_area.x + 39 + 50 + 3, start_area.y + 62 + 61 - 15 + 3 + 2 + 3)
	

	
	--    1 
	L_GenItemBG(form, {alfa_first_bg = math.ceil(255 * 80 / 100), arr_area = {start_area.x + 57 - 18, start_area.y + 232 - 15 + 2 + 3 + 3}, bg_second = "item_bg__weapon_1"})
	L_GenItemBG(form, {alfa_first_bg = math.ceil(255 * 80 / 100), arr_area = {start_area.x + 94 - 19, start_area.y + 232 - 15 + 2 + 3 + 3}, bg_second = "item_bg__weapon_2"})
	-- 
	L_GenItemBG(form, {alfa_first_bg = math.ceil(255 * 80 / 100), arr_area = {start_area.x + 94 + 17, start_area.y + 232 - 15 + 2 + 3 + 3}, bg_second = "item_bg__wings"})
	
	local grdStockBag = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, "storeFittingItemSlots_row_1", 77 + 100, 40 + 100, start_area.x + 59- 18, start_area.y + 236 - 15 + 3 + 2)
	GML_UI_SetGridSpace(grdStockBag, 4, 4)
	GML_UI_SetGridContent(grdStockBag, 1, 3)
	GML_UI_SetGridUnitSize(grdStockBag, 32, 32)
	--GML_UI_SetMargin(grdStockBag, 0, 0, 0, 0)
	GML_UI_SetIsDrag(grdStockBag, FALSE)
	
	--    2 
	L_GenItemBG(form, {alfa_first_bg = math.ceil(255 * 80 / 100), arr_area = {start_area.x + 18 + 2, start_area.y + 269 - 15 + 2 + 3 + 2}, bg_second = "item_bg__head"})
	L_GenItemBG(form, {alfa_first_bg = math.ceil(255 * 80 / 100), arr_area = {start_area.x + 92 + 2, start_area.y + 269 - 15 + 2 + 3 + 2}, bg_second = "item_bg__body"})
	L_GenItemBG(form, {alfa_first_bg = math.ceil(255 * 80 / 100), arr_area = {start_area.x + 55 + 2, start_area.y + 269 - 15 + 2 + 3 + 2}, bg_second = "item_bg__hands"})
	L_GenItemBG(form, {alfa_first_bg = math.ceil(255 * 80 / 100), arr_area = {start_area.x + 129 + 2, start_area.y + 269 - 15 + 2 + 3 + 2}, bg_second = "item_bg__foot"})
	
	
	local grdStockBag = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, "storeFittingItemSlots_row_2", 151 + 100 + 3, 40 + 100 + 3, start_area.x + 24, start_area.y + 273 - 15 + 3 + 2)
	GML_UI_SetGridSpace(grdStockBag, 4, 4)
	GML_UI_SetGridContent(grdStockBag, 1, 4)
	GML_UI_SetGridUnitSize(grdStockBag, 32, 32)
	--GML_UI_SetMargin(grdStockBag, 0, 0, 0, 0)
	GML_UI_SetIsDrag(grdStockBag, FALSE)
	
	--  "  "
	L_Text(form, {
		--system_name	= "storeItemRemain_"..id_lot,
		arr_size	= {187, 12},
		arr_area	= {start_area.x + 18 + 20 - 35 + 3, start_area.y + 269 - 20 + 44 + 1 + 5 + 3},
		hint		= "",
		
		arr_text	= {
			text			= lstr(586),
			font			= MINI_FONT,
			color			= COLOR_GRAY,
			shadow			= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
			--right	= 1,
		}
	})
	
	local chk_box = GML_UI_CreateCompent(form, CHECK_TYPE, "storeChkBoxShowForge", 147, 10, start_area.x + 24 - 3, start_area.y + 269 - 20 + 44 + 5 + 3)
	GML_UI_LoadImage(chk_box, "texture/ui_morgan/store/btn_checkbox_forge.png", CHECKED, 147, 10, 0, 0)
	GML_UI_LoadImage(chk_box, "texture/ui_morgan/store/btn_checkbox_forge.png", UNCHECKED, 147, 10, 0, 10)
	GML_UI_SetHint(chk_box, lstr(586))

	----
	--  
	----
	
	local start_area = {x = 603, y = 409}
	
	
	--    
	L_CreateBG({
		form_name = form, arr_pos_area = {start_area.x, start_area.y}, arr_size = {187, 104},
		castom_path = "texture/ui_morgan/form/bg_3.png"
	})
	
	--  " "
	L_Text(form, {
		--system_name	= "storeItemRemain_"..id_lot,
		arr_size	= {187, 12},
		arr_area	= {start_area.x, start_area.y + 8},
		hint		= "",
		
		arr_text	= {
			text			= lstr(587),
			--font			= FONT14,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
			--right	= 1,
		}
	})
	
	--    
	L_SetFormItems(form, {
		system_name	= "storeItemsLastPay",						--   
		arr_area	= {start_area.x + 2, start_area.y + 23},	--   
		arr_grid_space	= {4, 4},								--    {, }
		arr_items	= {
			col = 5,							--  ,
			row = 2								--  
		},
		castom_bg_icon = "texture/ui_morgan/form/items/item_bg__border_1.png"
	})
	
	
	
	----
	-- footer
	----
	
	--  " "
	local BtnBackPage = GML_UI_CreateCompent(form, BUTTON_TYPE, "storeNextBtn", 16, 16, 391, 522)
	GML_UI_LoadButtonImage(BtnBackPage, "texture/ui_morgan/buttons.png", 16, 16, 0, 125, TRUE)
	
	--  
	L_RowText(
		form, 
		"storeNowPage", 
		1,								-- type (gold)
		"",	-- hint 
		{37, 19},						-- : width, height
		{352, 520},						--  : xpos, ypos
		1
	)
	
	--  " "
	local BtnNextPage = GML_UI_CreateCompent(form, BUTTON_TYPE, "storeBackBtn", 16, 16, 334, 522)
	GML_UI_LoadButtonImage(BtnNextPage, "texture/ui_morgan/buttons.png", 16, 16, 0, 109, TRUE)

end
GenFormStore()


----
-- :  
----
function GenFormSeason()
	--    
	local form = L_SetForm({
		system_name	= "seasonForm",
		arr_size	= {566 - 4, 412- 21 - 5},
		text_title	= lstr(588)
	})
	
	
	----
	--  
	----
	
	local block_1__a_pos	= {10, 27}
	local block_1__a_size	= {177, 68}
	
	--  
	L_CreateBG({
		form_name = form, arr_pos_area = block_1__a_pos, arr_size = block_1__a_size
	})
	
	--    ( ,   goldenticket_1  )
	local golden_ticket__img = GML_UI_CreateCompent(form, IMAGE_TYPE, "seasonMainPict", 46, 26, block_1__a_pos[1] + 10, block_1__a_pos[2] + 8 + 10 + 2)
	GML_UI_LoadImage(golden_ticket__img, "texture/ui_morgan/battle_pass/goldenticket_0.png", NORMAL, 46, 26, 0, 0)
	
	-- 
	L_TextArea(form, {
		cpt_arr_area	= {block_1__a_pos[1] + 66, block_1__a_pos[2] + 10 + 2},
		
		arr_text = {
			lstr(589),
			lstr(590),
		},
		
		text_width		= 102,
		text_font		= DEFAULT_FONT,
		text_color		= COLOR_WHITE,
		text_shadow		= FALSE,
		text_center		= 1,
	})
	
	------  
	--L_hr(form, {
	--	width		= block_1__a_size[1] - 1,
	--	arr_area	= {block_1__a_pos[1] + 1, block_1__a_pos[2] + 40},
	--	alfa		= 30,
	--})
	
	--  ""
	local arr_data = {
		system_name			= "seasonMainBtn",													--   
		text				= lstr(591),										-- ""   
		hint				= lstr(592),	-- " "   
		arr_area			= {block_1__a_pos[1] + 35+ 22 + 10  + 16, block_1__a_pos[2] + 42},															--  
		text_system_name	= "seasonMainBtnText",										--   
	}
	L_StaticBtn(form, arr_data)
	
	
	----
	--  2
	----
	
	local block_2__a_pos	= {block_1__a_pos[1] + block_1__a_size[1] + 5, 27}
	local block_2__a_size	= {177, 68}
	
	--  
	L_CreateBG({
		form_name = form, arr_pos_area = block_2__a_pos, arr_size = block_2__a_size
	})
	
	--   2 ( ,   golden_up_2_1  )
	local up2__img = GML_UI_CreateCompent(form, IMAGE_TYPE, "seasonBoostX2Pict", 29 + 7, 29 + 7, block_2__a_pos[1] + 16, block_2__a_pos[2] + 8 + 8)
	GML_UI_LoadImage(up2__img, "texture/ui_morgan/battle_pass/golden_up_2_0.png", NORMAL, 29, 29, 0, 0)
	
	-- 
	L_TextArea(form, {
		cpt_arr_area	= {block_2__a_pos[1] + 66, block_2__a_pos[2] + 10 + 2},
		
		arr_text = {
			lstr(593),
			lstr(594),
		},
		
		text_width		= 102,
		text_font		= DEFAULT_FONT,
		text_color		= COLOR_WHITE,
		text_shadow		= FALSE,
		text_center		= 1,
	})
	
	------  
	--L_hr(form, {
	--	width		= block_1__a_size[1] - 1,
	--	arr_area	= {block_1__a_pos[1] + 1, block_1__a_pos[2] + 40},
	--	alfa		= 30,
	--})
	
	--  ""
	local arr_data = {
		system_name			= "seasonBoostX2Time",													--   
		text				= lstr(595),										-- ""   
		hint				= lstr(596),	-- " "   
		arr_area			= {block_2__a_pos[1] + 35+ 22 + 10  + 16, block_2__a_pos[2] + 42},															--  
		text_system_name	= "seasonBoostX2Text",										--   
	}
	L_StaticBtn(form, arr_data)
	
	----
	--  3
	----
	
	local block_3__a_pos	= {block_2__a_pos[1] + block_2__a_size[1] + 5, 27}
	local block_3__a_size	= {177, 68}
	
	--  
	L_CreateBG({
		form_name = form, arr_pos_area = block_3__a_pos, arr_size = block_3__a_size
	})
	
	--   2 ( ,   golden_up_2_1  )
	local up3__img = GML_UI_CreateCompent(form, IMAGE_TYPE, "seasonBoostX3Pict", 29 + 10, 29 + 10, block_3__a_pos[1] + 16, block_3__a_pos[2] + 8 + 8)
	GML_UI_LoadImage(up3__img, "texture/ui_morgan/battle_pass/golden_up_3_0.png", NORMAL, 32, 32, 0, 0)
	
	-- 
	L_TextArea(form, {
		cpt_arr_area	= {block_3__a_pos[1] + 66, block_3__a_pos[2] + 10 + 2},
		
		arr_text = {
			lstr(597),
			lstr(598),
		},
		
		text_width		= 102,
		text_font		= DEFAULT_FONT,
		text_color		= COLOR_WHITE,
		text_shadow		= FALSE,
		text_center		= 1,
	})
	
	------  
	--L_hr(form, {
	--	width		= block_1__a_size[1] - 1,
	--	arr_area	= {block_1__a_pos[1] + 1, block_1__a_pos[2] + 40},
	--	alfa		= 30,
	--})
	
	--  ""
	local arr_data = {
		system_name			= "seasonBoostX3Time",													--   
		text				= lstr(599),										-- ""   
		hint				= lstr(600),	-- " "   
		arr_area			= {block_3__a_pos[1] + 35+ 22 + 10  + 16, block_3__a_pos[2] + 42},															--  
		text_system_name	= "seasonBoostX3Text",										--   
	}
	L_StaticBtn(form, arr_data)
	
	
	
	----
	--  
	----
	
	--   
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 100}, arr_size = {360 + 182, 83}
	})
	
	--  "  "
	L_TextArea(form, {
		cpt_arr_area = {11, 115},
		
		arr_text = {
			lstr(601),
			lstr(602),
		},
		
		text_width	= 359,
		text_font			= DEFAULT_FONT,
		text_color			= COLOR_WHITE,
		text_shadow			= FALSE,
		text_center			= 1,
	})
	
	--    
	L_RowText(
		form, 
		"SeasonProgress", 
		1,																				-- type (gold)
		"",	-- hint 
		{340, 18},																		-- : width, height
		{20, 155}																		--  : xpos, ypos
	)
	
	local seasonProgress = GML_UI_CreateCompent(form, PROGRESS_TYPE, "seasonProgress", 340, 18, 21, 156)
	GML_UI_LoadScaleImage(seasonProgress, "texture/ui_morgan/battle_pass/load.png", PROGRESS_PROGRESS, 338, 16, 0, 0, 1.0, 1.0)
	GML_UI_SetHint(seasonProgress, lstr(603))
	
	L_Text(form, {
		system_name	= "seasonChaPoints",
		arr_size	= {340, 12},
		arr_area	= {21, 158},
		--hint		= "",
		
		arr_text	= {
			text			= "5 000\\45 000",
			--font			= FONT36,
			--color			= COLOR_GRAY,
			--shadow			= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
		}
	})
	
	--  
	L_Text(form, {
		system_name	= "seasonNowLv",
		arr_size	= {48, 30},
		arr_area	= {22, 105},
		--hint		= "",
		
		arr_text	= {
			text			= "39",
			font			= FONT36,
			--color			= COLOR_GRAY,
			shadow			= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
		}
	})
	
	L_Text(form, {
		--system_name	= "",
		arr_size	= {81, 12},
		arr_area	= {22, 138},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(604),
			--font			= FONT36,
			--color			= COLOR_GRAY,
			shadow			= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
		}
	})
	
	--  
	L_Text(form, {
		system_name	= "seasonNextLv",
		arr_size	= {48, 30},
		arr_area	= {311, 105},
		--hint		= "",
		
		arr_text	= {
			text			= "40",
			font			= FONT36,
			color			= COLOR_GRAY,
			shadow			= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
		}
	})
	
	L_Text(form, {
		--system_name	= "",
		arr_size	= {71, 12},
		arr_area	= {310, 138},
		--hint		= "",
		
		arr_text	= {
			text			= lstr(604),
			--font			= DEFAULT_FONT,
			color			= COLOR_GRAY,
			shadow			= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
		}
	})
	
	----
	--   
	----
	
	--  
	local bg_season_block = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_season_block", 179, 82, 372, 101)
	GML_UI_LoadImage(bg_season_block, "texture/ui_morgan/battle_pass/bg_hell.png", NORMAL, 179, 82, 0, 0)
	
	-- 
	L_TextArea(form, {
		cpt_arr_area	= {372, 110},
		
		arr_text = {
			lstr(605),
			lstr(825),
			lstr(606),
			lstr(607),
		},
		
		text_width		= 179,
		text_font		= DEFAULT_FONT,
		text_color		= COLOR_WHITE,
		text_shadow		= FALSE,
		text_center		= 1,
	})
	
	--  ""
	local arr_data = {
		system_name			= "seasonGuide",													--   
		text				= lstr(608),										-- ""   
		hint				= lstr(609),	-- " "   
		arr_area			= {372 + 90 - 33, 100 + 70 - 8},															--  
		link				= "https://worldofmorgan.com/r/season_24",
	}
	L_StaticBtn(form, arr_data)
	
	
	
	
	
		
	--   
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 215 - 21 - 5}, arr_size = {542, 187}
	})
	
	--   
	
		--  " "
		
		L_TextArea(form, {
			cpt_arr_area	= {11, 265 + 4- 21 - 5},
			--cpt_hint		= "",
			--cpt_label_type	= LABELEX_TYPE,
			
			arr_text			=	{
				-- : "  "
				lstr(610),
				lstr(611),
			},
			
			text_width	= 82,
			--text_hight			= 12,
			text_font			= DEFAULT_FONT,
			text_color			= COLOR_WHITE,
			text_shadow			= FALSE,
			--text_shadow_color	= COLOR_BLACK,
			text_center			= 1,
			--text_right			= 0,
		})
		
		--  
			local imgGoldTicket2 = GML_UI_CreateCompent(form, IMAGE_TYPE, "seasonGoldPass", 46, 26, 28, 234- 21 - 5)
			GML_UI_LoadImage(imgGoldTicket2, "texture/ui_morgan/battle_pass/goldenticket_1.png", NORMAL, 46, 26, 0, 0)
			
					
		
		--  
			local img = GML_UI_CreateCompent(form, IMAGE_TYPE, "seasonNotGoldPass", 46, 26, 28, 308- 21- 5)
			GML_UI_LoadImage(img, "texture/ui_morgan/battle_pass/goldenticket_3.png", NORMAL, 46, 26, 0, 0)
			
		L_TextArea(form, {
			cpt_arr_area	= {11, 339 + 4- 21- 5},
			--cpt_hint		= "",
			--cpt_label_type	= LABELEX_TYPE,
			
			arr_text			=	{
				-- : "  "
				lstr(612),
				
				lstr(730),
			},
			
			text_width	= 82,
			--text_hight			= 12,
			text_font			= DEFAULT_FONT,
			text_color			= COLOR_WHITE,
			text_shadow			= FALSE,
			--text_shadow_color	= COLOR_BLACK,
			text_center			= 1,
			--text_right			= 0,
		})
		
		
		--    
		for i = 1, 6 do
			L_ItemBG(form, {106 + ((i - 1) * 77), 233- 21- 5}, "texture/ui_morgan/form/items/item_bg_gold.png", "seasonItemBg"..i)
		end
		
		--    
		for i = 7, 12 do
			L_ItemBG(form, {106 + ((i - 7) * 77), 306- 21- 5}, nil, "seasonItemBg"..i)
		end
		
			
		--	 
			for i = 1, 6, 1 do
				--  "i" ( )
				L_Text(form, {
					system_name	= "seasonLv"..(i-1),
					arr_size	= {15, 15},
					arr_area	= {118 + ((i - 1) * 77), 219- 21- 5},
					--hint		= "",
					
					arr_text	= {
						text			= tostring(i),
						--font			= DEFAULT_FONT,
						color			= COLOR_GRAY,
						shadow			= FALSE,
						--shadow_color	= COLOR_WHITE,
						--center		= 1,
					}
				})
			end
			
			
				
		-- 
			local grdStockBag = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, "seasonItemSlots", 265 + 285, 150, 110, 237- 21- 5)
			GML_UI_SetGridSpace(grdStockBag, 45, 42)
			GML_UI_SetGridContent(grdStockBag, 2, 6)
			GML_UI_SetGridUnitSize(grdStockBag, 32, 32)
			--GML_UI_SetMargin(grdStockBag, 0, 0, 0, 0)
			GML_UI_SetIsDrag(grdStockBag, FALSE)
			
			
		--  "" 
			--   
				for i = 0, 5 do
					local arr_data = {
						system_name			= "seasonGoldBtn"..i,											--   
						text				= lstr(613),								-- ""   
						hint				= lstr(614),	-- " "   
						arr_area			= {93 + ((i) * 77), 279- 21- 5},										--  
						text_system_name	= "seasonTextGoldBtn"..i,										--   
					}
					L_StaticBtn(form, arr_data)
				end

			--   
				for i = 0, 5 do
					local arr_data = {
						system_name			= "seasonDefaultBtn"..i,											--   
						text				= lstr(613),								-- ""   
						hint				= lstr(614),	-- " "   
						arr_area			= {93 + ((i) * 77), 351- 21- 5},									--  
						text_system_name	= "seasonTextDefaultBtn"..i,										--   
					}
					L_StaticBtn(form, arr_data)
				end

			
	--   
		--  
	
			L_RowText(
				form, 
				"seasonNowPage", 
				1,								-- type (gold)
				"",	-- hint 
				{37, 18},						-- : width, height
				{188 + 142 - 68, 378- 21- 5},						--  : xpos, ypos
				1
			)
		--  \
		
			local BtnNextPage = GML_UI_CreateCompent(form, BUTTON_TYPE, "seasonBackBtn", 16, 16, 171+ 142 - 68, 379- 21- 5)
			GML_UI_LoadButtonImage(BtnNextPage, "texture/ui_morgan/buttons.png", 16, 16, 0, 109, TRUE)
			
			local BtnBackPage = GML_UI_CreateCompent(form, BUTTON_TYPE, "seasonNextBtn", 16, 16, 226+ 142 - 68, 379- 21- 5)
			GML_UI_LoadButtonImage(BtnBackPage, "texture/ui_morgan/buttons.png", 16, 16, 0, 125, TRUE)
	
end
GenFormSeason()

----
-- : 
----

function GenFormChaBuy()

	--   
	function GenFormChaBuy_main()
		--    
		local form = L_SetForm({
			system_name	= "f_purchase_market",
			arr_size	= {800 - 261 - 40-10, 600 - 57 + 31 - 60 - 10 - 15 - 5 - 15},
			arr_area	= {0, 100},
			text_title	= lstr(615)
		})
		GML_UI_SetFormStyle(form, 2)
		
		
		-- -
		--  ,   ,     .
		--  ,   .
		--       !
		L_TextArea(form, {
			cpt_arr_area	= {0, 22 + 10 - 2},
			--cpt_hint		= "",
			--cpt_label_type	= LABELEX_TYPE,
			
			arr_text			=	{
				-- : "  "
				lstr(616),
				
				lstr(617),
			},
			
			text_width	= 539 - 40 - 10,
			--text_hight			= 12,
			text_font			= ARIAL_FONT,
			text_color			= COLOR_GRAY3,
			text_shadow			= FALSE,
			--text_shadow_color	= COLOR_BLACK,
			text_center			= 1,
			--text_right			= 0,
		})
		
		--    "  "
		L_Input(form, {
			name				= "inp_search_item",
			a_size				= {201, 18},
			a_pos				= {10, 57},
			type_id				= 1,
			max_count_simbol	= 20,
			text_hint			= "  ",
			placeholder			= "  ",
			cursor_color		= "#FFD0D0D0",
		})
		
		--  " "
		local btnStockSearchCancle = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_search_item_cancle", 14, 14, 10 + 164 - 2 - 14 - 2 - 14 + 94- 57, 49 - 3 + 2+ 31- 10 - 10)
		GML_UI_LoadButtonImage(btnStockSearchCancle, "texture/ui_morgan/buttons.png", 14, 14, 0, 141, TRUE)
		GML_UI_SetHint(btnStockSearchCancle, lstr(619))
		
		--  " "
		local btnStockSearch = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_search_item", 14, 14, 10 + 164 - 2 - 14+ 94- 57, 49 - 3 + 2+ 31- 10 - 10)
		GML_UI_LoadButtonImage(btnStockSearch, "texture/ui_morgan/buttons.png", 14, 14, 0, 183, TRUE)
		GML_UI_SetHint(btnStockSearch, lstr(620))
		GML_UI_FormSetEnterButton(form, btnStockSearch)
		
		-- :  
		L_btn(form, {
			system_name	= "btn_all_lots",
			text		= lstr(621),
			width		= nil,
			arr_area	= {581 - 261- 40 - 10 - 1, 47+ 31- 10 - 10},
			hint		= nil,
			action_id	= nil,
		})
		
		-- :  
		L_btn(form, {
			system_name	= "btn_my_lots",
			text		= lstr(622),
			width		= nil,
			arr_area	= {652 - 261- 40 - 10 - 1, 47+ 31- 10 - 10},
			hint		= nil,
			action_id	= nil,
		})
		
		-- : 
		L_btn(form, {
			system_name	= "btn_add_lot",
			text		= lstr(623),
			width		= nil,
			arr_area	= {723 - 261- 40 - 10 - 1, 47+ 31- 10 - 10},
			hint		= nil,
			action_id	= nil,
		})
		
		local id_cell = 0
		for i = 1, 14 do
			id_cell = i
			
			local widht_bg = 257 - 20 - 5
			local height_bg = 103 - 32 - 12 - 10
			
			local start_x = 10
			
			local i2 = i
			if i > 7 then
				start_x = 271 - 20 - 5
				i2 = i - 7
			end
			
			local start_y = 72 + ((height_bg + 3) * (i2 - 1)) + 31 - 10 - 15
			
			--   
			L_CreateBG({
				form_name = form, arr_pos_area = {start_x, start_y}, arr_size = {widht_bg, height_bg}
			})
			
			--  
			L_Text(form, {
				system_name	= "txt_lot_name_"..id_cell,
				arr_size	= {217, 13},
				arr_area	= {start_x + 10 + 36 + 6 - 5, start_y + 10 + 2 - 5 + 2},
				--hint		= "",
				
				arr_text	= {
					text			= "",
					font			= DEFAULT_FONT,
					color			= COLOR_WHITE,
					shadow			= FALSE,
					--shadow_color	= COLOR_WHITE,
					--center		= 1,
				}
			})
			
			-- : "  1 :"
			L_Text(form, {
				system_name	= "txt_lot_cost_"..id_cell,
				arr_size	= {79, 12},
				arr_area	= {start_x + 10 + 36 + 6 - 5, start_y + 26 + 1- 5+1},
				hint		= "",
				
				arr_text	= {
					text			= lstr(624),
					font			= ARIAL_FONT,
					color			= COLOR_GRAY3,
					shadow		= FALSE,
					--shadow_color	= COLOR_WHITE,
					--center		= 1,
					--right	= 1,
				}
			})
	
			
			-- :  :
			L_Text(form, {
				system_name	= "txt_lot_count_"..id_cell,
				arr_size	= {92, 12},
				arr_area	= {start_x + 10 + 36 + 6- 5, start_y + 38+ 1- 5-1+1},
				hint		= "",
				
				arr_text	= {
					text			= lstr(625),
					font			= ARIAL_FONT,
					color			= COLOR_GRAY3,
					shadow		= FALSE,
					--shadow_color	= COLOR_WHITE,
					--center		= 1,
					--right	= 1,
				}
			})
			
			--   ( )
			L_Text(form, {
				system_name	= "txt_lot_id_"..id_cell,
				arr_size	= {40, 12},
				arr_area	= {start_x + 10 - 5 + 150 + 30, start_y + 10 + 4 + 33 + 2 +1- 5 - 3 - 5},
				hint		= "",
				
				arr_text	= {
					text			= "00000",
					font			= FONT9,
					color			= COLOR_GRAY,
					shadow		= FALSE,
					--shadow_color	= COLOR_WHITE,
					--center		= 1,
					right	= 1,
				}
			})
			
			--   
			L_ItemBG(form, {start_x + 10- 5, start_y + 10- 5}, "texture/ui_morgan/form/items/item_bg__border_2.png")
			
			GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "lot_item_"..id_cell, 32, 32, start_x + 14- 5, start_y + 14- 5)
			
			--     
			local btn_lot_buy = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_lot_buy_"..id_cell, widht_bg, height_bg, start_x, start_y)
			GML_UI_SetHint(btn_lot_buy, lstr(626))
			
			--   
			local btn_lot_del = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_lot_del_"..id_cell, 12, 12, start_x + 243- 26, start_y + 3- 5 + 5)
			GML_UI_LoadButtonImage(btn_lot_del, "texture/ui_morgan/buttons_14X14.png", 14, 14, 0, 0, TRUE)
			GML_UI_SetHint(btn_lot_del, lstr(627))
			
		end
		
		----
		-- footer
		----
		
		-- 
		L_GenPag(form, {system_name = "pgs_lots", arr_area = {0, 512 + 31- 70- 10 - 5 - 15}, width = 800 - 261 - 40 -11, width_text_bg = 48})
	end
	GenFormChaBuy_main()
	
	-- :    
	function GenFormChaBuy_add_lot()
		local form = L_SetForm({
			system_name	= "f_purchase_market_add_lot",
			arr_size	= {343, 368 + 5},
			arr_area	= {0, 185},
			--    
			text_title	= lstr(628)
		})
		GML_UI_SetFormStyle(form, 2)
		--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_U)
		
		--  " "
		L_Text(form, {
			--system_name	= "",
			arr_size	= {323, 12},
			arr_area	= {10, 32},
			--hint		= "",
			
			arr_text	= {
				text			= lstr(629),
				--font			= ITEMS_NAME,
				--color			= COLOR_WHITE,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				center		= 1,
			}
		})
		
		-- 
		L_CreateBG({
			form_name = form, arr_pos_area = {10, 49}, arr_size = {323, 287 + 5}
		})
		
		
		--   ([    ])
		L_Text(form, {
			system_name	= "txt_lot_name",
			arr_size	= {262, 12},
			arr_area	= {61, 60},
			--hint		= "",
			
			arr_text	= {
				text			= lstr(630),
				font			= DEFAULT_FONT,
				color			= COLOR_WHITE,
				shadow			= FALSE,
				--shadow_color	= COLOR_WHITE,
				--center		= 1,
			}
		})
		
		-- : "  1 : ? ."
		L_Text(form, {
			system_name	= "txt_lot_cost",
			arr_size	= {262, 12},
			arr_area	= {61, 74},
			hint		= "",
			
			arr_text	= {
				text			= lstr(631),
				font			= FONT14,
				color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				--center		= 1,
				--right	= 1,
			}
		})
		
		
		-- : " : ? ."
		L_Text(form, {
			system_name	= "txt_lot_count",
			arr_size	= {262, 12},
			arr_area	= {61, 86},
			hint		= "",
			
			arr_text	= {
				text			= lstr(632),
				font			= FONT14,
				color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				--center		= 1,
				--right	= 1,
			}
		})
		
		--   
		L_GenItemBG(form, {arr_area = {20, 59}})
		GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "item_lot", 32, 32, 20 + 2, 59 + 2)
		
		
		
		----  
		L_hr(form, {
			width		= 321,
			arr_area	= {11, 106},
			alfa		= 50,
		})
		
		
		--    "  "
		L_OldRowInput(
			form, 
			"inp_search_item", 
			1,																-- type (1 --   )
			32,																--   
			"",																-- hint
			{199, 18},														-- : width, height
			{72, 117}														--  : xpos, ypos
		)
		
		--  " "
		local btnStockSearchCancle = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_search_item_cancle", 14, 14, 239, 119)
		GML_UI_LoadButtonImage(btnStockSearchCancle, "texture/ui_morgan/buttons.png", 14, 14, 0, 141, TRUE)
		GML_UI_SetHint(btnStockSearchCancle, lstr(633))
		
		--  " "
		local btnStockSearch = GML_UI_CreateCompent(form, BUTTON_TYPE, "btn_search_item", 14, 14, 255, 119)
		GML_UI_LoadButtonImage(btnStockSearch, "texture/ui_morgan/buttons.png", 14, 14, 0, 183, TRUE)
		GML_UI_SetHint(btnStockSearch, lstr(634))
		GML_UI_FormSetEnterButton(form, btnStockSearch)
		
		
		for i = 1, 8 do
			local area_x = 20 + ((i - 1) * 38)
			local area_y = 145 
			
			--   
			L_GenItemBG(form, {arr_area = {area_x, area_y}})
		end
		
		--    #
		local mountsGrid = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, "grd_items", 302, 50, 22, 147)
		GML_UI_SetGridSpace(mountsGrid, 6, 3)
		GML_UI_SetGridContent(mountsGrid, 1, 8)
		GML_UI_SetGridUnitSize(mountsGrid, 32, 32)
		GML_UI_SetMargin(mountsGrid, 0, 0, 0, 0)
		L_DrawScroll(mountsGrid, 150, 2)
		
		-- 
		L_GenPag(form, {system_name = "pgs_lots", arr_area = {0, 186}, width = 343, width_text_bg = 47})
		
		----  
		L_hr(form, {
			width		= 321,
			arr_area	= {11, 215},
			alfa		= 50,
		})
		
		--  "  1 :"
		L_Text(form, {
			--system_name	= "",
			arr_size	= {146, 12},
			arr_area	= {20, 226},
			--hint		= "",
			
			arr_text	= {
				text			= lstr(636),
				--font			= ITEMS_NAME,
				color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				center		= 1,
			}
		})
		
		--    "  1 :"
		L_OldRowInput(
			form, 
			"inp_cost_item", 
			1,																-- type (1 --   )
			32,																--   
			"",																-- hint
			{146, 18},														-- : width, height
			{20, 241}														--  : xpos, ypos
		)
		
		--  "- :"
		L_Text(form, {
			--system_name	= "",
			arr_size	= {147, 12},
			arr_area	= {176, 226},
			--hint		= "",
			
			arr_text	= {
				text			= lstr(637),
				--font			= MINI_FONT,
				color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				center		= 1,
			}
		})
		
		--    "  1 :"
		L_OldRowInput(
			form, 
			"inp_count_item", 
			1,																-- type (1 --   )
			32,																--   
			"",																-- hint
			{147, 18},														-- : width, height
			{176, 241}														--  : xpos, ypos
		)
		
		----  
		L_hr(form, {
			width		= 321,
			arr_area	= {11, 269},
			alfa		= 50,
		})
		
		
		--  "  (  10%):"
		L_Text(form, {
			--system_name	= "",
			arr_size	= {323, 12},
			arr_area	= {10, 280},
			--hint		= "",
			
			arr_text	= {
				text			= lstr(638),
				--font			= ITEMS_NAME,
				color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				center		= 1,
			}
		})
		
		--  "[-] "
		L_Text(form, {
			system_name	= "txt_all_cost",
			arr_size	= {323, 12},
			arr_area	= {10, 294},
			--hint		= "",
			
			arr_text	= {
				text			= lstr(639),
				--font			= ITEMS_NAME,
				--color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				center		= 1,
			}
		})
		
		-- -
		L_TextArea(form, {
			cpt_arr_area	= {10, 311},
			--cpt_hint		= "",
			--cpt_label_type	= LABELEX_TYPE,
			
			arr_text			=	{
				-- : "    ."
				lstr(640),
				
				--  "      ."
				lstr(641),
			},
			
			text_width	= 323,
			--text_hight			= 12,
			text_font			= FONT14,
			text_color			= COLOR_GRAY,
			text_shadow			= FALSE,
			--text_shadow_color	= COLOR_BLACK,
			text_center			= 1,
			--text_right			= 0,
		})
		
		
		-- : 
		L_btn(form, {
			system_name	= "btn_add_lot",
			text		= lstr(642),
			width		= nil,
			arr_area	= {138, 340 + 5},
			hint		= nil,
			action_id	= nil,
		})
		
	end
	GenFormChaBuy_add_lot()
end
GenFormChaBuy()

-----------------------------------------------------------------------
-- -  (:  )
-----------------------------------------------------------------------	
function GenCmpProgressBar()
	local form = GML_UI_CreateForm("pbarForm", FALSE, 326, 22, 315, -85 - 21, TRUE, FALSE)
	GML_UI_ShowForm(form, FALSE)
	GML_UI_SetFormStyle(form, 7)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_FormSetIsEscClose(form, FALSE)
	--GML_UI_SetFormStyleEx(form, FORM_BOTTOM, 0, 100)
	
	--   
	L_CreateBG({
		form_name = form, arr_pos_area = {0, -85 - 21}, arr_size = {326, 22},
		castom_path = "texture/ui_morgan/form/bg_4.png"
	})
	
	local pbar= GML_UI_CreateCompent(form, PROGRESS_TYPE, "pbar", 320, 16, 3, 3 -85 - 21)
	GML_UI_LoadScaleImage(pbar, "texture/ui_morgan/form/pbar_up_bg.png", PROGRESS_PROGRESS, 320, 16, 0, 0)
	
	L_Text(form, {
		system_name		= "pbarText",
		arr_size		= {320, 12},
		arr_area		= {3, 5 -85 - 21},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(726),
			--font			= FONT36,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
end
GenCmpProgressBar()

-----------------------------------------------------------------------
-- - 
-----------------------------------------------------------------------	
function GenCmpProgressBar()
	local form = GML_UI_CreateForm("pbar2Form", FALSE, 326, 22, 315, -126, TRUE, FALSE)
	GML_UI_ShowForm(form, FALSE)
	GML_UI_SetFormStyle(form, 7)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_FormSetIsEscClose(form, FALSE)
	--GML_UI_SetFormStyleEx(form, FORM_BOTTOM, 0, 100)
	
	--   
	L_CreateBG({
		form_name = form, arr_pos_area = {0, -85 - 21 + 20}, arr_size = {326, 22},
		castom_path = "texture/ui_morgan/form/bg_4.png"
	})
	
	local pbar= GML_UI_CreateCompent(form, PROGRESS_TYPE, "pbar2", 320, 16, 3, 3 -85 - 21 + 20)
	GML_UI_LoadScaleImage(pbar, "texture/ui_morgan/form/pbar_up_bg.png", PROGRESS_PROGRESS, 320, 16, 0, 0)
	
	L_Text(form, {
		system_name		= "pbar2Text",
		arr_size		= {320, 12},
		arr_area		= {3, 5 -85 - 21 + 20},
		--hint			= "",
	
		arr_text	= {
			text			= "",
			--font			= FONT36,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
end
GenCmpProgressBar()


-----------------------------------------------------------------------
--  
-----------------------------------------------------------------------	
function GenCmpSliderBar()
	local form = GML_UI_CreateForm("f_sbar", FALSE, 326, 22, 315, -126, TRUE, FALSE)
	GML_UI_ShowForm(form, FALSE)
	GML_UI_SetFormStyle(form, 7)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_FormSetIsEscClose(form, FALSE)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_I)
	
	local slider_bar_bg_2 = GML_UI_CreateCompent(form, IMAGE_TYPE, "f_sbar_bg_2", 332, 28, -3, -129)
	GML_UI_LoadImage(slider_bar_bg_2, "texture/ui_morgan/form/slider_bar_bg_2.png", NORMAL, 332, 28, 0, 0)
	
	-- bg bar
	local slider_bar_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "f_sbar_bg", 326, 22, 0, -126)
	GML_UI_LoadImage(slider_bar_bg, "texture/ui_morgan/form/slider_bar_bg.png", NORMAL, 326, 22, 0, 0)
	
	-- bg bar
	local f_slider_bar_slider = GML_UI_CreateCompent(form, IMAGE_TYPE, "f_sbar_slider", 22, 22, 33, -126 + 3 - 5)
	GML_UI_LoadImage(f_slider_bar_slider, "texture/ui_morgan/form/slider_bar_slider.png", NORMAL, 22, 22, 0, 0)
	
	-- bg bar
	local slider_bar_bg_place_done = GML_UI_CreateCompent(form, IMAGE_TYPE, "f_sbar_bg_place", 31, 16, 45, -126 + 3)
	GML_UI_LoadImage(slider_bar_bg_place_done, "texture/ui_morgan/form/slider_bar_bg_place_done.png", NORMAL, 31, 16, 0, 0)
	
	L_Text(form, {
		system_name		= "sbarText",
		arr_size		= {320, 12},
		arr_area		= {3, -141},
		--hint			= "",
	
		arr_text	= {
			text			= lstr(643),
			--font			= FONT36,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center			= 1,
		}
	})
end
GenCmpSliderBar()





function GenFormBossMsg()
	
	local form = GML_UI_CreateForm("frmCastomMsg", FALSE, 360, 410, 0, 0, TRUE, FALSE)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_I)
	GML_UI_ShowForm(form, TRUE)
	GML_UI_FormSetIsEscClose(form, FALSE)
	
	-- 3D 
	GML_UI_CreateCompent(form, UI3D_COMPENT, "frm_boss_msg_3D", 360, 360, 0, 50)
	

	local img_text_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "frm_boss_msg_bg_text", 220, 75, 0, 0)
	GML_UI_LoadImage(img_text_bg, "texture/ui_morgan/chat/boss_message.png", NORMAL, 220, 75, 0, 0)
	
	--  
	--  
	L_Text(form, {
		system_name	= "frm_boss_msg_name",
		arr_size	= {200, 12},
		arr_area	= {10, 10},
		hint		= "",
		
		arr_text	= {
			text			= lstr(644),
			font			= FONT11B,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
			--right	= 1,
		}
	})
	
	L_Text(form, {
		system_name	= "frm_boss_msg_text",
		arr_size	= {200, 24},
		arr_area	= {10, 28},
		hint		= "",
		
		arr_text	= {
			text			= lstr(645),
			--font			= FONT14,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
			--right	= 1,
		}
	})

end
GenFormBossMsg()




-----------------------------------------------------------------------
-- 
-----------------------------------------------------------------------	

function GenFormDisplayFairy()
	
	local form = GML_UI_CreateForm("frmMainPet", FALSE, 76, 25, 62, 56, FALSE, FALSE)
	GML_UI_ShowForm(form, FALSE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_FormSetIsEscClose(form, FALSE)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_V)
	
	--  
	local form_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgPet1", 76, 25, 0, 0)
	GML_UI_LoadImage(form_bg, "texture/ui_morgan/cha/bg_fairy.png", NORMAL, 76, 25, 0, 0)
	
	--  
	local cpt_hp = GML_UI_CreateCompent(form, PROGRESS_TYPE, "proPetHP", 50, 6, 25, 6)
	GML_UI_LoadScaleImage(cpt_hp, "texture/ui_morgan/cha/pbar_fairy_hp.png", PROGRESS_PROGRESS, 50, 6, 0, 0, 1.0, 1.0)
	GML_UI_SetHint(cpt_hp, lstr(646))
	GML_UI_SetProgressHintStyle(proPetHP, PROGRESS_HINT_NUM)
	
	--  
	local cpt_sp = GML_UI_CreateCompent(form, PROGRESS_TYPE, "proPetSP", 40, 6, 25, 13)
	GML_UI_LoadScaleImage(cpt_sp, "texture/ui_morgan/cha/pbar_fairy_sp.png", PROGRESS_PROGRESS, 40, 6, 0, 0, 1.0, 1.0)
	GML_UI_SetHint(cpt_sp, lstr(647))
	GML_UI_SetProgressHintStyle(cpt_sp, PROGRESS_HINT_NUM)
	
	--  
	GML_UI_CreateCompent(form, IMAGE_TYPE, "imgPetHead", 21, 21, 2, 2)
	
	--   
	local bg_lv = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgPet1", 21, 7, 2, 16)
	GML_UI_LoadImage(bg_lv, "texture/ui_morgan/cha/bg_fairy_lv.png", NORMAL, 23, 7, 0, 0)
	
	-- 
	L_Text(form, {
		system_name	= "labPetLv",
		arr_size	= {21, 7},
		arr_area	= {2, 16},
		hint		= "",
		
		arr_text	= {
			text			= "99",
			font			= MINI_FONT,
			--color			= COLOR_GRAY,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			center		= 1,
			--right	= 1,
		}
	})
end
GenFormDisplayFairy()



-----------------------------------------------------------------------
--  ,  ,  ,  
-----------------------------------------------------------------------
function GenFormItemUpd()
	--    
	local form = L_SetForm({
		system_name	= "frmEquipPurify",
		arr_size	= {178, 285},
		text_title	= lstr(648),
	})
	
	local form_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgBakTop", 178, 263, 0, 22)
	GML_UI_LoadImage(form_bg, "texture/ui_morgan/form/form_bg_ItemUpd.png", NORMAL, 178, 263, 0, 0)
	
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labTitle1", 0, 0, 0, 0)
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labTitle2", 0, 0, 0, 0)
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labTitle3", 0, 0, 0, 0)
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labTitle4", 0, 0, 0, 0)
	
	GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdEquipOne", 32, 32, 73, 143)	--  
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labHintleft1", 112, 14, 21, 57)	-- 
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labHintleft2", 112, 14, 21, 57)	-- 
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labHintleft3", 112, 14, 21, 57)	-- 
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labHintleft4", 112, 14, 21, 57)	-- 
	
	GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "cmdEquipTwo", 32, 32, 73, 46)	--  
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labHintright1", 112, 14, 21, 74)	-- 
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labHintright2", 112, 14, 21, 74)	-- 
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labHintright3", 112, 14, 21, 74)	-- 
	GML_UI_CreateCompent(form, LABELEX_TYPE, "labHintright4", 112, 14, 21, 74)	--  
	
	-- 
	L_RowText(
		form, 
		"labMoneyShow", 
		2,																			-- type (gold)
		lstr(649),	-- hint
		{110, 18},																	-- : width, height
		{33, 235}																	--  : xpos, ypos
	)
	
	L_DrawButton2(form, "yes", 16, 259, "btnForgeYes")	-- 
	L_DrawButton2(form, "no", 93, 259, "btnForgeNo")	-- 
end
GenFormItemUpd()




--   
--  
function GenFormFastPanel()
	--  
	local frmFast = GML_UI_CreateForm("frmFast", FALSE, 428, 73, 315, 557, TRUE, FALSE)
	GML_UI_FormSetHotKey(frmFast, ALT_KEY, HOTKEY_T)
	GML_UI_ShowForm(frmFast, TRUE)
	GML_UI_SetFormStyle(frmFast, 7)
	GML_UI_AddFormToTemplete(frmFast, FORM_MAIN)
	GML_UI_SetIsDrag(frmFast, TRUE)
	GML_UI_FormSetIsEscClose(frmFast, FALSE)

	--  
	local imgMain = GML_UI_CreateCompent(frmFast, IMAGE_TYPE, "imgMain", 425, 69, 0, 0)
	GML_UI_LoadImage(imgMain, "texture/ui_morgan/fast_panel/fast_panel_4.png", NORMAL, 425, 69, 0, 0)

	-- 
	for i = 0, 11 do
		GML_UI_CreateCompent(frmFast, FAST_COMMANG_TYPE, "fscMainF" .. i, 32, 32, 1 + ((32 + 3) * i), 36)
	end

	for i = 12, 23 do
		GML_UI_CreateCompent(frmFast, FAST_COMMANG_TYPE, "fscMainF" .. i, 32, 32, 1 + ((32 + 3) * (i - 12)), 1)
	end

	--  
	local btnFastUp = GML_UI_CreateCompent(frmFast, BUTTON_TYPE, "btnFastUp", 6, 16, 421, 27)
	GML_UI_SetHint(btnFastUp, lstr(650))
	GML_UI_LoadButtonImage(btnFastUp, "texture/ui_morgan/fast_panel/fast_panel_4.png", 6, 16, 426, 26, TRUE)
	
	local hint = GML_UI_CreateCompent(frmFast, IMAGE_TYPE, "ing", 7, 24, 418, 0)
	GML_UI_SetHint(hint, lstr(651))
	
	local hint = GML_UI_CreateCompent(frmFast, IMAGE_TYPE, "ing", 7, 24, 418, 45)
	GML_UI_SetHint(hint, lstr(651))
	
	--   ()
	GML_UI_CreateCompent(frmFast, BUTTON_TYPE, "btnFastDown", 0, 0, 0, 0)
end
GenFormFastPanel()


--   - ( )
function GenFormMainFun()
	--  
	local frmMainFun = GML_UI_CreateForm("frmMainFun", FALSE, 28, 306 - 100, 0, 0, TRUE, FALSE) --  223    ,     
	--GML_UI_FormSetHotKey(frmMainFun, ALT_KEY, HOTKEY_D)
	GML_UI_ShowForm(frmMainFun, TRUE)
	GML_UI_AddFormToTemplete(frmMainFun, FORM_MAIN)
	GML_UI_FormSetIsEscClose(frmMainFun, FALSE)
	GML_UI_SetFormStyle(frmMainFun, 11)
	GML_UI_SetIsDrag(frmMainFun, TRUE)

	local arr_left_btn = {
		[1] = {"btnState", lstr(571)},
		[2] = {"btnOpenTempBag", lstr(572)},
		[3] = {"btnStock", lstr(573)},
		[4] = {"btnSkill", lstr(574)},
		[5] = {"btnMission", lstr(575)},
		[6] = {"btnOpenGuild", lstr(576)},
		[7] = {"btnInfoCenter", lstr(577), disable = true},
		[8] = {"btnDatabase", lstr(578), disable = true},
		[9] = {"btnPromoKey", lstr(579), disable = true},
		[10] = {"btnQQ", lstr(580)},
		[11] = {"btnOpenSuppport", lstr(581), disable = true},
		[12] = {"btnSystem", lstr(582)}
	}

	local btn_num = 0
	for i = 1, #arr_left_btn do
		
		
		if arr_left_btn[i].disable == nil then
			btn_num = btn_num + 1
			local btn = GML_UI_CreateCompent(frmMainFun, BUTTON_TYPE, arr_left_btn[i][1], 23, 23, 2, 4 + (25 * (btn_num - 1)))
			GML_UI_LoadButtonImage(btn, "texture/ui_morgan/buttons_circule.png", 27, 27, 0, 0 + (27 * (i - 1)), TRUE)
			GML_UI_SetHint(btn, arr_left_btn[i][2])
		
			if arr_left_btn[i][1] == "btnOpenSuppport" then
				GML_UI_AddButtonLink(btn, "https://vk.com/im?sel=-124513133")
			end
		end
		
	end

	--   -
	local btnLevelUpHelp = GML_UI_CreateCompent(frmMainFun, BUTTON_TYPE, "btnLevelUpHelp", 0, 0, 0, -110)
	--GML_UI_LoadButtonImage(btnLevelUpHelp, "texture/ui/newbutton.tga", 41, 41, 0, 0, FALSE)
	--GML_UI_SetIsShow(btnLevelUpHelp, FALSE)

	-- VK group
	local btnDiscord = GML_UI_CreateCompent(frmMainFun, BUTTON_TYPE, "btnDiscord", 14, 14, -36, 319)
	GML_UI_LoadButtonImage(btnDiscord, "texture/ui/worldUI/minimap.png", 27, 27, 321, 0, FALSE)
	GML_UI_AddButtonLink(btnDiscord, "https://vk.com/piratiapw")
	GML_UI_SetHint(btnDiscord, lstr(652))

	-- VK group
	local btnDiscord3 = GML_UI_CreateCompent(frmMainFun, BUTTON_TYPE, "btnDiscord3", 14, 14, -18, 319)
	GML_UI_LoadButtonImage(btnDiscord3, "texture/ui/worldUI/minimap.png", 26, 26, 373, 0, FALSE)
	GML_UI_AddButtonLink(btnDiscord3, "https://t.me/gisgames")
	GML_UI_SetHint(btnDiscord3, lstr(653))

	-- VK group ( )
	-- local btnDiscord2 = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnDiscord2", 18, 18, 111, 198)
	-- GML_UI_LoadButtonImage(btnDiscord2, "texture/ui/worldUI/minimap.png", 26, 26, 348, 0, FALSE)
	-- GML_UI_AddButtonLink(btnDiscord2, "https://discord.gg/TXyPvN83NH")
	-- GML_UI_SetHint(btnDiscord2, "   Discord")
end
GenFormMainFun()


--  -  
function GenFormBag()
	--  
	local frmBag = GML_UI_CreateForm("frmBag", FALSE, 89, 30, 450, 250, TRUE, FALSE)
	GML_UI_ShowForm(frmBag, TRUE)
	GML_UI_AddFormToTemplete(frmBag, FORM_MAIN)
	GML_UI_FormSetIsEscClose(frmBag, FALSE)

	-- ??????
	local imgMainFun1 = GML_UI_CreateCompent(frmBag, IMAGE_TYPE, "imgMainFun1", 32, 30, 57, 0)
	GML_UI_LoadImage(imgMainFun1, "texture/ui/new4.tga", NORMAL, 32, 30, 0, 0)

	local imgMainFun2 = GML_UI_CreateCompent(frmBag, IMAGE_TYPE, "imgMainFun2", 32, 30, 0, 0)
	GML_UI_LoadImage(imgMainFun2, "texture/ui/new4.tga", NORMAL, 32, 30, 32, 0)

	imgMainFun2 = GML_UI_CreateCompent(frmBag, IMAGE_TYPE, "imgMainFun2", 25, 30, 32, 0)
	GML_UI_LoadImage(imgMainFun2, "texture/ui/new4.tga", NORMAL, 2, 30, 0, 0)

	-- ?????????????
	-- ?????????
	local btnOpenItem = GML_UI_CreateCompent(frmBag, BUTTON_TYPE, "btnOpenItem", 37, 22, 7, 4)
	GML_UI_LoadButtonImage(btnOpenItem, "texture/ui/new6.tga", 37, 22, 0, 198, TRUE)
	GML_UI_SetHint(btnOpenItem, lstr(654))

	-- ?????????
	local btnOpenTempBag = GML_UI_CreateCompent(frmBag, BUTTON_TYPE, "btnOpenTempBag", 37, 22, 45, 4)
	GML_UI_LoadButtonImage(btnOpenTempBag, "texture/ui/new6.tga", 37, 22, 0, 220, TRUE)
	GML_UI_SetHint(btnOpenTempBag, lstr(655))
end
GenFormBag()



--  -   
function GenFormSociliaty()
	--  
	local frmSociliaty = GML_UI_CreateForm("frmSociliaty", FALSE, 37, 30, 400, 300, TRUE, FALSE)
	--GML_UI_FormSetHotKey(frmSociliaty, ALT_KEY, HOTKEY_D)
	GML_UI_ShowForm(frmSociliaty, TRUE)
	GML_UI_AddFormToTemplete(frmSociliaty, FORM_MAIN)
	GML_UI_FormSetIsEscClose(frmSociliaty, FALSE)

	-- ?????
	local imgMainFun1 = GML_UI_CreateCompent(frmSociliaty, IMAGE_TYPE, "imgMainFun1", 25, 30, 0, 0)
	GML_UI_LoadImage(imgMainFun1, "texture/ui/new4.tga", NORMAL, 25, 30, 32, 0)

	local imgMainFun2 = GML_UI_CreateCompent(frmSociliaty, IMAGE_TYPE, "imgMainFun2", 25, 30, 12, 0)
	GML_UI_LoadImage(imgMainFun2, "texture/ui/new4.tga", NORMAL, 25, 30, 7, 0)
end
GenFormSociliaty()

--  "  ..."
function GenFormFollow()
	--  
	local frmFollow = GML_UI_CreateForm("frmFollow", FALSE, 0, 0, 350, 280, FALSE, FALSE)
	GML_UI_ShowForm(frmFollow, TRUE)
	GML_UI_AddFormToTemplete(frmFollow, FORM_MAIN)
	GML_UI_FormSetIsEscClose(frmFollow, FALSE)

	--    
	local labFollow = GML_UI_CreateCompent(frmFollow, LABELEX_TYPE, "labFollow", 100, 40, 0, 0)
	GML_UI_SetCaption(labFollow, "")
	GML_UI_SetTextColor(labFollow, COLOR_BLACK)
	GML_UI_SetLabelExFont(labFollow, DEFAULT_FONT, TRUE, COLOR_WHITE)
end
GenFormFollow()

--   -
function GenFormGM()
	--  
	local frmGM = GML_UI_CreateForm("frmGM", FALSE, 512, 28, 290, 545, TRUE, FALSE)
	GML_UI_FormSetHotKey(frmGM, ALT_KEY, HOTKEY_P)
	GML_UI_ShowForm(frmGM, FALSE)
	GML_UI_AddFormToTemplete(frmGM, FORM_MAIN)
	GML_UI_FormSetIsEscClose(frmGM, FALSE)
	GML_UI_SetFormStyleEx(frmGM, FORM_BOTTOM, 0, 100)

	--  
	local imgBg = GML_UI_CreateCompent(frmGM, IMAGE_TYPE, "imgBg", 512, 28, 0, 0)
	GML_UI_LoadImage(imgBg, "texture/ui/gm.tga", NORMAL, 512, 28, 0, 0)

	--  
	local edtGMSay = GML_UI_CreateCompent(frmGM, EDIT_TYPE, "edtGMSay", 496, 28, 8, 8)
	GML_UI_SetTextColor(edtGMSay, COLOR_WHITE)
	GML_UI_SetEditMaxNum(edtGMSay, 500)
	GML_UI_SetEditMaxNumVisible(edtGMSay, 500)
	GML_UI_SetEditCursorColor(edtGMSay, COLOR_WHITE)
end
GenFormGM()


--   
function GenFormHelpSystem()
	local form = L_SetForm({
		system_name	= "frmHelpSystem",
		arr_size	= {568 - 20, 424},
		text_title	= lstr(656)
	})
	
	GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_H, MACROS_LOCATION_SCHEDUL)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_SetFormStyle(form, 1)

	L_CreateBG({
		form_name = form, arr_pos_area = {10, 22 + 10}, arr_size = {181 - 20, 382}, alpha = 100, castom_path = "texture/ui_morgan/form/bg_3.png"
	})
	
	--  
	local lstHelpList = GML_UI_CreateCompent(form, LIST_TYPE, "lstHelpList", 188 - 20, 402, 19, 42)
	GML_UI_SetListDefaultColor(lstHelpList, COLOR_WHITE)
	
	local lstHelpButton = GML_UI_GetList(lstHelpList)
	GML_UI_SetListRowHeight(lstHelpButton, 15)
	GML_UI_SetListIsMouseFollow(lstHelpList, TRUE)

	-- 
	L_DrawScroll(lstHelpButton)
	
	L_CreateBG({
		form_name = form, arr_pos_area = {197 - 20, 10+22}, arr_size = {362, 382}, alpha = 100, castom_path = "texture/ui_morgan/form/bg_3.png"
	})
	
	local a_location = {
		{title = lstr(658), img_name = "snow_wars.png"},			--  
		{title = lstr(657), img_name = "silver_chaos.png"},			--  
		{title = lstr(659), img_name = "demon_world.png"},			--  
		{title = lstr(660), img_name = "lost_city.png"},			--  
		{title = lstr(661), img_name = "dark_swamps.png"},			-- Ҹ 
		{title = lstr(662), img_name = "griffon_island.png"},		--  
		--{title = lstr(665), img_name = "aurora_lands.tga"},			--  
		{title = lstr(666), img_name = "asgard_lands.png"},			--  
		{title = lstr(667), img_name = "asgard_dungeon.png"},		--  

		
		{title = lstr(795), img_name = "zodiac.png"},				-- 
		{title = lstr(787), img_name = "shalzar_fortress.png"},		--  
		{title = lstr(788), img_name = "aronsha_hall.png"},			--  
		{title = lstr(789), img_name = "shutgard_prison.png"},		--  
		{title = lstr(790), img_name = "janus_dungeon.png"},		--  
		{title = lstr(791), img_name = "osiris_crypt.png"},			--  
		{title = lstr(792), img_name = "lucifer_hall.png"},			--  
		{title = lstr(793), img_name = "andromeda_chambers.png"},	--  
		{title = lstr(794), img_name = "terratron_sanctuary.png"},	--  
		{title = lstr(810), img_name = "elegon_lair.png"},			--  
		{title = lstr(811), img_name = "fenrir_tomb.png"},			--  
		{title = lstr(668), img_name = "muspelheim.png"},			-- 
	}

	--  
	for i = 1, 24 do
		local tab = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgHelpShow"..i.."_1", 360, 380, 198 - 20, 11+22)
		if a_location[i] then
			GML_UI_LoadImage(tab, "texture/ui_morgan/timetable_location/"..a_location[i].img_name, NORMAL, 360, 380, 0, 0)
			GML_UI_AddListText(lstHelpList, a_location[i].title)
		end
		GML_UI_SetIsShow(tab, FALSE)
	end
end
GenFormHelpSystem()






--  ()
function GenFormOldStore()
	frmStore = GML_UI_CreateForm("frmStore", FALSE, 608, 550, 0, 0, TRUE, FALSE)
	GML_UI_ShowForm(frmStore, FALSE)
	GML_UI_AddFormToTemplete(frmStore, FORM_MAIN)
	GML_UI_FormSetIsEscClose(frmStore, FALSE)
	GML_UI_SetIsDrag(frmStore,FALSE)
	GML_UI_SetFormStyle(frmStore,1)
	--GML_UI_FormSetHotKey(frmStore, ALT_KEY, HOTKEY_I)
	
	-- 
	imgBackGround1 = GML_UI_CreateCompent(frmStore, IMAGE_TYPE, "imgBackGround1", 608, 550, 0, 0)
	GML_UI_LoadImage(imgBackGround1, "texture/ui_morgan/store/form.tga", NORMAL, 608, 550, 0, 0)
	
	L_DrawScroll(imgBackGround1)
	
	-- title
	labTitle = L_DrawTitle(frmStore, lstr(669))
	
	--   (  Game.exe)
	--  GUI::CStoreMgr::StoreTreeRefresh
	--  GUI::CStoreMgr::AddStoreTreeNode
	trvStore = GML_UI_CreateCompent(frmStore, TREE_TYPE, "trvStore", 144, 365, 5, 38)
	GML_UI_SetTextColor(trvStore, COLOR_WHITE)
	
	
	itemid = GML_UI_CreateNoteGraphItem("texture/ui_morgan/store/form_icon.tga", 127, 20, 30, 114, 0, lstr(670), 5 , 2)
	gridid = GML_UI_CreateGridNode(trvStore, itemid, 1, 32, 32, -1)
	
	GML_UI_TreeLoadImage(trvStore, enumTreeAddImage, "texture/ui_morgan/store/form_icon.tga", 30, 20, 0, 114, 30, 20)
	GML_UI_TreeLoadImage(trvStore, enumTreeSubImage, "texture/ui_morgan/store/form_icon.tga", 30, 20, 0, 134, 30, 20)
	
	
	L_DrawScroll(trvStore)
	GML_UI_SetIsDrag(trvStore, FALSE)
	
		--   
		
		labNotice = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labNotice", 10, 150, 190 ,120)
		--   
		--GML_UI_SetCaption(labNotice, "   ")
		GML_UI_SetTextColor(labNotice, COLOR_BLACK)
		GML_UI_SetLabelExFont(labNotice, DEFAULT_FONT, FALSE, COLOR_WHITE)
		
		-- ,   
		imgBackGround10 = GML_UI_CreateCompent(frmStore, IMAGE_TYPE, "imgBackGround10", 440, 440, 139, 45)
		--GML_UI_LoadImage(imgBackGround10, "texture/ui/store_bg.tga", NORMAL, 20,20, 30, 70)
		
		--    
		labNameTitle = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labNameTitle0", 10, 150, 192, 44)
		GML_UI_SetCaption(labNameTitle, lstr(671))
		GML_UI_SetTextColor(labNameTitle, COLOR_BLACK)
		GML_UI_SetLabelExFont(labNameTitle, DEFAULT_FONT, FALSE, COLOR_WHITE)
		
		
		--   
		labLeftTimeTitle = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labLeftTimeTitle", 10, 150, 375, 44)
		GML_UI_SetCaption(labLeftTimeTitle, lstr(672))
		GML_UI_SetTextColor(labLeftTimeTitle, COLOR_BLACK)
		GML_UI_SetLabelExFont(labLeftTimeTitle, DEFAULT_FONT, FALSE, COLOR_WHITE)
		
		--  
		labLeftNumTitle = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labLeftNumTitle", 10, 150, 425, 44)
		GML_UI_SetCaption(labLeftNumTitle, lstr(673))
		GML_UI_SetTextColor(labLeftNumTitle, COLOR_BLACK)
		GML_UI_SetLabelExFont(labLeftNumTitle, DEFAULT_FONT, FALSE, COLOR_WHITE)
		
			--  
		labPriceTitle = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labPriceTitle", 10, 150, 525, 44)
		GML_UI_SetCaption(labPriceTitle, lstr(674))
		GML_UI_SetTextColor(labPriceTitle, COLOR_BLACK)
		GML_UI_SetLabelExFont(labPriceTitle, DEFAULT_FONT, FALSE, COLOR_WHITE)
		
		-- 
		local labName = {}
		local labPrice = {}
		local labRemark = {}
		local labLeftTime = {}
		local labLeftNum = {}
		local labRightClickView = {}
		
		local btnBlue = {}
		local imgBlue = {}
		
		-- 
		local imgNew = {}
		local imgHot = {}
		
		-- icon frame
		local imgSquare = {}
		-- icon command
		local cmdStore = {}
	
		local imgCutLine = {}
		
		imgCutLine0 = GML_UI_CreateCompent(frmStore, IMAGE_TYPE, "imgCutLine0", 432, 1, 150, 57)
		GML_UI_LoadImage(imgCutLine0, "texture/ui/ItemMallCutLine.tga",NORMAL, 432 ,1, 0, 49)
	
		for i=0,8,1 do
		
			--   ( )
			imgCutLine[i] = GML_UI_CreateCompent(frmStore, IMAGE_TYPE, "imgCutLine_"..i, 355, 2, 230, i*42+78)
			GML_UI_LoadImage(imgCutLine[i], "texture/ui/-store6.tga",NORMAL, 253 ,2, 0, 51)
			--GML_UI_SetAlpha(imgCutLine[i],150)
			
			--     
			imgBlue[i] = GML_UI_CreateCompent(frmStore, IMAGE_TYPE, "imgBlue_"..i, 432, 36, 157, i*50+65)
			--GML_UI_LoadImage(imgBlue[i], "texture/ui/store7.tga",NORMAL, 253, 48, 0, 50)
			GML_UI_LoadImage(imgBlue[i], "texture/ui/ItemMallimgBlue.tga",NORMAL, 253 ,48, 0, 0)
			GML_UI_SetAlpha(imgBlue[i],200)
			GML_UI_SetIsShow(imgBlue[i],TRUE)
		
			--imgBlue[i] = GML_UI_CreateCompent(frmStore, IMAGE_TYPE, "imgBlue_"..i, 355, 40, 230, i*42+80)
			--GML_UI_LoadImage(imgBlue[i], "texture/ui/store7.tga",NORMAL, 253 ,48, 0, 51)
			--GML_UI_SetAlpha(imgBlue[i],200)
		--	GML_UI_SetIsShow(imgBlue[i],FALSE)
			
			-- icon 
			imgSquare[i] =  GML_UI_CreateCompent(frmStore, IMAGE_TYPE, "imgSquare_"..i, 432, 1, 157, i*50+58)
			GML_UI_LoadImage(imgSquare[i], "texture/ui/ItemMallCutLine.tga",NORMAL, 432 ,1, 0, 0)
			
			-- icon 
			cmdStore[i] = GML_UI_CreateCompent(frmStore, COMMAND_ONE_TYPE, "cmdStore_"..i, 32, 32, 157, i*50+68)	
			
			-- 
			btnBlue[i] = GML_UI_CreateCompent(frmStore, BUTTON_TYPE, "btnBlue_"..i, 410, 40, 180, i*50+64)
			-- GML_UI_LoadButtonImage(btnBlue[i], "texture/ui/ItemMallimgBlue.tga", 256 ,51, 0, 0, FALSE)
			GML_UI_SetAlpha(btnBlue[i],0)
			
			
			--   
			labName[i] = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labName_"..i, 10, 150, 192, i*50+68)
			GML_UI_SetCaption(labName[i], "Item"..i)
			GML_UI_SetTextColor(labName[i], COLOR_BLUE)
			GML_UI_SetLabelExFont(labName[i], FONT14, FALSE, COLOR_WHITE)
			GML_UI_SetIsShow(labName[i],FALSE)
	
	
			--    
			labLeftTime[i] = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labLeftTime_"..i,  10, 150, 375, i*50+68)
			GML_UI_SetCaption(labLeftTime[i], "Remaining time"..i)
			GML_UI_SetTextColor(labLeftTime[i], COLOR_PINK)
			GML_UI_SetLabelExFont(labLeftTime[i], DEFAULT_FONT, FALSE, COLOR_WHITE)
			GML_UI_SetIsShow(labLeftTime[i],FALSE)
			
			--  - 
			labLeftNum[i] = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labLeftNum_"..i, 10, 150, 425, i*50+68)
			GML_UI_SetCaption(labLeftNum[i], "Remaining amount"..i)
			GML_UI_SetTextColor(labLeftNum[i], COLOR_PINK)
			GML_UI_SetLabelExFont(labLeftNum[i], DEFAULT_FONT, FALSE, COLOR_WHITE)		
			GML_UI_SetIsShow(labLeftNum[i],FALSE)
			
			--   
			labPrice[i] = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labPrice_"..i, 10, 150, 525, i*50+68)
			GML_UI_SetCaption(labPrice[i], "Price"..i)
			GML_UI_SetTextColor(labPrice[i], COLOR_RED)
			GML_UI_SetLabelExFont(labPrice[i], FONT14, FALSE, COLOR_WHITE)
			GML_UI_SetIsShow(labPrice[i],FALSE)
			
			--  
			-- 10, 150, 192, i*50+86
			labRemark[i] = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labRemark_"..i, 10, 150, 376, i*50+86)
			GML_UI_SetCaption(labRemark[i], "Remark"..i)
			GML_UI_SetTextColor(labRemark[i], COLOR_BLACK)
			GML_UI_SetLabelExFont(labRemark[i], DEFAULT_FONT, FALSE, COLOR_WHITE)
			
			--   
			-- 10, 150, 376, i*50+86
			labRightClickView[i] = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labRightClickView_"..i, 10, 150, 192, i*50+86)
			GML_UI_SetCaption(labRightClickView[i], lstr(675))
			GML_UI_SetTextColor(labRightClickView[i], 4285561442)
			GML_UI_SetLabelExFont(labRightClickView[i], DEFAULT_FONT, FALSE, COLOR_WHITE)
			
			--  
			imgNew[i] = GML_UI_CreateCompent(frmStore, IMAGE_TYPE, "imgNew_"..i, 20, 9, 169, i*50+66)
			GML_UI_LoadImage(imgNew[i], "texture/ui/ItemMall_icon_new.tga", NORMAL, 20 ,9, 0, 0)
			GML_UI_SetIsShow(imgNew[i],FALSE)
			
			--   
			imgHot[i] = GML_UI_CreateCompent(frmStore, IMAGE_TYPE, "imgHot_"..i, 20, 9, 168, i*50+90)
			GML_UI_LoadImage(imgHot[i], "texture/ui/ItemMall_icon_hit.tga", NORMAL, 20 ,9, 0, 0)
			GML_UI_SetIsShow(imgHot[i],FALSE)
		end
			
		-- 
		labMoneyNotice = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labMoneyNotice", 410, 150, 22, 419)
		GML_UI_SetCaption(labMoneyNotice, "")
		GML_UI_SetTextColor(labMoneyNotice, COLOR_BLACK)
		GML_UI_SetLabelExFont(labMoneyNotice, DEFAULT_FONT, FALSE, COLOR_WHITE)
	
		--  
		imgMoney = GML_UI_CreateCompent(frmStore, IMAGE_TYPE, "imgMoney", 10, 17, 20, 416)
		GML_UI_LoadImage(imgMoney, "texture/ui_morgan/store/form_icon.tga", NORMAL, 10, 17, 0, 203)
	
		-- - 
		labMoneyLeft = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labMoneyLeft", 400, 150, 33, 420)
		GML_UI_SetCaption(labMoneyLeft, "99999")
		GML_UI_SetTextColor(labMoneyLeft, COLOR_BLACK)
		GML_UI_SetLabelExFont(labMoneyLeft, DEFAULT_FONT, FALSE, COLOR_WHITE)
		
		-- 
		labMoneyNotice = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labMoneyNotice", 400, 150, 24, 465)
		GML_UI_SetCaption(labMoneyNotice, "Points")
		GML_UI_SetTextColor(labMoneyNotice, COLOR_BLACK)
		GML_UI_SetLabelExFont(labMoneyNotice, DEFAULT_FONT, TRUE, COLOR_WHITE)
		GML_UI_SetIsShow(labMoneyNotice, FALSE)
		
		-- - 
		labBeanLeft = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labBeanLeft", 400, 150,82, 465)
		GML_UI_SetCaption(labBeanLeft, "0")
		GML_UI_SetTextColor(labBeanLeft, COLOR_BLACK)
		GML_UI_SetLabelExFont(labBeanLeft, DEFAULT_FONT, TRUE, COLOR_WHITE)
		GML_UI_SetIsShow(labBeanLeft, FALSE)
		
		--  
		labMoneyNotice = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labMoneyNotice", 400, 150,24, 485)
		GML_UI_SetCaption(labMoneyNotice, "Type")
		GML_UI_SetTextColor(labMoneyNotice, COLOR_BLACK)
		GML_UI_SetLabelExFont(labMoneyNotice, DEFAULT_FONT, TRUE, COLOR_WHITE)
		GML_UI_SetIsShow(labMoneyNotice, FALSE)
		
		--    
		labMemberStyle = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labMemberStyle", 400, 150,82, 485)
		GML_UI_SetCaption(labMemberStyle, "Ordinary Member")
		GML_UI_SetTextColor(labMemberStyle, COLOR_BLACK)
		GML_UI_SetLabelExFont(labMemberStyle, DEFAULT_FONT, TRUE, COLOR_WHITE)
		GML_UI_SetIsShow(labMemberStyle, FALSE)
		
		--  
		btnLeftPage = GML_UI_CreateCompent(frmStore, BUTTON_TYPE, "btnLeftPage", 14, 13, 340, 524)
		GML_UI_LoadButtonImage(btnLeftPage, "texture/ui/buttons.tga", 14, 13, 270, 104, TRUE)
		GML_UI_SetIsShow(btnLeftPage,FALSE)
	
		--  
		labListPage = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labListPage", 400, 150, 368, 524)
		GML_UI_SetCaption(labListPage, "")
		GML_UI_SetTextColor(labListPage, COLOR_WHITE)
		--GML_UI_SetLabelExFont(labListPage, DEFAULT_FONT, TRUE, COLOR_WHITE)
		GML_UI_SetIsShow(labListPage,FALSE)
	
		--  
		btnRightPage = GML_UI_CreateCompent(frmStore, BUTTON_TYPE, "btnRightPage", 14, 13, 400, 524)
		GML_UI_LoadButtonImage(btnRightPage, "texture/ui/buttons.tga", 14, 13, 270, 117, TRUE)
		GML_UI_SetIsShow(btnRightPage,FALSE)
	
		--  
		btnTrade = GML_UI_CreateCompent(frmStore, BUTTON_TYPE, "btnTrade", 67, 24, 197, 519)
		GML_UI_LoadButtonImage(btnTrade, "texture/ui/buttons.tga", 67, 24, 0, 24 * 31, TRUE)
	
		labTrade = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labTrade", 400, 150, 212, 484)
		--GML_UI_SetCaption(labTrade, "Buy")
		--GML_UI_SetTextColor(labTrade, COLOR_BLACK)
		--GML_UI_SetLabelExFont(labTrade, DEFAULT_FONT, TRUE, COLOR_WHITE)
	
		--  
		btnTryon = GML_UI_CreateCompent(frmStore, BUTTON_TYPE, "btnTryon", 67, 24, 264, 519)
		GML_UI_LoadButtonImage(btnTryon, "texture/ui/buttons.tga", 67, 24, 0, 24 * 33, TRUE)
	
		labTryon = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labTryon", 400, 150, 272, 484)
		--GML_UI_SetCaption(labTryon, "Try")
		--GML_UI_SetTextColor(labTryon, COLOR_BLACK)
		--GML_UI_SetLabelExFont(labTryon, DEFAULT_FONT, TRUE, COLOR_WHITE)
		
		--  
		btnViewAll = GML_UI_CreateCompent(frmStore, BUTTON_TYPE, "btnViewAll", 67, 24, 423, 519)
		GML_UI_LoadButtonImage(btnViewAll, "texture/ui/buttons.tga", 67, 24, 0, 24 * 32, TRUE)
	
		labViewAll = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labViewAll", 400, 150, 329, 484)
		--GML_UI_SetCaption(labViewAll, "Check")
		--GML_UI_SetTextColor(labViewAll, COLOR_BLACK)
		--GML_UI_SetLabelExFont(labViewAll, DEFAULT_FONT, TRUE, COLOR_WHITE)
	
		--  
		btnCloseall = GML_UI_CreateCompent(frmStore, BUTTON_TYPE, "btnCloseall", 67, 24, 490, 519)
		GML_UI_LoadButtonImage(btnCloseall, "texture/ui/buttons.tga", 67, 24, 0, 0, TRUE)
		GML_UI_SetButtonModalResult(btnCloseall, BUTTON_CLOSE)
		
		labCloseAll = GML_UI_CreateCompent(frmStore, LABELEX_TYPE, "labCloseAll", 400, 150, 409, 484)
		--GML_UI_SetCaption(labCloseAll, "Close Mall")
		--GML_UI_SetTextColor(labCloseAll, COLOR_BLACK)
		--GML_UI_SetLabelExFont(labCloseAll, DEFAULT_FONT, TRUE, COLOR_WHITE)
		
		--  
		L_DrawClose(frmStore, 608)
		
		
			--**.
			
			
			
-----------------------------------------------------------------------
--     
-----------------------------------------------------------------------
frmViewAll = GML_UI_CreateForm("frmViewAll", FALSE, 320, 200, 100, 100, TRUE, FALSE)
GML_UI_ShowForm(frmViewAll, FALSE)
GML_UI_AddFormToTemplete(frmViewAll, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmViewAll, FALSE)
GML_UI_SetFormStyle(frmViewAll,1)
--GML_UI_FormSetHotKey(frmViewAll, ALT_KEY, HOTKEY_I)

imgBackGround1 = GML_UI_CreateCompent(frmViewAll, IMAGE_TYPE, "imgBackGround1", 320, 200, 0, 0)
GML_UI_LoadImage(imgBackGround1, "texture/ui/lot_view.tga", NORMAL, 320, 200, 0, 0)

labTitle = L_DrawTitle(frmViewAll, lstr(676))

-- icon img 
	local imgSquareViewAll = {}
	local cmdSquareIcon = {}
	
	for i=0 , 5 , 1 do
		imgSquareViewAll[i] = GML_UI_CreateCompent(frmViewAll, IMAGE_TYPE, "imgSquareViewAll_"..i, 36, 36, i*40+20, 50)
		GML_UI_LoadImage(imgSquareViewAll[i], "texture/ui_morgan/store/form_icon.tga",NORMAL, 36 ,36, 157, 76)
		cmdSquareIcon[i] = GML_UI_CreateCompent(frmViewAll, COMMAND_ONE_TYPE, "cmdSquareIcon_"..i, 32, 32, i*40+22, 52)	
	end

	memViewAll  = GML_UI_CreateCompent(frmViewAll, MEMO_TYPE, "memViewAll", 298, 60, 20, 96)
	GML_UI_SetCaption(memViewAll, "400")
	GML_UI_SetTextColor(memViewAll, COLOR_BLACK)
	GML_UI_SetLabelExFont(memViewAll, DEFAULT_FONT, TRUE, COLOR_WHITE)
	GML_UI_SetMemoPageShowNum(memViewAll, 3)
	GML_UI_SetMemoMaxNumPerRow(memViewAll, 40)
	
-- 
L_DrawScroll(memViewAll)
	
	--  
	btnReBack = GML_UI_CreateCompent(frmViewAll, BUTTON_TYPE, "btnReBack", 67, 24, 127, 169)
	GML_UI_LoadButtonImage(btnReBack, "texture/ui/buttons.tga", 67, 24, 0, 648, TRUE)
	GML_UI_SetButtonModalResult(btnReBack, BUTTON_CLOSE)
	
-----------------------------------------------------------------------
--     
-----------------------------------------------------------------------
frmTryon = GML_UI_CreateForm("frmTryon", FALSE, 192, 318, 0, 0, TRUE, FALSE)
GML_UI_ShowForm(frmTryon, FALSE)
GML_UI_AddFormToTemplete(frmTryon, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmTryon, FALSE)
GML_UI_SetIsDrag(frmTryon,FALSE)
GML_UI_FormSetHotKey(frmTryon, ALT_KEY, HOTKEY_T)

imgBackGround1 = GML_UI_CreateCompent(frmTryon, IMAGE_TYPE, "imgBackGround1", 186, 342, 0, 0)
GML_UI_LoadImage(imgBackGround1, "texture/ui/store_try.tga", NORMAL, 186,342, 0, 0)

labTitle = L_DrawTitle(frmTryon, lstr(677))

ui3dplayer = GML_UI_CreateCompent(frmTryon, UI3D_COMPENT, "ui3dplayer", 120 - 20, 320, 40, 30)

btnTurnleft3d = GML_UI_CreateCompent(frmTryon, BUTTON_TYPE, "btnTurnleft3d", 28, 55, 13, 245)
GML_UI_LoadButtonImage(btnTurnleft3d, "texture/ui/buttons.tga", 28, 55, 270, 140, TRUE)

btnTurnright3d = GML_UI_CreateCompent(frmTryon, BUTTON_TYPE, "btnTurnright3d", 28, 55, 145, 245)
GML_UI_LoadButtonImage(btnTurnright3d, "texture/ui/buttons.tga", 28, 55, 270, 196, TRUE)

-- 
btnClearAll = GML_UI_CreateCompent(frmTryon, BUTTON_TYPE, "btnClearAll", 67, 24, 64, 311)
GML_UI_LoadButtonImage(btnClearAll, "texture/ui/buttons.tga", 67, 24, 0, 24 * 8, TRUE)


labClearAll = GML_UI_CreateCompent(frmTryon, LABELEX_TYPE, "labClearAll", 400, 150, 76, 34)

end
GenFormOldStore()



































------------ 



-----------------------------------------------------------------------
--  
-----------------------------------------------------------------------
function GenFormFairysMarry()
frmSpiritMarry = GML_UI_CreateForm("frmSpiritMarry", FALSE, 325, 394, 0, 0, TRUE, FALSE)
GML_UI_ShowForm(frmSpiritMarry, FALSE)
GML_UI_AddFormToTemplete(frmSpiritMarry, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmSpiritMarry, TRUE)
GML_UI_SetIsDrag(frmSpiritMarry,TRUE)
GML_UI_SetFormStyle(frmSpiritMarry,1)

--  
imgBakTop = GML_UI_CreateCompent(frmSpiritMarry, IMAGE_TYPE, "imgBakTop", 325, 394, 0, 0)
GML_UI_LoadImage(imgBakTop, "texture/ui/fairy.tga", NORMAL, 325, 394, 0, 0)

-- Title
L_DrawTitle(frmSpiritMarry, lstr(678))

-- 
local btnClose = GML_UI_CreateCompent(frmSpiritMarry, BUTTON_TYPE, "btnClose", 21, 21, 325 - 23, 2)
GML_UI_LoadButtonImage(btnClose, "texture/ui/fairy.tga", 21, 21, 163, 400, TRUE)
GML_UI_SetButtonModalResult(btnClose, BUTTON_CLOSE)

--   
cmdSpiritOne = GML_UI_CreateCompent(frmSpiritMarry, COMMAND_ONE_TYPE, "cmdSpiritOne", 32, 32, 74, 133)
cmdSpiritTwo = GML_UI_CreateCompent(frmSpiritMarry, COMMAND_ONE_TYPE, "cmdSpiritTwo", 32, 32, 221, 182)
cmdSpiritItem = GML_UI_CreateCompent(frmSpiritMarry, COMMAND_ONE_TYPE, "cmdSpiritItem", 32, 32, 125, 244)

GML_UI_SetTag(cmdSpiritOne, enumSPIRIT_ONE)
GML_UI_SetTag(cmdSpiritTwo, enumSPIRIT_TWO)
GML_UI_SetTag(cmdSpiritItem, enumSPIRIT_OUT)

-- - 
labMoneyShow = GML_UI_CreateCompent(frmSpiritMarry, LABELEX_TYPE, "labMoneyShow", 112, 14, 120, 317)
GML_UI_SetCaption(labMoneyShow, "$$$")
GML_UI_SetTextColor(labMoneyShow, COLOR_WHITE)

-- 
btnForgeYes = GML_UI_CreateCompent(frmSpiritMarry, BUTTON_TYPE, "btnForgeYes", 77, 24, 76, 352)
GML_UI_LoadButtonImage(btnForgeYes, "texture/ui/fairy.tga", 77, 24, 0, 400, FALSE)

-- 
btnForgeNo = GML_UI_CreateCompent(frmSpiritMarry, BUTTON_TYPE, "btnForgeNo", 77, 24, 173, 352)
GML_UI_LoadButtonImage(btnForgeNo, "texture/ui/fairy.tga", 77, 24, 77, 400, FALSE)
GML_UI_SetButtonModalResult(btnForgeNo, BUTTON_CLOSE)
end
GenFormFairysMarry()





-----------------------------------------------------------------------
--   
-----------------------------------------------------------------------
function GenFormFairySoul()
frmFairySoul = GML_UI_CreateForm("frmFairySoul", FALSE, 325, 275, 0, 0, TRUE, FALSE)
GML_UI_ShowForm(frmFairySoul, FALSE)
GML_UI_AddFormToTemplete(frmFairySoul, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmFairySoul, TRUE)
GML_UI_SetIsDrag(frmFairySoul,TRUE)
GML_UI_SetFormStyle(frmFairySoul,1)

--  
imgBakTop = GML_UI_CreateCompent(frmFairySoul, IMAGE_TYPE, "imgBakTop", 325, 275, 0, 0)
GML_UI_LoadImage(imgBakTop, "texture/ui_morgan/forge/purify.png", NORMAL, 325, 275, 0, 0)

-- 
L_DrawClose(frmFairySoul, 325)

--  
labTitle1 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labTitle1", 400, 150, 10, 7)
GML_UI_SetCaption(labTitle1, lstr(679))
GML_UI_SetTextColor(labTitle1, COLOR_WHITE)

--  
labTitle2 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labTitle2", 400, 150, 10, 7)
GML_UI_SetCaption(labTitle2, lstr(680))
GML_UI_SetTextColor(labTitle2, COLOR_WHITE)

--  
labTitle3 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labTitle3", 400, 150, 10, 7)
GML_UI_SetCaption(labTitle3, lstr(681))
GML_UI_SetTextColor(labTitle3, COLOR_WHITE)

--  
labTitle4 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labTitle4", 400, 150, 10, 7)
GML_UI_SetCaption(labTitle4, lstr(682))
GML_UI_SetTextColor(labTitle4, COLOR_WHITE)

--  
cmdEquipOne = GML_UI_CreateCompent(frmFairySoul, COMMAND_ONE_TYPE, "cmdEquipOne", 32, 32, 60, 131)

-- 
labHintleft1 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labHintleft1", 112, 14, 21, 57)
GML_UI_SetCaption(labHintleft1, lstr(683))
GML_UI_SetTextColor(labHintleft1, COLOR_WHITE)

-- 
labHintleft2 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labHintleft2", 112, 14, 21, 57)
GML_UI_SetCaption(labHintleft2, lstr(684))
GML_UI_SetTextColor(labHintleft2, COLOR_WHITE)

-- 
labHintleft3 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labHintleft3", 112, 14, 21, 57)
GML_UI_SetCaption(labHintleft3, lstr(685))
GML_UI_SetTextColor(labHintleft3, COLOR_WHITE)

-- 
labHintleft4 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labHintleft4", 112, 14, 21, 57)
GML_UI_SetCaption(labHintleft4, lstr(686))
GML_UI_SetTextColor(labHintleft4, COLOR_WHITE)

--  
cmdEquipTwo = GML_UI_CreateCompent(frmFairySoul, COMMAND_ONE_TYPE, "cmdEquipTwo", 32, 32, 233, 131)

-- 
labHintright1 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labHintright1", 112, 14, 21, 74)
GML_UI_SetCaption(labHintright1, lstr(687))
GML_UI_SetTextColor(labHintright1, COLOR_WHITE)

-- 
labHintright2 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labHintright2", 112, 14, 21, 74)
GML_UI_SetCaption(labHintright2, lstr(688))
GML_UI_SetTextColor(labHintright2, COLOR_WHITE)

-- 
labHintright3 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labHintright3", 112, 14, 21, 74)
GML_UI_SetCaption(labHintright3, lstr(689))
GML_UI_SetTextColor(labHintright3, COLOR_WHITE)

--  
labHintright4 = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labHintright4", 112, 14, 21, 74)
GML_UI_SetCaption(labHintright4, lstr(690))
GML_UI_SetTextColor(labHintright4, COLOR_WHITE)

-- 
labMoneyShow = GML_UI_CreateCompent(frmFairySoul, LABELEX_TYPE, "labMoneyShow", 112, 14, 129, 213)
--GML_UI_SetCaption(labMoneyShow, "")
--GML_UI_SetTextColor(labMoneyShow, COLOR_WHITE)

-- 
btnForgeYes = L_DrawButton(frmFairySoul, "yes", 86, 205, "btnForgeYes")

-- 
btnForgeNo = L_DrawButton(frmFairySoul, "no", 173, 205, "btnForgeNo")
end
GenFormFairySoul()





-----------------------------------------------------------------------
--  
-----------------------------------------------------------------------

function GenFormSpiritErnie()
	local form = GML_UI_CreateForm("frmSpiritErnie", FALSE, 576, 541, 0, 0, TRUE, FALSE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_FormSetIsEscClose(form, TRUE)
	GML_UI_SetIsDrag(form, TRUE)
	GML_UI_SetFormStyle(form, 1)
	
	--  1
	local form_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgBakMainErnieNew", 576, 541, 0, 0)
	GML_UI_LoadImage(form_bg, "texture/ui_morgan/slot_machine/newSlotMachine.tga", NORMAL, 576, 541, 9, 97)
	
	--  2
	local form_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgBakMainErnie", 576, 541, 0, 0)
	GML_UI_LoadImage(form_bg, "texture/ui_morgan/slot_machine/newSlotMachine2.tga", NORMAL, 576, 541, 9, 97)
	
	--  3
	local form_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "imgBakMainErnieBlinkNew", 488, 503, 13, 8)
	GML_UI_LoadImage(form_bg, "texture/ui_morgan/slot_machine/newSlotMachineBlink.tga", NORMAL, 488, 503, 0, 0)
	
	local btnClose = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnClose", 17, 17, 448, 132)
	GML_UI_LoadButtonImage(btnClose, "texture/ui_morgan/slot_machine/newSlotMachine.tga", 17, 17, 528, 6, TRUE)
	GML_UI_SetButtonModalResult(btnClose, BUTTON_CLOSE)
	
	
	local x_positions = {225, 284, 342}
	local y_positions = {213, 270, 326}
	
	--  ,     
	for col = 1, 3 do
		for row = 1, 3 do
			local baseIndex = (col - 1) * 3 + row
			
			--     
			for imgIndex = 1, 5 do
				local imgName = "imgLine" .. baseIndex .. "_" .. imgIndex
				local img = GML_UI_CreateCompent(form, IMAGE_TYPE, imgName, 32, 32, x_positions[col], y_positions[row])
				--    Y   
				local yOffset = ((imgIndex - 1) * 16 + ((baseIndex - 1) % 6) * 16) % 96
				GML_UI_LoadImage(img, "texture/ui_morgan/slot_machine/newSlots.tga", NORMAL, 32, 32, 0, yOffset)
			end
			
			--  
			local cmdName = "cmdItemTiger" .. baseIndex
			GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, cmdName, 32, 32, x_positions[col], y_positions[row])
		end
	end


	
	local labMoneyShow = GML_UI_CreateCompent(form, LABELEX_TYPE, "labMoneyShow", 299, 25, 109 + 31, 165+ 1)
	GML_UI_SetCaption(labMoneyShow, lstr(691))
	GML_UI_SetTextColor(labMoneyShow, COLOR_WHITE)
	GML_UI_SetLabelExFont(labMoneyShow, DEFAULT_FONT, FALSE, COLOR_BLACK)
	
	local labMoneyShowSecondNew = GML_UI_CreateCompent(form, LABELEX_TYPE, "labMoneyShowSecondNew", 299, 25, 109 + 31, 177 + 1)
	GML_UI_SetCaption(labMoneyShowSecondNew, lstr(692))
	GML_UI_SetTextColor(labMoneyShowSecondNew, COLOR_WHITE)
	GML_UI_SetLabelExFont(labMoneyShowSecondNew, DEFAULT_FONT, FALSE, COLOR_BLACK)
	
	local labMoneyShowSecond = GML_UI_CreateCompent(form, LABELEX_TYPE, "labMoneyShowSecond", 299, 25, 109 + 31, 177+ 1)
	GML_UI_SetCaption(labMoneyShowSecond, lstr(693))
	GML_UI_SetTextColor(labMoneyShowSecond, COLOR_WHITE)
	GML_UI_SetLabelExFont(labMoneyShowSecond, DEFAULT_FONT, FALSE, COLOR_BLACK)
	
	-- 
	local btnStart = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnStart", 67, 24, 90, 372)
	GML_UI_LoadButtonImage(btnStart, "texture/ui/buttons/index.tga", 67, 24, 0, 336, TRUE)
	
	for i = 1, 3 do
		local chk_box = GML_UI_CreateCompent(form, CHECK_TYPE, "chkSetmoney"..i, 10, 10, 185, 224 + ((i - 1) * 57))
		GML_UI_LoadImage(chk_box, "texture/ui/QQ2.tga", UNCHECKED, 10, 10, 40, 231)
		GML_UI_LoadImage(chk_box, "texture/ui/QQ2.tga", CHECKED, 10, 10, 52, 231)
		GML_UI_SetHint(chk_box, " "..i)
		
		local lable = GML_UI_CreateCompent(form, LABELEX_TYPE, "labUsemoney"..i, 38, 16, 153, 224 + ((i - 1) * 57))
		GML_UI_SetCaption(lable, "")
		GML_UI_SetTextColor(lable, COLOR_WHITE)
		
		local btn_stop = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnStop"..i, 67, 24, 165 + ((i - 1) * 75), 372)
		GML_UI_LoadButtonImage(btn_stop, "texture/ui/buttons/index.tga", 67, 24, 0, 360, TRUE)
	end
	
	local labLastshow1= GML_UI_CreateCompent(form, LABELEX_TYPE, "labLastshow1", 255, 41, 77 + 25, 422)
	GML_UI_SetCaption(labLastshow1, lstr(694))
	GML_UI_SetTextColor(labLastshow1, COLOR_WHITE)
	GML_UI_SetLabelExFont(labLastshow1, FONT14, FALSE, COLOR_WHITE)
	
	local labLastshow2= GML_UI_CreateCompent(form, LABELEX_TYPE, "labLastshow2", 255, 41, 77 + 25, 445)
	GML_UI_SetCaption(labLastshow2, lstr(695))
	GML_UI_SetTextColor(labLastshow2, COLOR_WHITE)
	GML_UI_SetLabelExFont(labLastshow2, FONT14, FALSE, COLOR_WHITE)
end
GenFormSpiritErnie()











-----------------------------------------------------------------------
--  
-----------------------------------------------------------------------
function GenFormPKSilver()
frmPKSilver = GML_UI_CreateForm("frmPKSilver", FALSE, 478, 315, 0, 0, TRUE, FALSE)
GML_UI_ShowForm(frmPKSilver, FALSE)
GML_UI_AddFormToTemplete(frmPKSilver, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmPKSilver, TRUE)
GML_UI_SetIsDrag(frmPKSilver,TRUE)
GML_UI_SetFormStyle(frmPKSilver,2)

--  
imgBackGround = GML_UI_CreateCompent(frmPKSilver, IMAGE_TYPE, "imgBackGround", 478, 315, 0, 0)
GML_UI_LoadImage(imgBackGround, "texture/ui/chaos.tga", NORMAL, 478, 315, 0, 0)

-- 
L_DrawTitle(frmPKSilver, lstr(696))

-- 
L_DrawClose(frmPKSilver, 478)

--  
local labName = {}
local labLevel = {}
local labJob = {}
local labData = {}
local labNO = {}

for i=0 ,4 ,1 do
	labName[i] = GML_UI_CreateCompent(frmPKSilver, LABELEX_TYPE, "labName_"..i, 10, 150, 57, i*27+136)
	GML_UI_SetCaption(labName[i], lstr(697)..i)
	GML_UI_SetTextColor(labName[i], COLOR_BLACK)
	GML_UI_SetLabelExFont(labName[i], DEFAULT_FONT, TRUE, COLOR_WHITE)

	labLevel[i] = GML_UI_CreateCompent(frmPKSilver, LABELEX_TYPE, "labLevel_"..i, 10, 150, 213, i*27+136)
	GML_UI_SetCaption(labLevel[i], lstr(698)..i)
	GML_UI_SetTextColor(labLevel[i], COLOR_BLACK)
	GML_UI_SetLabelExFont(labLevel[i], DEFAULT_FONT, TRUE, COLOR_WHITE)

	labJob[i] = GML_UI_CreateCompent(frmPKSilver, LABELEX_TYPE, "labJob_"..i, 10, 150, 265, i*27+136)
	GML_UI_SetCaption(labJob[i], lstr(699)..i)
	GML_UI_SetTextColor(labJob[i], COLOR_BLACK)
	GML_UI_SetLabelExFont(labJob[i], DEFAULT_FONT, TRUE, COLOR_WHITE)

	labData[i] = GML_UI_CreateCompent(frmPKSilver, LABELEX_TYPE, "labData_"..i, 10, 150, 382, i*27+136)
	GML_UI_SetCaption(labData[i], lstr(700)..i)
	GML_UI_SetTextColor(labData[i], COLOR_BLACK)
	GML_UI_SetLabelExFont(labData[i], DEFAULT_FONT, TRUE, COLOR_WHITE)

	labNO[i] = GML_UI_CreateCompent(frmPKSilver, LABELEX_TYPE, "labTtitle5", 400, 150, 31, i*27+136)
	GML_UI_SetCaption(labNO[i], ""..(i+1))
	GML_UI_SetTextColor(labNO[i], COLOR_RED)
	GML_UI_SetLabelExFont(labNO[i], DEFAULT_FONT, TRUE, COLOR_WHITE)
end

-- 
btnNo = L_DrawButton(frmPKSilver, "exit", 205, 280, "btnNo")
end
GenFormPKSilver()

-----------------------------------------------------------------------
--  
-----------------------------------------------------------------------
function GenFormFindTeam()
frmFindTeam = GML_UI_CreateForm("frmFindTeam", FALSE, 558, 386, 0, 0, TRUE, FALSE)
GML_UI_ShowForm(frmFindTeam, FALSE)
GML_UI_AddFormToTemplete(frmFindTeam, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmFindTeam, TRUE)
GML_UI_SetIsDrag(frmFindTeam,TRUE)
GML_UI_SetFormStyle(frmFindTeam,2)

--  
imgBackGround = GML_UI_CreateCompent(frmFindTeam, IMAGE_TYPE, "imgBackGround", 558, 386, 0, 0)
GML_UI_LoadImage(imgBackGround, "texture/ui/party.tga", NORMAL, 558, 386, 0, 0)

-- 
L_DrawTitle(frmFindTeam, lstr(701))

-- 
L_DrawClose(frmFindTeam, 558)

--  
local labName = {}
local labLevel = {}
local labJob = {}
local labPlace = {}
local btnSubmit = {}
for i=0 ,9 ,1 do
	--  
	labName[i] = GML_UI_CreateCompent(frmFindTeam, LABELEX_TYPE, "labName_"..i, 10, 150, 30, i*27+72)
	GML_UI_SetCaption(labName[i], lstr(697)..i)
	GML_UI_SetTextColor(labName[i], COLOR_BLACK)
	GML_UI_SetLabelExFont(labName[i], DEFAULT_FONT, TRUE, COLOR_WHITE)

	-- 
	labLevel[i] = GML_UI_CreateCompent(frmFindTeam, LABELEX_TYPE, "labLevel_"..i, 10, 150, 166, i*27+72)
	GML_UI_SetCaption(labLevel[i], lstr(698)..i)
	GML_UI_SetTextColor(labLevel[i], COLOR_BLACK)
	GML_UI_SetLabelExFont(labLevel[i], DEFAULT_FONT, TRUE, COLOR_WHITE)

	-- 
	labJob[i] = GML_UI_CreateCompent(frmFindTeam, LABELEX_TYPE, "labJob_"..i, 10, 150, 213, i*27+72)
	GML_UI_SetCaption(labJob[i], lstr(699)..i)
	GML_UI_SetTextColor(labJob[i], COLOR_BLACK)
	GML_UI_SetLabelExFont(labJob[i], DEFAULT_FONT, TRUE, COLOR_WHITE)

	-- 
	labPlace[i] = GML_UI_CreateCompent(frmFindTeam, LABELEX_TYPE, "labPlace_"..i, 10, 150, 328, i*27+72)
	GML_UI_SetCaption(labPlace[i], lstr(702)..i)
	GML_UI_SetTextColor(labPlace[i], COLOR_BLACK)
	GML_UI_SetLabelExFont(labPlace[i], DEFAULT_FONT, TRUE, COLOR_WHITE)

	-- 
	btnSubmit[i] = L_DrawButton(frmFindTeam, "ok", 464, i*27+65, "btnSubmit_"..i)
end

--   
L_DrawPages(frmFindTeam, 26, 356, "labListPage")

-- 
btnAddme = L_DrawButton(frmFindTeam, "add", 401, 351, "btnAddme")
GML_UI_SetButtonModalResult(btnAddme, BUTTON_YES)

-- 
btnDelme = L_DrawButton(frmFindTeam, "remove", 478, 351, "btnDelme")
GML_UI_SetButtonModalResult(btnDelme, BUTTON_YES)
end
GenFormFindTeam()

-----------------------------------------------------------------------
-- 
-----------------------------------------------------------------------
function GenFormCompose()
frmCompose = GML_UI_CreateForm("frmCompose", FALSE, 305, 480, 240, 70, TRUE, FALSE)
GML_UI_ShowForm(frmCompose, FALSE)
GML_UI_AddFormToTemplete(frmCompose, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmCompose, TRUE)
GML_UI_SetIsDrag(frmCompose,TRUE)
GML_UI_SetFormStyle(frmCompose,2)

--  
proComposeHide = GML_UI_CreateCompent(frmCompose, IMAGE_TYPE, "proComposeHide", 217, 11, 56, 345)
GML_UI_LoadImage(proComposeHide, "texture/ui/manufacture.tga", NORMAL, 217, 11, 0, 461)

proCompose = GML_UI_CreateCompent(frmCompose, PROGRESS_TYPE, "proCompose", 217, 11, 56, 345)
GML_UI_LoadImage(proCompose, "texture/ui/manufacture.tga", PROGRESS_PROGRESS, 217, 11, 0, 450)

--  
imgBakCompose = GML_UI_CreateCompent(frmCompose, IMAGE_TYPE, "imgBakCompose", 325, 402, 0, 0)
GML_UI_LoadImage(imgBakCompose, "texture/ui/manufacture.tga", NORMAL, 325, 402, 0, 0)

-- 
labTitle = GML_UI_CreateCompent(frmCompose, LABELEX_TYPE, "labTitle", 400, 150, 10, 7)
GML_UI_SetCaption(labTitle, lstr(703))
GML_UI_SetTextColor(labTitle, COLOR_WHITE)

-- 
btnClose = GML_UI_CreateCompent(frmCompose, BUTTON_TYPE, "btnClose", 21, 21, 302, 2)
GML_UI_LoadButtonImage(btnClose, "texture/ui/buttons.tga", 21, 21, 270, 0, TRUE)
GML_UI_SetButtonModalResult(btnClose, BUTTON_CLOSE)

-- 
cmdItemBase4 = GML_UI_CreateCompent(frmCompose, COMMAND_ONE_TYPE, "cmdItemBase4", 33, 33, 59, 119)
GML_UI_SetHint(cmdItemBase4,lstr(704))

cmdItemBase5 = GML_UI_CreateCompent(frmCompose, COMMAND_ONE_TYPE, "cmdItemBase5", 33, 33, 147, 62)
GML_UI_SetHint(cmdItemBase5,lstr(705))

cmdItemBase6 = GML_UI_CreateCompent(frmCompose, COMMAND_ONE_TYPE, "cmdItemBase6", 33, 33, 232, 119)
GML_UI_SetHint(cmdItemBase6,lstr(706))

--  
cmdItemBase7 = GML_UI_CreateCompent(frmCompose, COMMAND_ONE_TYPE, "cmdItemBase7", 33, 33, 147, 168)

-- 
cmdItemBase3 = GML_UI_CreateCompent(frmCompose, COMMAND_ONE_TYPE, "cmdItemBase3", 33, 33,	39, 217)
GML_UI_SetHint(cmdItemBase3,lstr(707))

-- 
cmdItemBase2 = GML_UI_CreateCompent(frmCompose, COMMAND_ONE_TYPE, "cmdItemBase2", 33, 33, 252, 217)
GML_UI_SetHint(cmdItemBase2,lstr(708))

-- 
cmdItemBase1 = GML_UI_CreateCompent(frmCompose, COMMAND_ONE_TYPE, "cmdItemBase1", 33, 33, 147, 273)
GML_UI_SetHint(cmdItemBase1,lstr(709))

--  
labCharOutput = GML_UI_CreateCompent(frmCompose, LABELEX_TYPE, "labCharOutput", 56, 11, 221, 63)
GML_UI_SetCaption(labCharOutput, "ABCDEFGH")
GML_UI_SetTextColor(labCharOutput, COLOR_WHITE)

--  
btnLeftPage = GML_UI_CreateCompent(frmCompose, BUTTON_TYPE, "btnLeftPage", 14, 13, 40, 62)
GML_UI_LoadButtonImage(btnLeftPage, "texture/ui/buttons.tga", 14, 13, 270, 104, TRUE)

-- 
labNumInput = GML_UI_CreateCompent(frmCompose, LABELEX_TYPE, "labNumInput", 1, 1, 0, 0)
edtNumInput = GML_UI_CreateCompent(frmCompose, EDIT_TYPE,"edtNumInput", 28, 11, 65, 63)
GML_UI_SetEditMaxNum(edtNumInput, 3)
GML_UI_SetEditMaxNumVisible(edtNumInput,3)
GML_UI_SetIsKeyFocus(edtNumInput,FALSE)
GML_UI_SetTextColor(edtNumInput, COLOR_WHITE)

--  
btnRightPage = GML_UI_CreateCompent(frmCompose, BUTTON_TYPE, "btnRightPage", 14, 13,  98, 62)
GML_UI_LoadButtonImage(btnRightPage, "texture/ui/buttons.tga", 14, 13, 270, 117, TRUE)

-- 
btnForgeYes = GML_UI_CreateCompent(frmCompose, BUTTON_TYPE, "btnForgeYes", 67, 24, 86, 366)
GML_UI_LoadButtonImage(btnForgeYes, "texture/ui/buttons.tga", 67, 24, 0, 336, TRUE)

-- 
btnForgeNo = GML_UI_CreateCompent(frmCompose, BUTTON_TYPE, "btnForgeNo", 67, 24, 173, 366)
GML_UI_LoadButtonImage(btnForgeNo, "texture/ui/buttons.tga", 67, 24, 0, 360, TRUE)
end
GenFormCompose()

-----------------------------------------------------------------------
-- 
-----------------------------------------------------------------------
function GenFormAnalyse()
frmBreak = GML_UI_CreateForm("frmBreak", FALSE, 325, 402, 0, 100, TRUE, FALSE)
GML_UI_ShowForm(frmBreak, FALSE)
GML_UI_AddFormToTemplete(frmBreak, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmBreak, TRUE)
GML_UI_SetIsDrag(frmBreak,TRUE)
GML_UI_SetFormStyle(frmBreak,2)

--  
imgBreakFrame = GML_UI_CreateCompent(frmBreak, IMAGE_TYPE, "imgBreakFrame", 217, 11, 56, 345)
GML_UI_LoadImage(imgBreakFrame, "texture/ui/analysis.tga", NORMAL, 217, 11, 0, 461)

proBreak = GML_UI_CreateCompent(frmBreak, PROGRESS_TYPE, "proBreak", 217, 11, 56, 345)
GML_UI_LoadImage(proBreak, "texture/ui/analysis.tga", PROGRESS_PROGRESS, 217, 11, 0, 450)

--  
imgBakGround = GML_UI_CreateCompent(frmBreak, IMAGE_TYPE, "imgBakGround", 325, 402, 0, 0)
GML_UI_LoadImage(imgBakGround, "texture/ui/analysis.tga", NORMAL, 325, 402, 0, 0)

-- 
L_DrawTitle(frmBreak, lstr(710))

-- 
L_DrawClose(frmBreak, 325)

-- 
cmdItemBase4 = GML_UI_CreateCompent(frmBreak, COMMAND_ONE_TYPE, "cmdItemBase4", 32, 32, 148, 76)
GML_UI_SetHint(cmdItemBase4,lstr(687))

-- 
cmdItemBase3 = GML_UI_CreateCompent(frmBreak, COMMAND_ONE_TYPE, "cmdItemBase3", 32, 32, 148, 185)
GML_UI_SetHint(cmdItemBase3,lstr(685))

-- 
cmdItemBase2 = GML_UI_CreateCompent(frmBreak, COMMAND_ONE_TYPE, "cmdItemBase2", 32, 32, 50, 260)
GML_UI_SetHint(cmdItemBase2,lstr(707))

-- 
cmdItemBase1 = GML_UI_CreateCompent(frmBreak, COMMAND_ONE_TYPE, "cmdItemBase1", 32, 32, 243, 260)
GML_UI_SetHint(cmdItemBase1,lstr(709))

--   
labNumOutputLeft = GML_UI_CreateCompent(frmBreak, LABELEX_TYPE, "labNumOutputLeft", 10, 145, 42, 141)
GML_UI_SetCaption(labNumOutputLeft, "25000")
GML_UI_SetTextColor(labNumOutputLeft, COLOR_WHITE)

--    2
labNumOutputRight = GML_UI_CreateCompent(frmBreak, LABELEX_TYPE, "labNumOutputRight", 10, 145, 217, 141)
GML_UI_SetCaption(labNumOutputRight, "25000")
GML_UI_SetTextColor(labNumOutputRight, COLOR_WHITE)

-- 
btnForgeYes = L_DrawButton(frmBreak, "start", 86, 366, "btnForgeYes")

-- 
btnForgeNo = L_DrawButton(frmBreak, "stop", 173, 366, "btnForgeNo")
end
GenFormAnalyse()


-----------------------------------------------------------------------
-- 
-----------------------------------------------------------------------
function GenFormCooking()
frmCooking = GML_UI_CreateForm("frmCooking", FALSE, 325, 402, 240, 70, TRUE, FALSE)
GML_UI_ShowForm(frmCooking, FALSE)
GML_UI_AddFormToTemplete(frmCooking, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmCooking, TRUE)
GML_UI_SetIsDrag(frmCooking,TRUE)
GML_UI_SetFormStyle(frmCooking,2)

--  
proCookingHide = GML_UI_CreateCompent(frmCooking, IMAGE_TYPE, "proCookingHide", 217, 11, 56, 345)
GML_UI_LoadImage(proCookingHide, "texture/ui/cooking.tga", NORMAL, 217, 11, 0, 461)

proCooking = GML_UI_CreateCompent(frmCooking, PROGRESS_TYPE, "proCooking", 217, 11, 56, 345)
GML_UI_LoadImage(proCooking, "texture/ui/cooking.tga", PROGRESS_PROGRESS, 217, 11, 0, 450)

--  
imgBakCooking = GML_UI_CreateCompent(frmCooking, IMAGE_TYPE, "imgBakCooking", 325, 402, 0, 0)
GML_UI_LoadImage(imgBakCooking, "texture/ui/cooking.tga", NORMAL, 325, 402, 0, 0)

-- 
labTitle = GML_UI_CreateCompent(frmCooking, LABELEX_TYPE, "labTitle", 400, 150, 10, 7)
GML_UI_SetCaption(labTitle, lstr(711))
GML_UI_SetTextColor(labTitle, COLOR_WHITE)

-- 
btnClose = GML_UI_CreateCompent(frmCooking, BUTTON_TYPE, "btnClose", 21, 21, 302, 2)
GML_UI_LoadButtonImage(btnClose, "texture/ui/buttons.tga", 21, 21, 270, 0, TRUE)
GML_UI_SetButtonModalResult(btnClose, BUTTON_CLOSE)

-- 
cmdItemBase4 = GML_UI_CreateCompent(frmCooking, COMMAND_ONE_TYPE, "cmdItemBase4", 33, 33, 59, 119)
GML_UI_SetHint(cmdItemBase4,lstr(704))

cmdItemBase5 = GML_UI_CreateCompent(frmCooking, COMMAND_ONE_TYPE, "cmdItemBase5", 33, 33, 147, 62)
GML_UI_SetHint(cmdItemBase5,lstr(705))

cmdItemBase6 = GML_UI_CreateCompent(frmCooking, COMMAND_ONE_TYPE, "cmdItemBase6", 33, 33, 232, 119)
GML_UI_SetHint(cmdItemBase6,lstr(706))

--  
cmdItemBase7 = GML_UI_CreateCompent(frmCooking, COMMAND_ONE_TYPE, "cmdItemBase7", 33, 33, 147, 168)

-- 
cmdItemBase3 = GML_UI_CreateCompent(frmCooking, COMMAND_ONE_TYPE, "cmdItemBase3", 33, 33,	39, 217)
GML_UI_SetHint(cmdItemBase3,lstr(707))

-- 
cmdItemBase2 = GML_UI_CreateCompent(frmCooking, COMMAND_ONE_TYPE, "cmdItemBase2", 33, 33, 252, 217)
GML_UI_SetHint(cmdItemBase2,lstr(708))

--
cmdItemBase1 = GML_UI_CreateCompent(frmCooking, COMMAND_ONE_TYPE, "cmdItemBase1", 33, 33, 147, 273)
GML_UI_SetHint(cmdItemBase1,lstr(709))

-- 	
btnForgeYes = GML_UI_CreateCompent(frmCooking, BUTTON_TYPE, "btnForgeYes", 67, 24, 86, 366)
GML_UI_LoadButtonImage(btnForgeYes, "texture/ui/buttons.tga", 67, 24, 0, 336, TRUE)

-- 
btnForgeNo = GML_UI_CreateCompent(frmCooking, BUTTON_TYPE, "btnForgeNo", 67, 24, 173, 366)
GML_UI_LoadButtonImage(btnForgeNo, "texture/ui/buttons.tga", 67, 24, 0, 360, TRUE)
end
GenFormCooking()


-----------------------------------------------------------------------
--  -
-----------------------------------------------------------------------
function GenFormQuestion()
frmQuestion = GML_UI_CreateForm("frmQuestion", FALSE, 235, 317, 0, 0, TRUE, FALSE)
GML_UI_ShowForm(frmQuestion, FALSE)
GML_UI_AddFormToTemplete(frmQuestion, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmQuestion, TRUE)
GML_UI_SetIsDrag(frmQuestion,TRUE)
GML_UI_SetFormStyle(frmQuestion,2)

--GML_UI_FormSetHotKey(frmQuestion, ALT_KEY, HOTKEY_G)

--??
imgMissonT = GML_UI_CreateCompent(frmQuestion, IMAGE_TYPE, "imgMissonT", 235, 111, 0, 0)
GML_UI_LoadImage(imgMissonT, "texture/ui/answer.tga", NORMAL, 235, 111, 0, 0)
imgMissonD = GML_UI_CreateCompent(frmQuestion, IMAGE_TYPE, "imgMissonD", 235, 206, 0, 111)
GML_UI_LoadImage(imgMissonD, "texture/ui/question.tga", NORMAL, 235, 206, 0, 0)

--title
labMisson = GML_UI_CreateCompent(frmQuestion, LABELEX_TYPE, "labMisson", 47, 11, 3, 3)
GML_UI_SetCaption(labMisson, lstr(712))
GML_UI_SetTextColor(labMisson, COLOR_BLACK)
GML_UI_SetLabelExFont(labMisson, DEFAULT_FONT, TRUE, COLOR_WHITE)

--????
--??
edtQuestionTitle= GML_UI_CreateCompent(frmQuestion, EDIT_TYPE,"edtQuestionTitle",197, 21, 23, 43)
GML_UI_SetEditMaxNum(edtQuestionTitle, 256)
GML_UI_SetEditMaxNumVisible(edtDoublePwdAlterNew,30)

--??
memCentent  = GML_UI_CreateCompent(frmQuestion, MEMO_TYPE, "memCentent", 140, 210, 21, 95)
GML_UI_SetCaption(memCentent, "400")
GML_UI_SetTextColor(memCentent, COLOR_BLACK)
GML_UI_SetLabelExFont(memCentent, DEFAULT_FONT, TRUE, COLOR_WHITE)
GML_UI_SetMemoPageShowNum(memCentent, 9)
GML_UI_SetMemoMaxNumPerRow(memCentent, 31)

	labNotice = GML_UI_CreateCompent(frmQuestion, LABELEX_TYPE, "labNotice", 400, 150, 15 ,73)
	GML_UI_SetCaption(labNotice, lstr(713))
	GML_UI_SetTextColor(labNotice, COLOR_RED)
	GML_UI_SetLabelExFont(labNotice, DEFAULT_FONT, TRUE, COLOR_WHITE)
	
--??????
	btnSubmit = GML_UI_CreateCompent(frmQuestion, BUTTON_TYPE, "btnSubmit", 48, 19, 170, 287)
	GML_UI_LoadButtonImage(btnSubmit, "texture/ui/store8.tga", 48, 19, 0, 76, FALSE)

	labSubmit = GML_UI_CreateCompent(frmQuestion, LABELEX_TYPE, "labSubmit", 400 , 150 , 179 , 289)
	GML_UI_SetCaption(labSubmit, lstr(714))
	GML_UI_SetTextColor(labSubmit, COLOR_BLACK)
	GML_UI_SetLabelExFont(labSubmit, DEFAULT_FONT, TRUE, COLOR_WHITE)

--??????
btnClose = GML_UI_CreateCompent(frmQuestion, BUTTON_TYPE, "btnClose", 14, 14, 215, 3)
GML_UI_LoadButtonImage(btnClose, "texture/ui/PublicC.tga", 14, 14, 116, 175, TRUE)
GML_UI_SetButtonModalResult(btnClose, BUTTON_CLOSE)
end
GenFormQuestion()

-----------------------------------------------------------------------
--   -
-----------------------------------------------------------------------
function GenFormAnswer()
frmAnswer = GML_UI_CreateForm("frmAnswer", FALSE, 235, 317, 0, 0, TRUE, FALSE)
GML_UI_ShowForm(frmAnswer, FALSE)
GML_UI_AddFormToTemplete(frmAnswer, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmAnswer, TRUE)
GML_UI_SetIsDrag(frmAnswer,TRUE)
GML_UI_SetFormStyle(frmAnswer,2)

--GML_UI_FormSetHotKey(frmAnswer, ALT_KEY, HOTKEY_Z)

--??
imgMissonT = GML_UI_CreateCompent(frmAnswer, IMAGE_TYPE, "imgMissonT", 235, 111, 0, 0)
GML_UI_LoadImage(imgMissonT, "texture/ui/answer.tga", NORMAL, 235, 111, 0,111)
imgMissonD = GML_UI_CreateCompent(frmAnswer, IMAGE_TYPE, "imgMissonD", 235, 206, 0, 111)
GML_UI_LoadImage(imgMissonD, "texture/ui/question.tga", NORMAL, 235, 206, 0, 0)

--title
labMisson = GML_UI_CreateCompent(frmAnswer, LABELEX_TYPE, "labMisson", 47, 11, 3, 3)
GML_UI_SetCaption(labMisson, lstr(715))
GML_UI_SetTextColor(labMisson, COLOR_BLACK)
GML_UI_SetLabelExFont(labMisson, DEFAULT_FONT, TRUE, COLOR_WHITE)

--????
memMiss  = GML_UI_CreateCompent(frmAnswer, MEMO_TYPE, "memMiss", 197, 230, 20, 44)
GML_UI_SetCaption(memMiss, "400")
GML_UI_SetTextColor(memMiss, COLOR_BLACK)
GML_UI_SetLabelExFont(memMiss, DEFAULT_FONT, TRUE, COLOR_WHITE)
GML_UI_SetMemoPageShowNum(memMiss, 9)
GML_UI_SetMemoMaxNumPerRow(memMiss, 31)

--??????
btnClose = GML_UI_CreateCompent(frmAnswer, BUTTON_TYPE, "btnClose", 14, 14, 215, 3)
GML_UI_LoadButtonImage(btnClose, "texture/ui/PublicC.tga", 14, 14, 116, 175, TRUE)
GML_UI_SetButtonModalResult(btnClose, BUTTON_CLOSE)
end
GenFormAnswer()

-----------------------------------------------------------------------
-- ????????  2007.1.29  by Leo
-----------------------------------------------------------------------
frmAlphaMatte = GML_UI_CreateForm("frmAlphaMatte", FALSE, 800, 600, 0, 0, TRUE, FALSE)
GML_UI_ShowForm(frmAlphaMatte, FALSE)
GML_UI_AddFormToTemplete(frmAlphaMatte, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmAlphaMatte, FALSE)
GML_UI_SetIsDrag(frmAlphaMatte,FALSE)

-----------------------------------------------------------------------
-- ???????  2007.02.12  by Leo
-----------------------------------------------------------------------
function GenFormStoreLoad()
frmStoreLoad = GML_UI_CreateForm("frmStoreLoad", FALSE, 200, 80, 0, 0, TRUE, FALSE)
GML_UI_ShowForm(frmStoreLoad, FALSE)
GML_UI_AddFormToTemplete(frmStoreLoad, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmStoreLoad, FALSE)
GML_UI_SetIsDrag(frmStoreLoad,FALSE)

proStoreLoad= GML_UI_CreateCompent(frmStoreLoad, PROGRESS_TYPE, "proStoreLoad", 160, 13,20, 10)
GML_UI_LoadImage(proStoreLoad, "texture/ui/Progress.tga", PROGRESS_PROGRESS, 157, 13, 0, 0)

labStoreLoad = GML_UI_CreateCompent(frmStoreLoad, LABELEX_TYPE, "labStoreLoad", 400, 150, 0,30)
GML_UI_SetCaption(labStoreLoad, lstr(716))
GML_UI_SetTextColor(labStoreLoad, COLOR_BLACK)
GML_UI_SetLabelExFont(labStoreLoad, BIGFONT, FALSE, COLOR_WHITE)
end
GenFormStoreLoad()

-----------------------------------------------------------------------
-- ????????
-----------------------------------------------------------------------
-- ????????
function GenFormStoreDark()
frmStoreDark = GML_UI_CreateForm("frmStoreDark", FALSE, 98, 36, 380, 507, TRUE, FALSE)
GML_UI_ShowForm(frmStoreDark, TRUE)
GML_UI_AddFormToTemplete(frmStoreDark, FORM_MAIN)
GML_UI_SetFormStyleEx(frmStoreDark, 7, 0, 2)
GML_UI_FormSetIsEscClose(frmStoreDark, FALSE)

-- ??????
imgBack = GML_UI_CreateCompent(frmStoreDark, IMAGE_TYPE, "imgBack", 1024, 768, -380, -675)
GML_UI_LoadImage(imgBack, "texture/ui/select4.tga", NORMAL, 1, 1, 232, 1)

-- ??logo??
imgLogo = GML_UI_CreateCompent(frmStoreDark, IMAGE_TYPE, "imgLogo", 242, 115, -100, -410)
--GML_UI_LoadImage(imgLogo, "texture/ui/logot.tga", NORMAL, 242, 115, 0, 0)
end
GenFormStoreDark()

-----------------------------------------------------------------------
--  
-----------------------------------------------------------------------
function GenForm_ChurchSale()
	frmChurchSale = GML_UI_CreateForm("frmChurchSale", FALSE, 558, 291, 380, 507, TRUE, FALSE)
	GML_UI_ShowForm(frmChurchSale, TRUE)
	GML_UI_AddFormToTemplete(frmChurchSale, FORM_MAIN)
	GML_UI_FormSetIsEscClose(frmChurchSale, FALSE)
	GML_UI_SetIsDrag(frmChurchSale,TRUE)
	GML_UI_SetFormStyle(frmChurchSale,1)
	
	--GML_UI_FormSetHotKey(frmChurchSale, ALT_KEY, HOTKEY_Z)
	
	-- ??????
	imgBack01 = GML_UI_CreateCompent(frmChurchSale, IMAGE_TYPE, "imgBack01", 256,256,0,0)
	GML_UI_LoadImage(imgBack01, "texture/ui/church01.tga", NORMAL, 256, 256, 0, 0)
	
	imgBack02 = GML_UI_CreateCompent(frmChurchSale, IMAGE_TYPE, "imgBack02", 256,256,256,0)
	GML_UI_LoadImage(imgBack02, "texture/ui/church02.tga", NORMAL, 256, 256, 0, 0)
	
	imgBack03 = GML_UI_CreateCompent(frmChurchSale, IMAGE_TYPE, "imgBack03", 46,256,512,0)
	GML_UI_LoadImage(imgBack03, "texture/ui/church04.tga", NORMAL, 46, 256, 0, 0)
	
	imgBack04 = GML_UI_CreateCompent(frmChurchSale, IMAGE_TYPE, "imgBack04", 256,35,0,256)
	GML_UI_LoadImage(imgBack04, "texture/ui/church03.tga", NORMAL, 256, 35, 0, 0)
	
	imgBack05 = GML_UI_CreateCompent(frmChurchSale, IMAGE_TYPE, "imgBack05", 256,35,256,256)
	GML_UI_LoadImage(imgBack05, "texture/ui/church03.tga", NORMAL, 256, 35, 0, 74)
	
	imgBack06 = GML_UI_CreateCompent(frmChurchSale, IMAGE_TYPE, "imgBack06", 46,35,512,256)
	GML_UI_LoadImage(imgBack06, "texture/ui/church04.tga", NORMAL, 46, 35, 46, 0)
	
	btnPriceUp = GML_UI_CreateCompent(frmChurchSale, BUTTON_TYPE, "btnPriceUp", 41, 19, 492, 118)
	GML_UI_LoadButtonImage(btnPriceUp, "texture/ui/church03.tga", 41, 19, 1, 55, TRUE)
	
	--????label
	labInfoShow1 = GML_UI_CreateCompent(frmChurchSale, LABELEX_TYPE, "labInfoShow1", 124, 16,24,122)
	GML_UI_SetCaption(labInfoShow1, lstr(717))
	GML_UI_SetTextColor(labInfoShow1, COLOR_BLACK)
	GML_UI_SetLabelExFont(labInfoShow1, DEFAULT_FONT, FALSE, COLOR_WHITE)
	
	labInfoShow2 = GML_UI_CreateCompent(frmChurchSale, LABELEX_TYPE, "labInfoShow2", 124, 16, 186,122)
	GML_UI_SetCaption(labInfoShow2, lstr(718))
	GML_UI_SetTextColor(labInfoShow2, COLOR_BLACK)
	GML_UI_SetLabelExFont(labInfoShow2, DEFAULT_FONT, FALSE, COLOR_WHITE)
	
	labInfoShow3 = GML_UI_CreateCompent(frmChurchSale, LABELEX_TYPE, "labInfoShow3", 98, 16,373,122)
	GML_UI_SetCaption(labInfoShow3, lstr(719))
	GML_UI_SetTextColor(labInfoShow3, COLOR_BLACK)
	GML_UI_SetLabelExFont(labInfoShow3, DEFAULT_FONT, FALSE, COLOR_WHITE)
	
	labTittle = GML_UI_CreateCompent(frmChurchSale, LABELEX_TYPE, "labTittle", 496,16,23,35)
	GML_UI_SetCaption(labTittle, lstr(720))
	GML_UI_SetTextColor(labTittle, COLOR_BLACK)
	GML_UI_SetLabelExFont(labTittle, DEFAULT_FONT, FALSE, COLOR_WHITE)
	
	
	--????label
	labTextShow = GML_UI_CreateCompent(frmChurchSale, LABELEX_TYPE, "labTextShow", 496,16,23,202)
	GML_UI_SetCaption(labTextShow, lstr(721))
	GML_UI_SetTextColor(labTextShow, COLOR_BLACK)
	GML_UI_SetLabelExFont(labTextShow, DEFAULT_FONT, FALSE, COLOR_WHITE)
	
	labTextShow = GML_UI_CreateCompent(frmChurchSale, LABELEX_TYPE, "labTextShow", 496,16,23,216)
	GML_UI_SetCaption(labTextShow, lstr(722))
	GML_UI_SetTextColor(labTextShow, COLOR_BLACK)
	GML_UI_SetLabelExFont(labTextShow, DEFAULT_FONT, FALSE, COLOR_WHITE)
	
	labTextShow = GML_UI_CreateCompent(frmChurchSale, LABELEX_TYPE, "labTextShow", 496,16,23,230)
	GML_UI_SetCaption(labTextShow, lstr(723))
	GML_UI_SetTextColor(labTextShow, COLOR_BLACK)
	GML_UI_SetLabelExFont(labTextShow, DEFAULT_FONT, FALSE, COLOR_WHITE)
	
	labTextShow = GML_UI_CreateCompent(frmChurchSale, LABELEX_TYPE, "labTextShow", 496,16,23,244)
	GML_UI_SetCaption(labTextShow, lstr(724))
	GML_UI_SetTextColor(labTextShow, COLOR_BLACK)
	GML_UI_SetLabelExFont(labTextShow, DEFAULT_FONT, FALSE, COLOR_WHITE)
	
	--??????
	btnClose = GML_UI_CreateCompent(frmChurchSale, BUTTON_TYPE, "btnClose", 14, 14, 538, 3)
	GML_UI_LoadButtonImage(btnClose, "texture/ui/PublicC.tga", 14, 14, 116, 175, TRUE)
	GML_UI_SetButtonModalResult(btnClose, BUTTON_CLOSE)
end
GenForm_ChurchSale()

function GenFormKraft()
local frmFound = GML_UI_CreateForm("frmFound2", FALSE, 323, 402, 240, 70, TRUE, FALSE)

GML_UI_ShowForm(frmFound, FALSE)
GML_UI_AddFormToTemplete(frmFound, FORM_MAIN)
GML_UI_FormSetIsEscClose(frmFound, TRUE)
GML_UI_SetIsDrag(frmFound,TRUE)
GML_UI_SetFormStyle(frmFound, 2)

	--  
	local imgFoundFrame = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgFoundFrame", 217, 11, 56, 345)
	GML_UI_LoadImage(imgFoundFrame, "texture/ui/craft.tga", NORMAL, 217, 11, 0, 461)
	
	local proFound = GML_UI_CreateCompent(frmFound, PROGRESS_TYPE, "proFound", 217, 11, 56, 345)
	GML_UI_LoadImage(proFound, "texture/ui/craft.tga", PROGRESS_PROGRESS, 217, 11, 0, 450)


--  
imgBakCompose = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgBakCompose", 325, 402, 0, 0)
GML_UI_LoadImage(imgBakCompose, "texture/ui/craft.tga", NORMAL, 325, 402, 0, 0)

-- 
L_DrawTitle(frmFound, lstr(725))

-- 
L_DrawClose(frmFound, 323)

-- 
cmdItemBase4 = GML_UI_CreateCompent(frmFound, COMMAND_ONE_TYPE, "cmdItemBase4", 33, 33, 59, 119)
GML_UI_SetHint(cmdItemBase4,lstr(704))

cmdItemBase5 = GML_UI_CreateCompent(frmFound, COMMAND_ONE_TYPE, "cmdItemBase5", 33, 33, 147, 62)
GML_UI_SetHint(cmdItemBase5,lstr(705))

cmdItemBase6 = GML_UI_CreateCompent(frmFound, COMMAND_ONE_TYPE, "cmdItemBase6", 33, 33, 232, 119)
GML_UI_SetHint(cmdItemBase6,lstr(706))

--  
cmdItemBase7 = GML_UI_CreateCompent(frmFound, COMMAND_ONE_TYPE, "cmdItemBase7", 33, 33, 147, 168)

-- 
cmdItemBase3 = GML_UI_CreateCompent(frmFound, COMMAND_ONE_TYPE, "cmdItemBase3", 33, 33, 39, 217)
GML_UI_SetHint(cmdItemBase3,lstr(707))

-- 
cmdItemBase2 = GML_UI_CreateCompent(frmFound, COMMAND_ONE_TYPE, "cmdItemBase2", 33, 33, 252, 217)
GML_UI_SetHint(cmdItemBase2,lstr(708))

-- 
cmdItemBase1 = GML_UI_CreateCompent(frmFound, COMMAND_ONE_TYPE, "cmdItemBase1", 33, 33, 147, 273)
GML_UI_SetHint(cmdItemBase1,lstr(709))

-- 

--  
imgShaiZi1_1 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi1_1", 24, 24, 78, 366)
GML_UI_LoadImage(imgShaiZi1_1, "texture/ui/craft.tga", NORMAL, 24, 24, 0, 424)
-- GML_UI_SetIsShow(imgShaiZi1_1,FALSE)

imgShaiZi1_2 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi1_2", 24, 24, 78, 366)
GML_UI_LoadImage(imgShaiZi1_2, "texture/ui/craft.tga", NORMAL, 24, 24, 24, 424)
GML_UI_SetIsShow(imgShaiZi1_2,FALSE)

imgShaiZi1_3 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi1_3", 24, 24, 78, 366)
GML_UI_LoadImage(imgShaiZi1_3, "texture/ui/craft.tga", NORMAL, 24, 24, 48, 424)
GML_UI_SetIsShow(imgShaiZi1_3,FALSE)

imgShaiZi1_4 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi1_4", 24, 24, 78, 366)
GML_UI_LoadImage(imgShaiZi1_4, "texture/ui/craft.tga", NORMAL, 24, 24, 72, 424)
GML_UI_SetIsShow(imgShaiZi1_4,FALSE)

imgShaiZi1_5 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi1_5", 24, 24, 78, 366)
GML_UI_LoadImage(imgShaiZi1_5, "texture/ui/craft.tga", NORMAL, 24, 24, 96, 424)
GML_UI_SetIsShow(imgShaiZi1_5,FALSE)

imgShaiZi1_6 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi1_6", 24, 24, 78, 366)
GML_UI_LoadImage(imgShaiZi1_6, "texture/ui/craft.tga", NORMAL, 24, 24, 120, 424)
GML_UI_SetIsShow(imgShaiZi1_6,FALSE)

--  
imgShaiZi2_1 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi2_1", 24, 24, 104, 366)
GML_UI_LoadImage(imgShaiZi2_1, "texture/ui/craft.tga", NORMAL, 24, 24, 0, 424)
-- GML_UI_SetIsShow(imgShaiZi2_1,FALSE)

imgShaiZi2_2 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi2_2", 24, 24, 104, 366)
GML_UI_LoadImage(imgShaiZi2_2, "texture/ui/craft.tga", NORMAL, 24, 24, 24, 424)
GML_UI_SetIsShow(imgShaiZi2_2,FALSE)

imgShaiZi2_3 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi2_3", 24, 24, 104, 366)
GML_UI_LoadImage(imgShaiZi2_3, "texture/ui/craft.tga", NORMAL, 24, 24, 48, 424)
GML_UI_SetIsShow(imgShaiZi2_3,FALSE)

imgShaiZi2_4 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi2_4", 24, 24, 104, 366)
GML_UI_LoadImage(imgShaiZi2_4, "texture/ui/craft.tga", NORMAL, 24, 24, 72, 424)
GML_UI_SetIsShow(imgShaiZi2_4,FALSE)

imgShaiZi2_5 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi2_5", 24, 24, 104, 366)
GML_UI_LoadImage(imgShaiZi2_5, "texture/ui/craft.tga", NORMAL, 24, 24, 96, 424)
GML_UI_SetIsShow(imgShaiZi2_5,FALSE)

imgShaiZi2_6 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi2_6", 24, 24, 104, 366)
GML_UI_LoadImage(imgShaiZi2_6, "texture/ui/craft.tga", NORMAL, 24, 24, 120, 424)
GML_UI_SetIsShow(imgShaiZi2_6,FALSE)

--  
imgShaiZi3_1 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi3_1", 24, 24, 130, 366)
GML_UI_LoadImage(imgShaiZi3_1, "texture/ui/craft.tga", NORMAL, 24, 24, 0, 424)
-- GML_UI_SetIsShow(imgShaiZi3_1,FALSE)

imgShaiZi3_2 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi3_2", 24, 24, 130, 366)
GML_UI_LoadImage(imgShaiZi3_2, "texture/ui/craft.tga", NORMAL, 24, 24, 24, 424)
GML_UI_SetIsShow(imgShaiZi3_2,FALSE)

imgShaiZi3_3 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi3_3", 24, 24, 130, 366)
GML_UI_LoadImage(imgShaiZi3_3, "texture/ui/craft.tga", NORMAL, 24, 24, 48, 424)
GML_UI_SetIsShow(imgShaiZi3_3,FALSE)

imgShaiZi3_4 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi3_4", 24, 24, 130, 366)
GML_UI_LoadImage(imgShaiZi3_4, "texture/ui/craft.tga", NORMAL, 24, 24, 72, 424)
GML_UI_SetIsShow(imgShaiZi3_4,FALSE)

imgShaiZi3_5 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi3_5", 24, 24, 130, 366)
GML_UI_LoadImage(imgShaiZi3_5, "texture/ui/craft.tga", NORMAL, 24, 24, 96, 424)
GML_UI_SetIsShow(imgShaiZi3_5,FALSE)

imgShaiZi3_6 = GML_UI_CreateCompent(frmFound, IMAGE_TYPE, "imgShaiZi3_6", 24, 24, 130, 366)
GML_UI_LoadImage(imgShaiZi3_6, "texture/ui/craft.tga", NORMAL, 24, 24, 120, 424)
GML_UI_SetIsShow(imgShaiZi3_6,FALSE)

-- 
btnBigBig = GML_UI_CreateCompent(frmFound, BUTTON_TYPE, "btnBigBig", 24, 24, 156, 366)
GML_UI_LoadButtonImage(btnBigBig, "texture/ui/craft.tga", 24, 24, 374, 0, FALSE)

-- 
btnSmallSmall = GML_UI_CreateCompent(frmFound, BUTTON_TYPE, "btnSmallSmall", 24, 24, 52, 366)
GML_UI_LoadButtonImage(btnSmallSmall, "texture/ui/craft.tga", 24, 24, 398, 0, FALSE)

-- 
btnForgeYes = L_DrawButton(frmFound, "start", 210, 366, "btnForgeYes")
end
GenFormKraft()


--------------------------------------------------------------------
-- 
-----------------------------------------------------------------------
--------------------------
-- 
--------------------------

--	
--	----
--	-- : 
--	----
--	
--	--  
--	function GenFormLetters1()
--		--    
--		local form = L_SetForm({
--			system_name	= "lettersForm",
--			arr_size	= {300, 410},
--			text_title	= ""
--		})
--		--UI_FormSetHotKey(form, ALT_KEY, HOTKEY_J)
--		
--		--     
--		for i = 1, 7 do
--			L_CreateBG({
--				form_name = form, arr_pos_area = {9 , 49 + (i - 1) * 47}, arr_size = {281, 44}
--			})
--		end
--		
--		--   
--		for i = 1, 7 do	
--			L_ItemBG(form, {33, 51 + ((i - 1) * 47)}, nil, "seasonItemBg"..i)
--		end
--		
--		----
--		--   
--		----
--		
--		--  
--		L_RowText(
--			form, 
--			"seasonNowPage", 
--			1,								-- type (gold)
--			"",	-- hint 
--			{39, 18},						-- : width, height
--			{130, 382},						--  : xpos, ypos
--			1
--		)
--		--  \
--		local BtnNextPage = UI_CreateCompent(form, BUTTON_TYPE, "seasonBackBtn", 16, 16, 114, 383)
--		UI_LoadButtonImage(BtnNextPage, "texture/ui_morgan/buttons.png", 16, 16, 0, 109, TRUE)
--		
--		local BtnBackPage = UI_CreateCompent(form, BUTTON_TYPE, "seasonNextBtn", 16, 16, 169, 383)
--		UI_LoadButtonImage(BtnBackPage, "texture/ui_morgan/buttons.png", 16, 16, 0, 125, TRUE)
--		
--		
--		
--		--  
--		local arr_data = {
--					system_name		= "MailWrite",																--   
--					text			= "",										-- ""   
--					hint			= " ",				-- " "   
--					arr_area		= {224, 27},																--  
--	
--				}
--				L_StaticBtn(form, arr_data)
--			
--		-- 
--		for i = 1, 7 do
--			check_box = UI_CreateCompent(form, CHECK_TYPE, "cbxMail_"..i, 13, 13, 15, 18 + (47 * i))
--			UI_LoadImage(check_box, "texture/ui_morgan/buttons", UNCHECKED, 13, 13, 52, 17)
--			UI_LoadImage(check_box, "texture/ui_morgan/buttons", CHECKED, 13, 13, 39, 17)
--			UI_AddGroupBox(check_box_group, check_box)
--		end
--		
--		
--		
--		----
--		-- 
--		----
--		
--		-- 
--		for i = 1, 7 do
--			--  ""
--			L_Text(form, {
--				system_name	= "MailSender"..i,
--				arr_size	= {115, 15},
--				arr_area	= {84, 9 + (i * 47)},
--				--hint		= "",
--				
--				arr_text	= {
--					text			= "",
--					--font			= DEFAULT_FONT,
--					--color			= COLOR_WHITE,
--					--shadow		= FALSE,
--					--shadow_color	= COLOR_WHITE,
--					--center		= 1,
--				}
--			})
--		end
--		
--		-- 
--		for i = 1, 7 do
--			--  " "
--			L_Text(form, {
--				system_name	= "MailSenderTopic"..i,
--				arr_size	= {115, 15},
--				arr_area	= {84, 25 + (i * 47)},
--				--hint		= "",
--				
--				arr_text	= {
--					text			= " ",
--					--font			= DEFAULT_FONT,
--					--color			= COLOR_WHITE,
--					--shadow		= FALSE,
--					--shadow_color	= COLOR_WHITE,
--					--center		= 1,
--				}
--			})
--	
--		end
--		
--	end
--	GenFormLetters1()
--	
--	
--	
--	
--	
--	 -- 
--	function GenFormLetters2()
--		--    
--		local form = L_SetForm({
--			system_name	= "seasonForm",
--			arr_size	= {300, 410},
--			text_title	= " "
--		})
--		
--		UI_FormSetHotKey(form, ALT_KEY, HOTKEY_J)
--	
--		--  " "
--		L_Text(form, {
--			--system_name	= "",
--			arr_size	= {68, 13},
--			arr_area	= {117, 30},
--			--hint		= "",
--			
--			arr_text	= {
--				text			= " ",
--				--font			= DEFAULT_FONT,
--				--color			= COLOR_WHITE,
--				--shadow		= FALSE,
--				--shadow_color	= COLOR_WHITE,
--				--center		= 1,
--			}
--		})
--	
--		--  
--		local arr_data = {
--					system_name		= "MailBack",																--   
--					text			= "",													-- ""   
--					hint			= " ",				-- " "   
--					arr_area		= {9, 27},																	--  
--	
--				}
--				L_StaticBtn(form, arr_data)
--	
--	
--	
--		--  
--		local arr_data = {
--					system_name		= "MailSend",																	--   
--					text			= "",										-- ""   
--					hint			= " ",				-- " "   
--					arr_area		= {117, 384},																	--  
--	
--				}
--				L_StaticBtn(form, arr_data)
--	
--	
--	
--	
--	
--	
--	
--	--       
--			L_CreateBG({
--						form_name = form, arr_pos_area = {9,49} , arr_size = {282, 48}
--					})
--	
--		--  ":"
--		L_Text(form, {
--			--system_name	= "",
--			arr_size	= {60, 13},
--			arr_area	= {19, 57},
--			--hint		= "",
--			
--			arr_text	= {
--				text			= ":",
--				--font			= DEFAULT_FONT,
--				--color			= COLOR_WHITE,
--				--shadow		= FALSE,
--				--shadow_color	= COLOR_WHITE,
--				--center		= 1,
--			}
--		})
--	
--	-- 	  
--	L_OldRowInput(
--		form, 
--		"inpMailName", 
--		1,																-- type (1 --   )
--		16,																--   
--		" ",	-- hint ( )
--		{180, 18},														-- : width, height
--		{105, 54}														--  : xpos, ypos
--	)
--	
--	
--	
--	
--		--  ":"
--		L_Text(form, {
--			--system_name	= "",
--			arr_size	= {40, 13},
--			arr_area	= {19, 77},
--			--hint		= "",
--			
--			arr_text	= {
--				text			= ":",
--				--font			= DEFAULT_FONT,
--				--color			= COLOR_WHITE,
--				--shadow		= FALSE,
--				--shadow_color	= COLOR_WHITE,
--				--center		= 1,
--			}
--		})
--	
--	-- 	 
--	L_OldRowInput(
--		form, 
--		"inpMailLine", 
--		1,																-- type (1 --   )
--		16,																--   
--		" ",					-- hint ( )
--		{180, 18},														-- : width, height
--		{105, 74}														--  : xpos, ypos
--	)
--	
--	
--	
--		--     
--				L_CreateBG({
--							form_name = form, arr_pos_area = {9,296} , arr_size = {282, 50}
--						})
--			--   
--			for i = 1, 6 do	
--				L_ItemBG(form, {15 + ((i - 1) * 46), 301 }, nil, "seasonItemBg"..i)
--			end
--	
--	
--	
--		--     
--				L_CreateBG({
--							form_name = form, arr_pos_area = {9,351} , arr_size = {282, 28}
--						})
--	
--	--  
--	L_RowText(
--		form, 
--		"labGoldMail", 
--		2,																-- type (gold)
--		",    ",	-- hint (,    )
--		{131, 18},														-- : width, height
--		{14, 356}														--  : xpos, ypos
--	)
--	
--	
--	btnMailPlusGold = UI_CreateCompent(form, BUTTON_TYPE, "btnMailPlusGold", 14, 14, 129, 358)
--	UI_LoadButtonImage(btnMailPlusGold, "texture/ui_morgan/buttons.png", 14, 14, 0, 155, TRUE)
--	UI_SetHint(btnMailPlusGold, " ")
--	
--	
--	
--	--  
--	L_RowText(
--		form, 
--		"labCrysMail", 
--		2,																-- type (gold)
--		",    ",	-- hint (,    )
--		{131, 18},														-- : width, height
--		{155, 356}														--  : xpos, ypos
--	)
--	
--	
--	btnMailPlusCrys = UI_CreateCompent(form, BUTTON_TYPE, "btnMailPlusCrys", 14, 14, 270	, 358)
--	UI_LoadButtonImage(btnMailPlusCrys, "texture/ui_morgan/buttons.png", 14, 14, 0, 155, TRUE)
--	UI_SetHint(btnMailPlusCrys, " ")
--	
--	
--	
--	
--	end
--	GenFormLetters2()
--	
---

