


------
-- 
------
function L_DrawScroll(formObject, alfa, type)
	local alfa = alfa or 0
	local type = type or 0
	
	if type == 0 then
		local scrollid = GML_UI_GetScroll( formObject )
		GML_UI_SetSize( scrollid, 11, 1 )
		
		--  
		local id = GML_UI_GetScrollObj( scrollid, SCROLL_UP )
		GML_UI_LoadButtonImage( id, "texture/ui_morgan/buttons.png", 9, 6, 9, 30, TRUE )
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 9, 6)
	
		--  
		id = GML_UI_GetScrollObj( scrollid, SCROLL_SCROLL )
		GML_UI_LoadImage( id, "texture/ui_morgan/buttons.png", COMPENT_BACK, 9, 31, 0, 30)
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 9, 31)
	
		--  
		id = GML_UI_GetScrollObj( scrollid, SCROLL_DOWN )
		GML_UI_LoadButtonImage( id, "texture/ui_morgan/buttons.png", 9, 6, 9, 36, TRUE )
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 9, 6)
	elseif type == 3 then
		local scrollid = GML_UI_GetScroll( formObject )
		GML_UI_SetSize( scrollid, 7, 1)
		
		--  
		local id = GML_UI_GetScrollObj( scrollid, SCROLL_UP )
		GML_UI_LoadButtonImage( id, "texture/ui_morgan/buttons.png", 9, 6, 9, 30, TRUE )
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 7, 6)
	
		--  
		id = GML_UI_GetScrollObj( scrollid, SCROLL_SCROLL )
		GML_UI_LoadImage( id, "texture/ui_morgan/buttons.png", COMPENT_BACK, 9, 31, 0, 30)
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 7, 32)
	
		--  
		id = GML_UI_GetScrollObj( scrollid, SCROLL_DOWN )
		GML_UI_LoadButtonImage( id, "texture/ui_morgan/buttons.png", 9, 6, 9, 36, TRUE )
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 7, 6)
	elseif type == 10 then
		local scrollid = GML_UI_GetScroll( formObject )
		GML_UI_SetSize( scrollid, 29, 1 )
		
		--  
		local id = GML_UI_GetScrollObj( scrollid, SCROLL_UP )
		GML_UI_LoadButtonImage( id, "texture/ui_morgan/buttons.png", 9, 6, 9, 30, TRUE )
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 9, 6)
	
		--  
		id = GML_UI_GetScrollObj( scrollid, SCROLL_SCROLL )
		GML_UI_LoadImage( id, "texture/ui_morgan/buttons.png", COMPENT_BACK, 9, 31, 0, 30)
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 9, 31)
	
		--  
		id = GML_UI_GetScrollObj( scrollid, SCROLL_DOWN )
		GML_UI_LoadButtonImage( id, "texture/ui_morgan/buttons.png", 9, 6, 9, 36, TRUE )
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 9, 6)	
	else
		local scrollid = GML_UI_GetScroll( formObject )
		GML_UI_SetSize( scrollid, 7, 1)
		
		--  
		local id = GML_UI_GetScrollObj( scrollid, SCROLL_UP )
		GML_UI_LoadButtonImage( id, "texture/ui_morgan/buttons.png", 9, 6, 9, 30, TRUE )
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 7, 6)
	
		--  
		id = GML_UI_GetScrollObj( scrollid, SCROLL_SCROLL )
		GML_UI_LoadImage( id, "texture/ui_morgan/buttons.png", COMPENT_BACK, 9, 31, 0, 30)
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 7, 31)
	
		--  
		id = GML_UI_GetScrollObj( scrollid, SCROLL_DOWN )
		GML_UI_LoadButtonImage( id, "texture/ui_morgan/buttons.png", 9, 6, 9, 36, TRUE )
		if alfa > 0 then
			GML_UI_SetImageAlpha(id, alfa)
		end
		GML_UI_SetSize( id, 7, 6)
	end
end

------
--  
-- width -   
------
function L_DrawClose(formObject, width)
	local btnClose = GML_UI_CreateCompent( formObject, BUTTON_TYPE, "btnClose", 21, 21, width - 23, 2 )
	GML_UI_LoadButtonImage( btnClose, "texture/ui/buttons.tga", 21, 21, 270, 0, TRUE )
	GML_UI_SetButtonModalResult( btnClose, BUTTON_CLOSE )
	return btnClose
end

--   
function L_BtnClose(formObject, width)
	local btnClose = GML_UI_CreateCompent( formObject, BUTTON_TYPE, "btnClose", 14, 14, width - 21, 4 )
	GML_UI_LoadButtonImage( btnClose, "texture/ui_morgan/buttons_14X14.png", 14, 14, 0, 0, TRUE )
	GML_UI_SetButtonModalResult( btnClose, BUTTON_CLOSE )
	return btnClose
end

------
--  
-- width -   
-- height -   
------
function L_DrawCloseNew(formObject, width, height)
	local btnClose = GML_UI_CreateCompent( formObject, BUTTON_TYPE, "btnClose", 21, 21, width - 23, 2 + height )
	GML_UI_LoadButtonImage( btnClose, "texture/ui/buttons.tga", 21, 21, 270, 0, TRUE )
	GML_UI_SetButtonModalResult( btnClose, BUTTON_CLOSE )
	return btnClose
end

------
--  
-- title -  
------
function L_DrawTitle(formObject, title)
	local labTitle = GML_UI_CreateCompent( formObject, LABELEX_TYPE, "labTitle", 400, 150, 10, 7 )
	GML_UI_SetCaption( labTitle, title)
	GML_UI_SetTextColor( labTitle, COLOR_WHITE )
	return labTitle
end

------
--   
------
function L_DrawName(formObject)
	local labName = GML_UI_CreateCompent( formObject, LABELEX_TYPE, "labName", 400, 150, 10, 7 )
	GML_UI_SetCaption( labName, "0")
	GML_UI_SetTextColor( labName, COLOR_WHITE )
	return labName
end

------
--   
------
function L_DrawButton(formObject, code, xpos, ypos, btnName)
	local buttons = {
		["exit"] = {0, 0},
		["ok"] = {0, 24},
		["yes"] = {0, 24},
		["cancel"] = {0, 24 * 2},
		["no"] = {0, 24 * 2},
		["create"] = {0, 24 * 3},
		["change"] = {0, 24 * 4},
		["delete"] = {0, 24 * 5},
		["enter"] = {0, 24 * 6},
		["quit"] = {0, 24 * 7},
		["clear"] = {0, 24 * 8},
		["keyboard"] = {0, 24 * 9},
		["leave"] = {0, 24 * 10},
		["forging"] = {0, 24 * 11},
		["fusion"] = {0, 24 * 12},
		["trade"] = {0, 24 * 13},
		["start"] = {0, 24 * 14},
		["stop"] = {0, 24 * 15},
		["back"] = {0, 24 * 16},
		["params"] = {0, 24 * 17},
		["hold"] = {0, 24 * 18},
		["add"] = {0, 24 * 19}, -- 
		["remove"] = {0, 24 * 20}, -- 
		["price"] = {0, 24 * 21}, -- 
		["motto"] = {0, 24 * 22}, -- 
		["accept"] = {0, 24 * 23}, -- 
		["refuse"] = {0, 24 * 24}, -- 
		["outgi"] = {0, 24 * 25}, -- 
		["join"] = {0, 24 * 26}, -- 
		["ready"] = {0, 24 * 27}, -- 
		["gold"] = {0, 24 * 28}, -- 
		["stallin"] = {0, 24 * 29}, --  
		["stallout"] = {0, 24 * 30}, --  
	}
	local btn = GML_UI_CreateCompent( formObject, BUTTON_TYPE, btnName, 67, 24, xpos, ypos )
	GML_UI_LoadButtonImage( btn, "texture/ui/buttons/index.tga", 67, 24, buttons[code][1], buttons[code][2], TRUE )
	if code == "yes" then
		GML_UI_SetButtonModalResult( btn, BUTTON_YES )
	elseif code == "no" or code == "exit" then
		GML_UI_SetButtonModalResult( btn, BUTTON_CLOSE )
	end
	return btn
end

function L_ItemBG(form_name, arr_area, castom_path, system_name)
	local castom_path = castom_path or "texture/ui_morgan/form/items/item_bg.png"
	local system_name = system_name or "UI_ItemBG_"..math.random(1,10000)
	local img = GML_UI_CreateCompent(form_name, IMAGE_TYPE, system_name, 40, 40, arr_area[1], arr_area[2])
	GML_UI_LoadImage(img, castom_path, NORMAL, 40, 40, 0, 0)
	
	return img
end

function L_ItemBG_36X36(form_name, arr_area, castom_path, system_name, arr_size)
	local castom_path = castom_path or "texture/ui_morgan/form/items/item_bg.png"
	local system_name = system_name or "UI_ItemBG_"..math.random(1,10000)
	local size = {32, 32}
	local arr_size = arr_size or size
	
	local img = GML_UI_CreateCompent(form_name, IMAGE_TYPE, system_name, (arr_size[1] + 4), (arr_size[2] + 4), arr_area[1], arr_area[2])
	GML_UI_LoadImage(img, castom_path, NORMAL, 36, 36, 0, 0)
end

function L_GenItemBG(form, arr_data)
	local system_name		= arr_data.system_name or "GenItemBG_"..math.random(1,10000)
	local arr_size			= arr_data.arr_size or {32, 32}
	local arr_area			= arr_data.arr_area or {0, 0}
	local first_bg			= arr_data.first_bg or 1
	local alfa_first_bg		= arr_data.alfa_first_bg or 255
	local alfa				= arr_data.alfa or 45
	
	if first_bg == 1 then
		local path_bg_first		= "texture/ui_morgan/form/items/bg/cmpt_item_bg_mini_border.png"
		if arr_data.bg_first then
			path_bg_first = "texture/ui_morgan/form/items/bg/"..arr_data.bg_first..".png"
		end
		
			
		local img = GML_UI_CreateCompent(form, IMAGE_TYPE, system_name, (arr_size[1] + 4), (arr_size[2] + 4), arr_area[1], arr_area[2])
		GML_UI_LoadImage(img, path_bg_first, NORMAL, 36, 36, 0, 0)
		
		GML_UI_SetImageAlpha(img, alfa_first_bg)
	end
	
	if arr_data.bg_second then
		local path_bg_second = "texture/ui_morgan/form/items/bg/"..arr_data.bg_second..".png"
		local img = GML_UI_CreateCompent(form, IMAGE_TYPE, system_name.."_"..math.random(1,10000), arr_size[1], arr_size[2], (arr_area[1] + 2), (arr_area[2] + 2))
		GML_UI_LoadImage(img, path_bg_second, NORMAL, 32, 32, 0, 0)
		GML_UI_SetImageAlpha(img, alfa)
	end
end

--   ,     
function L_SetItemBG(form, arr_data)
	local system_name		= arr_data.system_name or "SetItemBG_"..math.random(1,10000)
	local arr_size			= arr_data.arr_size or {32, 32}
	local arr_area			= arr_data.arr_area or {0, 0}
	
	local arr_bg_first		= arr_data.arr_bg_first or {}
	local arr_bg_second		= arr_data.arr_bg_second or {}
	
	arr_bg_first.path		= arr_bg_first.path or "cmpt_item_bg_mini_border"
	arr_bg_second.path		= arr_bg_second.path or ""
	
	arr_bg_first.alfa		= arr_bg_first.alfa or 100
	arr_bg_first.alfa		= math.ceil(255 * arr_bg_first.alfa / 100)
	arr_bg_first.path		= "texture/ui_morgan/form/items/bg/"..arr_bg_first.path..".png"
	
	local img = GML_UI_CreateCompent(form, IMAGE_TYPE, system_name, (arr_size[1] + 4), (arr_size[2] + 4), arr_area[1], arr_area[2])
	GML_UI_LoadImage(img, arr_bg_first.path, NORMAL, 36, 36, 0, 0)
	GML_UI_SetImageAlpha(img, arr_bg_first.alfa)
	
	if arr_bg_second.path ~= "" then
		arr_bg_second.alfa		= arr_bg_second.alfa or 100
		arr_bg_second.alfa		= math.ceil(255 * arr_bg_second.alfa / 100)
		
		arr_bg_second.path		= "texture/ui_morgan/form/items/bg/"..arr_bg_second.path..".png"
		
		local img = GML_UI_CreateCompent(form, IMAGE_TYPE, system_name.."_"..math.random(1,10000), arr_size[1], arr_size[2], (arr_area[1] + 2), (arr_area[2] + 2))
		GML_UI_LoadImage(img, arr_bg_second.path, NORMAL, 32, 32, 0, 0)
		GML_UI_SetImageAlpha(img, arr_bg_second.alfa)
	end
end

function L_GenItemBG2(form, arr_data)
	local system_name		= arr_data.system_name or "GenItemBG_"..math.random(1,10000)
	local arr_size			= arr_data.arr_size or {32, 32}
	local arr_area			= arr_data.arr_area or {0, 0}
	local alfa				= arr_data.alfa or 45
	
	if arr_data.bg_second then
		local path_bg_second = "texture/ui_morgan/form/items/bg/"..arr_data.bg_second..".png"
		local img = GML_UI_CreateCompent(form, IMAGE_TYPE, system_name.."_"..math.random(1,10000), arr_size[1], arr_size[2], (arr_area[1]), (arr_area[2]))
		GML_UI_LoadImage(img, path_bg_second, NORMAL, 32, 32, 0, 0)
		GML_UI_SetImageAlpha(img, alfa)
		if (arr_data.hint) then
			GML_UI_SetHint(img, arr_data.hint)
		end
	end
end


--   ,     
function L_GenItem(form, a_data)
	local sys_name			= a_data.sys_name or "L_GenItem_"..math.random(1,10000)
	local a_size			= a_data.a_size or {36, 36}
	local a_area			= a_data.a_area or {0, 0}
	
	local a_bg_1			= a_data.a_bg_1 or {}
	local a_bg_2			= a_data.a_bg_2 or nil
	

	a_bg_1.path		= a_bg_1.path or "cmpt_item_bg_mini_border"
	a_bg_1.alfa		= a_bg_1.alfa or 100
	a_bg_1.alfa		= math.ceil(255 * a_bg_1.alfa / 100)
	a_bg_1.path		= "texture/ui_morgan/form/items/bg/"..a_bg_1.path..".png"
	
	local img = GML_UI_CreateCompent(form, IMAGE_TYPE, sys_name.."_bg_1", a_size[1], a_size[2], a_area[1], a_area[2])
	GML_UI_LoadImage(img, a_bg_1.path, NORMAL, 36, 36, 0, 0)
	GML_UI_SetImageAlpha(img, a_bg_1.alfa)
	
	if a_bg_2 then
		a_bg_2.path		= a_bg_2.path or ""
		a_bg_2.alfa		= a_bg_2.alfa or 100
		a_bg_2.alfa		= math.ceil(255 * a_bg_2.alfa / 100)
		a_bg_2.path		= "texture/ui_morgan/form/items/bg/"..a_bg_2.path..".png"
		
		local img = GML_UI_CreateCompent(form, IMAGE_TYPE, sys_name.."_bg_2", a_size[1] - 4, a_size[2] - 4, a_area[1] + 2, a_area[2] + 2)
		GML_UI_LoadImage(img, a_bg_2.path, NORMAL, 32, 32, 0, 0)
		GML_UI_SetImageAlpha(img, a_bg_2.alfa)
	end
	
	local item = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, sys_name, a_size[1] - 4, a_size[2] - 4, a_area[1] + 2, a_area[2] + 2)
	if a_data.hint then
		GML_UI_SetHint(item, a_data.hint)
	end
	
	return item
end


--[[
	-- L_Text(form, arr_data)
	----      
	
	--  
	local text = L_Text(form, {		--   form (  ,     )
		system_name	= "labAllCount",	--   .       Game.exe ( ).
		arr_size	= {98, 18},			--  . , .
		arr_area	= {11, 32},			--      . X,Y.
		hint		= "",				--      (!  ,  ).
		
		--    .    ,   /.
		arr_text	= {
			text			= "",				--  (""*, !).
			font			= DEFAULT_FONT,		--   (DEFAULT_FONT*)
			color			= COLOR_WHITE,		--   (COLOR_WHITE*)
			shadow			= FALSE,			--    (FALSE, TRUE*)
			shadow_color	= COLOR_WHITE,		--   (COLOR_WHITE*)
			center			= 1,				--     (0*, 1)
		}
	})
]]

function L_Text(form, arr_data)
	local system_name		= arr_data.system_name or "UI_Text_"..math.random(1, 10000)
	local label_type		= arr_data.label_type or LABELEX_TYPE
	
	-- 
	local arr_size			= arr_data.arr_size or {0, 0}
	local size_x, size_y	= arr_size[1], arr_size[2]
	
	--   
	local arr_area			= arr_data.arr_area or {0, 0}
	local area_x, area_y	= arr_area[1], arr_area[2]
	
	local hint				= arr_data.hint or 0
	
	-- 
	local arr_text			= arr_data.arr_text or {}
	local text				= arr_text.text or ""
	local text_font			= arr_text.font or DEFAULT_FONT
	local text_color		= arr_text.color or COLOR_WHITE
	local text_shadow		= arr_text.shadow or TRUE
	local text_shadow_color	= arr_text.shadow_color or COLOR_BLACK
	local text_center		= arr_text.center or 0
	local text_right		= arr_text.right or 0
	local text_money		= arr_text.money or 0
	
	local compent = GML_UI_CreateCompent(form, label_type, system_name, size_x, size_y, area_x, area_y)
	GML_UI_SetCaption(compent, text)
	GML_UI_SetTextColor(compent, text_color)
	GML_UI_SetIsCenter(compent, text_center)
	GML_UI_SetIsRightAligned(compent, text_right)
	GML_UI_SetTextIsMoney(compent, text_money)
	GML_UI_SetLabelExFont(compent, text_font, text_shadow, text_shadow_color)
	
	if hint ~= 0 then
		GML_UI_SetHint(compent, hint)
	end
	
	return compent
end


--	L_TextArea(form, {
--		cpt_arr_area	= {20, 102 + 22},
--		--cpt_hint		= "",
--		--cpt_label_type	= LABELEX_TYPE,
--		
--		arr_text			=	{
--			-- : "  "
--			"  ",
--			
--			-- : " 65   185 "
--			" 65   185 ",
--		},
--		
--		text_width	= 237,
--		--text_hight			= 12,
--		text_font			= DEFAULT_FONT,
--		text_color			= COLOR_GRAY3,
--		text_shadow			= FALSE,
--		--text_shadow_color	= COLOR_BLACK,
--		text_center			= 1,
--		--text_right			= 0,
--	})

function L_TextArea(form, arr_data)
	local cpt_sys_name		= arr_data.cpt_sys_name or "UI_TextArea_"..math.random(1, 10000)
	local cpt_arr_area		= arr_data.cpt_arr_area or {0, 0}
	local cpt_hint			= arr_data.cpt_hint or ""
	local cpt_label_type	= arr_data.cpt_label_type or LABELEX_TYPE
	
	local arr_text			= arr_data.arr_text or {}
	local text_width		= arr_data.text_width or 0
	local text_hight		= arr_data.text_hight or 12
	local text_font			= arr_data.text_font or DEFAULT_FONT
	local text_color		= arr_data.text_color or COLOR_WHITE
	local text_shadow		= arr_data.text_shadow or FALSE
	local text_shadow_color	= arr_data.text_shadow_color or COLOR_BLACK
	local text_center		= arr_data.text_center or 0
	local text_right		= arr_data.text_right or 0
	
	for i = 1, #arr_text do
		local text				= arr_text[i]
		
		local size_x			= text_width
		local size_y			= text_hight
		
		local area_x			= cpt_arr_area[1]
		local area_y			= cpt_arr_area[2] + (text_hight * (i - 1))
		
		local compent = GML_UI_CreateCompent(form, cpt_label_type, cpt_sys_name.."_"..i, size_x, size_y, area_x, area_y)
		GML_UI_SetCaption(compent, text)
		GML_UI_SetTextColor(compent, text_color)
		GML_UI_SetIsCenter(compent, text_center)
		GML_UI_SetIsRightAligned(compent, text_right)
		--GML_UI_SetTextIsMoney(compent, text_money)
		GML_UI_SetLabelExFont(compent, text_font, text_shadow, text_shadow_color)
		
		if cpt_hint ~= "" then
			GML_UI_SetHint(compent, cpt_hint)
		end
	end
end

--[[
	-- L_SetFormItems(form, arr_data)
	----          
	
	--  
	local items = L_SetFormItems(form, {		--   form (  ,     )
		system_name	= "grdStockBag",			--   .       Game.exe ( ).
		arr_area	= {11, 53},					--      . X,Y.
		arr_items	= {
			col = 10,							--  ,
			row = 8								--  
		},
	})
]]

function L_SetFormItems(form, arr_data)
	local system_name	= arr_data.system_name or "UI_SetFormItems_"..math.random(1, 10000)
	local area_x		= arr_data.arr_area[1] or 0
	local area_y		= arr_data.arr_area[2] or 0
	
	local size_type		= arr_data.size_type or 1
	
	local arr_grid_space	= arr_data.arr_grid_space or {7, 7}
	
	local count_col			= arr_data.arr_items.col or 0
	local count_row			= arr_data.arr_items.row or 0
	local count_row_scroll	= arr_data.arr_items.row_scroll or count_row
	
	--  :
	local count_cells = count_col * count_row
	
	local size_w = 38 * count_col + (count_col + 1)
	local size_h = 38 * count_row + (count_row + 1)
	
	if size_type == 2 then
		size_w = 28 * count_col + (count_col + 1)
		size_h = 28 * count_row + (count_row + 1)
		arr_grid_space	= arr_data.arr_grid_space or {5, 5}
	end
	
	if (arr_data.castom_bg_icon == nil) then
		if size_type == 1 then
			local size_x = math.ceil(count_col / 2 * 39)
			local size_y = math.ceil(count_row / 2 * 39)
			local size_x2 = math.floor(count_col / 2 * 39)
			local size_y2 = math.floor(count_row / 2 * 39)
			
			local arr_blocks = {
				[1]	= {size = {size_x + 1, size_y + 1},		area = {0, 0},						area_img = {0, 0}},
				[2]	= {size = {size_x2, size_y + 1},		area = {size_x + 1, 0},				area_img = {391 - size_x2, 0}},
				[3]	= {size = {size_x + 1, size_y2},		area = {0, size_y + 1},				area_img = {0, 391 - size_y2}},
				[4]	= {size = {size_x2, size_y2},			area = {size_x + 1, size_y + 1},	area_img = {391 - size_x2, 391 - size_y2}},
			}
			
			for i = 1, #arr_blocks do
				local bg_items = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_item"..math.random(1, 10000), arr_blocks[i].size[1], arr_blocks[i].size[2], area_x + arr_blocks[i].area[1], area_y + arr_blocks[i].area[2])
				GML_UI_LoadImage(bg_items, "texture/ui_morgan/form/items_3.png", NORMAL, arr_blocks[i].size[1], arr_blocks[i].size[2], arr_blocks[i].area_img[1], arr_blocks[i].area_img[2])
			end
		elseif size_type == 2 then
			local size_x = math.ceil(count_col / 2 * 29)
			local size_y = math.ceil(count_row / 2 * 29)
			local size_x2 = math.floor(count_col / 2 * 29)
			local size_y2 = math.floor(count_row / 2 * 29)
			
			local arr_blocks = {
				[1]	= {size = {size_x + 1, size_y + 1},		area = {0, 0},						area_img = {0, 0}},
				[2]	= {size = {size_x2, size_y + 1},		area = {size_x + 1, 0},				area_img = {291 - size_x2, 0}},
				[3]	= {size = {size_x + 1, size_y2},		area = {0, size_y + 1},				area_img = {0, 291 - size_y2}},
				[4]	= {size = {size_x2, size_y2},			area = {size_x + 1, size_y + 1},	area_img = {291 - size_x2, 291 - size_y2}},
			}
			
			for i = 1, #arr_blocks do
				local bg_items = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_item"..math.random(1, 10000), arr_blocks[i].size[1], arr_blocks[i].size[2], area_x + arr_blocks[i].area[1], area_y + arr_blocks[i].area[2])
				GML_UI_LoadImage(bg_items, "texture/ui_morgan/form/items_4.png", NORMAL, arr_blocks[i].size[1], arr_blocks[i].size[2], arr_blocks[i].area_img[1], arr_blocks[i].area_img[2])
			end
		end
	else
		for i = 1, count_row do
			for i2 = 1, count_col do
				local bg_items = GML_UI_CreateCompent(form, IMAGE_TYPE, "bg_item"..math.random(1, 10000), 40, 40, area_x + (36 * (i2 - 1)), area_y + (36 * (i - 1)))
				GML_UI_LoadImage(bg_items, arr_data.castom_bg_icon, NORMAL, 40, 40, 0, 0)
			end
		end
	end
	
	local is_step_x = 0
	if count_row_scroll ~= count_row then
		is_step_x = -4
	end
	
	local compent = nil
	if size_type == 1 then
		compent = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, system_name, count_col * 40 - count_col + is_step_x, count_row * 40 - count_row, area_x + 4, area_y + 4)
	elseif size_type == 2 then
		compent = GML_UI_CreateCompent(form, GOODS_GRID_TYPE, system_name, count_col * 40 - count_col + is_step_x, count_row * 38 - count_row, area_x + 3, area_y + 3)
	end
	GML_UI_SetGridSpace(compent, arr_grid_space[1], arr_grid_space[2])
	GML_UI_SetGridContent(compent, count_row_scroll, count_col)
	if size_type == 1 then
		GML_UI_SetGridUnitSize(compent, 32, 32)
	elseif size_type == 2 then
		GML_UI_SetGridUnitSize(compent, 24, 24)
	end
	GML_UI_SetMargin(compent, 0, 0, 0, 0)
	
	if count_row_scroll ~= count_row then
		L_DrawScroll(compent, 150, 3)
	end

	
	return compent
end


--    
function L_CreateBG(arr_data)
	local form_name		= arr_data.form_name									--  
	local area_start_x	= arr_data.arr_pos_area[1]								--   
	local area_start_y	= arr_data.arr_pos_area[2]								--   
	local area_width	= arr_data.arr_size[1]									--  
	local area_height	= arr_data.arr_size[2]									--  
	local castom_path	= arr_data.castom_path or "texture/ui_morgan/form/bg_2.png"	--   
	local system_name	= arr_data.system_name or "UI_CreateBG_"..math.random(1, 10000)
	local alpha			= arr_data.alpha or 100
	alpha				= math.ceil(255 * alpha / 100)
	
	
	local part_size_width	= math.ceil(area_width / 2)
	local part_size_height	= math.ceil(area_height / 2)
	
	local positions = {
		{0, 0},
		{800 - part_size_width, 0},
		{0, 600 - part_size_height},
		{800 - part_size_width, 600 - part_size_height}
	}
	
	local arr_cpt = {}
	local p = 0
	for i = 1, 2 do
		for j = 1, 2 do
			p = p + 1
			local part_render = GML_UI_CreateCompent(form_name, IMAGE_TYPE, system_name.."_"..p, part_size_width, part_size_height, area_start_x + (part_size_width * (i - 1)), area_start_y + (part_size_height * (j - 1)))
			GML_UI_LoadImage(part_render, castom_path, NORMAL, part_size_width, part_size_height, 
				positions[(j - 1) * 2 + i][1], 
				positions[(j - 1) * 2 + i][2]
			)
			GML_UI_SetImageAlpha(part_render, alpha)
			
			table.insert(arr_cpt, part_render)
		end
	end
	
	return arr_cpt
end


-- 
--[[
	-- L_SetForm(arr_data)
	----      
	
	--  
	local form = L_SetForm({
		system_name	= "seasonForm",											--   .       Game.exe ( ).
		arr_size	= {414, 412},											--      . X,Y.
		text_title	= " "	--      (!).
	})
]]

function L_SetForm(arr_data)
	local system_name	= arr_data.system_name or "UI_SetForm_"..math.random(1, 10000)
	local arr_size		= arr_data.arr_size or {}
	local text_title	= arr_data.text_title or ""
	
	local width		= arr_size[1]
	local height	= arr_size[2]
	
	local arr_area		= arr_data.arr_area or {0, 0}
	local area_pos_x	= arr_area[1]
	local area_pos_y	= arr_area[2]
	
	local form_name = GML_UI_CreateForm(system_name, FALSE, width, height, area_pos_x, area_pos_y, TRUE, FALSE)
	GML_UI_ShowForm(form_name, FALSE)
	GML_UI_AddFormToTemplete(form_name, FORM_MAIN)
	GML_UI_SetIsDrag(form_name, TRUE)
	
	----
	--  
	----
	local area_start_x	= 0								--   
	local area_start_y	= 0								--   
	local area_width	= width							--  
	local area_height	= height						--  
	
	local part_size_width	= math.ceil(area_width / 2)
	local part_size_height	= area_height - 22
	
	local positions = {
		{0, 600 - part_size_height},
		{800 - part_size_width, 600 - part_size_height}
	}
	
	
	--   
	for i = 1, 2 do
		local correction = 0
		if i == 2 and (area_width % 2 == 1) then
			correction = 1
		end
		
		local part_render = GML_UI_CreateCompent(form_name, IMAGE_TYPE, system_name.."_bg_"..i, part_size_width - correction, part_size_height, 0 + (part_size_width * (i - 1)), 22)
		GML_UI_LoadImage(part_render, "texture/ui_morgan/form/bg_1.png", NORMAL, part_size_width - correction, part_size_height, 
			positions[i][1] + correction, 
			positions[i][2]
		)
		--GML_UI_SetImageAlpha(part_render, 130)
	end
	
	----
	--  
	----
	
	--   
	local form_header_bg = GML_UI_CreateCompent(form_name, IMAGE_TYPE, system_name.."_header_bg", width, 24, 0, 0)
	GML_UI_LoadImage(form_header_bg, "texture/ui_morgan/form/header_1.png", NORMAL, width, 24, 800 - width, 0)
	--GML_UI_SetImageAlpha(form_header_bg, 130)
	
	--  
	local form_lable = GML_UI_CreateCompent(form_name, LABELEX_TYPE, system_name.."_label", width - 22 - 10 - 10, 12, 10, 5)
	GML_UI_SetCaption(form_lable, text_title)
	GML_UI_SetTextColor(form_lable, COLOR_GRAY2)
	GML_UI_SetLabelExFont(form_lable, DEFAULT_FONT, FALSE, COLOR_BLACK)
	
	
	
	if (system_name == "frmNPCMission") then
		--  
		local btn_close = GML_UI_CreateCompent(form_name, BUTTON_TYPE, "btnClose", 14, 14, width - 22, 4)
		GML_UI_LoadButtonImage(btn_close, "texture/ui_morgan/buttons_14X14.png", 14, 14, 0, 0, TRUE )
		GML_UI_SetButtonModalResult(btn_close, BUTTON_CLOSE )
		--GML_UI_SetImageAlpha(btn_close, 130)
	else
		--  
		local btn_close = GML_UI_CreateCompent(form_name, BUTTON_TYPE, system_name.."_btn_close", 14, 14, width - 22, 4)
		GML_UI_LoadButtonImage(btn_close, "texture/ui_morgan/buttons_14X14.png", 14, 14, 0, 0, TRUE )
		GML_UI_SetButtonModalResult(btn_close, BUTTON_CLOSE )
		--GML_UI_SetImageAlpha(btn_close, 130)
	end

	
	return form_name
end

------
--   
------

function L_LableText(form, arr_data)
	
	local width				= arr_data.width or 16
	local height			= arr_data.height or 16
	local arr_area			= arr_data.arr_area or {0, 0}
	
	local area_x		= arr_area[1]
	local area_y		= arr_area[2]
	
	local text				= arr_data.text or ""
	local text_system_name	= arr_data.text_system_name or "UI_LableText_text_"..math.random(1,10000)
	local text_center		= arr_data.text_center or 0
	local text_color		= arr_data.text_color or COLOR_GRAY4
	local text_icon			= arr_data.text_icon or nil
	local text_shadow		= arr_data.text_shadow or nil
	
	local title				= arr_data.title or nil
	local title_system_name	= arr_data.title_system_name or "UI_LableText_title_"..math.random(1,10000)
	local title_center		= arr_data.title_center or nil
	local title_color		= arr_data.title_color or COLOR_WHITE
	local title_shadow		= arr_data.title_shadow or nil
	
	local hint_text			= arr_data.hint_text or nil
	
	if title then
		local cpt_title = GML_UI_CreateCompent(form, LABELEX_TYPE, title_system_name, width, 12, area_x, area_y)
		GML_UI_SetCaption(cpt_title, title)
		GML_UI_SetTextColor(cpt_title, title_color)
		if title_shadow then 
			GML_UI_SetLabelExFont(cpt_title, DEFAULT_FONT, title_shadow, COLOR_WHITE)
		end
		
		if title_center then
			GML_UI_SetIsCenter(cpt_title, title_center)
		end
		
		if hint_text then
			GML_UI_SetHint(cpt_title, hint_text)
		end
		area_y = area_y + 13
	end
	
	local cpt_bg_left = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_bg_left"..math.random(1, 10000), 6, height, area_x, area_y)
	GML_UI_LoadImage(cpt_bg_left, "texture/ui_morgan/buttons.png", NORMAL, 6, 18, 0, 73)
	
	local cpt_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_bg_"..math.random(1, 10000), width - 12, height, area_x + 6, area_y)
	GML_UI_LoadImage(cpt_bg, "texture/ui_morgan/buttons.png", NORMAL, 4, 18, 6, 73)
	
	local cpt_bg_right = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_bg_right"..math.random(1, 10000), 6, height, area_x + width - 6, area_y)
	GML_UI_LoadImage(cpt_bg_right, "texture/ui_morgan/buttons.png", NORMAL, 6, 18, 10, 73)
	
	if text then
		local cpt_text = GML_UI_CreateCompent(form, LABELEX_TYPE, text_system_name, width - 6, 12, area_x + 3, area_y + 3)
		GML_UI_SetCaption(cpt_text, text)
		GML_UI_SetTextColor(cpt_text, text_color)
		if text_shadow then 
			GML_UI_SetLabelExFont(cpt_text, DEFAULT_FONT, text_shadow, COLOR_WHITE)
		end
		
		if text_center then
			GML_UI_SetIsCenter(cpt_text, text_center)
		end
		
		if hint_text then
			GML_UI_SetHint(cpt_text, hint_text)
		end
	end
	

end


------
--  
------

function L_hr(form, arr_data)
	local width		= arr_data.width or 0
	local height	= arr_data.height or 1
	local arr_area	= arr_data.arr_area or {0, 0}
	local alfa		= arr_data.alfa or 100
	
	alfa		= math.ceil(255 * alfa / 100)
	
	
	local cpt_hr = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_cpt_hr_"..math.random(1, 10000), width, height, arr_area[1], arr_area[2])
	GML_UI_LoadImage(cpt_hr, "texture/ui_morgan/form/text_bg.png", NORMAL, width, 1, 5, 0)
	GML_UI_SetImageAlpha(cpt_hr, alfa)
end


----
-- 
----

function L_GenPag(form, arr_data)
	local system_name	= arr_data.system_name or nil
	local arr_area		= arr_data.arr_area or {0, 0}
	local width			= arr_data.width or 50
	local width_text_bg = arr_data.width_text_bg or 38
	
	--    
	local center_x		= math.ceil(arr_area[1] + (width / 2))
	
	if system_name then
		system_name = system_name.."_"
	end
	
	--  " "
	local BtnBackPage = GML_UI_CreateCompent(form, BUTTON_TYPE, system_name.."btn_prev_page", 16, 15, center_x - math.ceil(width_text_bg / 2) - 5 - 12, arr_area[2] + 2)
	GML_UI_LoadButtonImage(BtnBackPage, "texture/ui_morgan/buttons.png", 16, 16, 0, 109, 1)
	
	--  
	L_RowText(
		form, 
		system_name.."txt_curr_page", 
		1,				-- type (gold)
		"",				-- hint 
		{width_text_bg, 19},		-- : width, height
		{center_x - math.ceil(width_text_bg / 2), arr_area[2]},	--  : xpos, ypos
		1,
		"12/19"
	)
	
	--  " "
	local BtnNextPage = GML_UI_CreateCompent(form, BUTTON_TYPE, system_name.."btn_next_page", 16, 15, center_x + math.ceil(width_text_bg / 2) + 1, arr_area[2] + 2)
	GML_UI_LoadButtonImage(BtnNextPage, "texture/ui_morgan/buttons.png", 16, 16, 0, 125, 1)
end

------
--    (  )
------
function L_RowText(name_cpt, name_cpt_2, type_id, text_hint, arr_size, arr_pos, is_center, text)
	local is_center	= is_center or 0
	local width		= arr_size[1]
	local height	= arr_size[2]
	local text		= text or ""
	local xpos		= arr_pos[1]
	local ypos		= arr_pos[2]
	local type_id	= type_id or 0

	local cpt_bg_left = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_bg_left"..math.random(1, 10000), 6, height, xpos, ypos)
	GML_UI_LoadImage(cpt_bg_left, "texture/ui_morgan/buttons.png", NORMAL, 6, 18, 0, 73)
	
	local cpt_bg = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_bg_"..math.random(1, 10000), width - 12, height, xpos + 6, ypos)
	GML_UI_LoadImage(cpt_bg, "texture/ui_morgan/buttons.png", NORMAL, 4, 18, 6, 73)
	
	local cpt_bg_right = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_bg_right"..math.random(1, 10000), 6, height, xpos + width - 6, ypos)
	GML_UI_LoadImage(cpt_bg_right, "texture/ui_morgan/buttons.png", NORMAL, 6, 18, 10, 73)
	
	local cpt
	if (type_id == 3) then
		cpt = GML_UI_CreateCompent(name_cpt, EDIT_TYPE, name_cpt_2, width - 12, height - 10, xpos + 6, ypos + 4)
		GML_UI_SetTextColor( cpt, COLOR_WHITE )
		GML_UI_SetEditMaxNum( cpt, 12 )
		GML_UI_SetEditMaxNumVisible( cpt, 12 )
		GML_UI_SetEditCursorColor( cpt, COLOR_WHITE )
		return
	elseif (type_id == 2) then
		local cpt_icon = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_icon"..math.random(1, 10000), 12, 12, xpos + 3, ypos + 3)
		GML_UI_LoadImage(cpt_icon, "texture/ui_morgan/buttons.png", NORMAL, 12, 12, 0, 61)
		
		cpt = GML_UI_CreateCompent(name_cpt, LABELEX_TYPE, name_cpt_2, width - 12 - 12, height - 10, xpos + 15 + 2, ypos + 5)
	elseif (type_id == 4) then --  
		local cpt_icon = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_icon"..math.random(1, 10000), 12, 12, xpos + 3, ypos + 3)
		GML_UI_LoadImage(cpt_icon, "texture/ui_morgan/buttons.png", NORMAL, 12, 12, 12, 61)
		cpt = GML_UI_CreateCompent(name_cpt, LABELEX_TYPE, name_cpt_2, width - 12 - 12, height - 10, xpos + 15 + 0, ypos + 5)
		GML_UI_SetTextIsMoney(cpt, 1)
	else
		if (is_center == 1) then
			cpt = GML_UI_CreateCompent(name_cpt, LABELEX_TYPE, name_cpt_2, width, height - 10, xpos + 0, ypos + 5)
		else
			cpt = GML_UI_CreateCompent(name_cpt, LABELEX_TYPE, name_cpt_2, width - 10, height - 10, xpos + 6, ypos + 5)
		end

	end
	
	GML_UI_SetCaption(cpt, text)
	if text_hint and text_hint ~= "" then
		GML_UI_SetHint(cpt, text_hint)
	end
	
	GML_UI_SetTextColor(cpt, COLOR_WHITE)
	GML_UI_SetLabelExFont(cpt, ARIAL_FONT)
	
	if (is_center == 1) then
		GML_UI_SetIsCenter(cpt, 1)
	elseif (is_center == 2) then
		GML_UI_SetIsRightAligned(cpt, 1)
	end
	return cpt
end

----
--    (  )
----
function L_Input(form, a)
	local cpt__name				= a.name
	local cpt__width			= a.a_size[1]
	local cpt__height			= a.a_size[2]
	local cpt__pos_x			= a.a_pos[1]
	local cpt__pos_y			= a.a_pos[2]
	local cpt__type_id			= a.type_id
	local cpt__count_simbol		= a.max_count_simbol
	local cpt__text_hint		= a.text_hint
	local cpt__placeholder		= a.placeholder
	local cpt__color_cursor		= color(a.cursor_color or "#FFFFFFFF")
		
	local cpt_bg_left = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_bg_left"..math.random(1, 10000), 6, cpt__height, cpt__pos_x, cpt__pos_y)
	GML_UI_LoadImage(cpt_bg_left, "texture/ui_morgan/buttons.png", NORMAL, 6, 18, 0, 73)
	
	local cpt_bg = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_bg_"..math.random(1, 10000), cpt__width - 12, cpt__height, cpt__pos_x + 6, cpt__pos_y)
	GML_UI_LoadImage(cpt_bg, "texture/ui_morgan/buttons.png", NORMAL, 4, 18, 6, 73)
	
	local cpt_bg_right = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_bg_right"..math.random(1, 10000), 6, cpt__height, cpt__pos_x + cpt__width - 6, cpt__pos_y)
	GML_UI_LoadImage(cpt_bg_right, "texture/ui_morgan/buttons.png", NORMAL, 6, 18, 10, 73)
	
	local new_cpt
	if (cpt__type_id == 6) then
		-- 
		local cpt_icon = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_icon"..math.random(1, 10000), 12, 12, cpt__pos_x + 3, cpt__pos_y + 3)
		GML_UI_LoadImage(cpt_icon, "texture/ui_morgan/buttons.png", NORMAL, 12, 12, 12, 61)
		
		new_cpt = GML_UI_CreateCompent(form, EDIT_TYPE, cpt__name, cpt__width - 12 - 12, cpt__height - 6, cpt__pos_x + 15 + 3, cpt__pos_y + 4)	
	elseif (cpt__type_id == 2) then
		-- 
		local cpt_icon = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_icon"..math.random(1, 10000), 12, 12, cpt__pos_x + 3, cpt__pos_y + 3)
		GML_UI_LoadImage(cpt_icon, "texture/ui_morgan/buttons.png", NORMAL, 12, 12, 0, 61)
		
		new_cpt = GML_UI_CreateCompent(form, EDIT_TYPE, cpt__name, cpt__width - 12 - 12, cpt__height - 6, cpt__pos_x + 15 + 3, cpt__pos_y + 4)	
	elseif (cpt__type_id == 3) then
		-- -
		local cpt_icon = GML_UI_CreateCompent(form, IMAGE_TYPE, "cpt_icon"..math.random(1, 10000), 13, 12, cpt__pos_x + 3, cpt__pos_y + 4)
		GML_UI_LoadImage(cpt_icon, "texture/ui_morgan/buttons.png", NORMAL, 13, 12, 33, 61)
		
		new_cpt = GML_UI_CreateCompent(form, EDIT_TYPE, cpt__name, cpt__width - 12 - 12, cpt__height - 6, cpt__pos_x + 15 + 4, cpt__pos_y + 4)
	elseif (cpt__type_id == 4) then
		--   x
		L_Text(form, {
			--system_name	= "f_chabuy_lot_"..id_cell,
			arr_size	= {10, 17},
			arr_area	= {cpt__pos_x + 6, cpt__pos_y + 3},
			hint		= "",
			
			arr_text	= {
				text			= "x:",
				font			= FONT14,
				color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				--center		= 1,
				--right	= 1,
			}
		})
		new_cpt = GML_UI_CreateCompent(form, EDIT_TYPE, cpt__name, cpt__width - 12, cpt__height - 6, cpt__pos_x + 6 + 10, cpt__pos_y + 4)
	elseif (cpt__type_id == 5) then
		--   y
		L_Text(form, {
			--system_name	= "f_chabuy_lot_"..id_cell,
			arr_size	= {10, 17},
			arr_area	= {cpt__pos_x + 6, cpt__pos_y + 3},
			hint		= "",
			
			arr_text	= {
				text			= "y:",
				font			= FONT14,
				color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				--center		= 1,
				--right	= 1,
			}
		})
		new_cpt = GML_UI_CreateCompent(form, EDIT_TYPE, cpt__name, cpt__width - 12, cpt__height - 6, cpt__pos_x + 6 + 10, cpt__pos_y + 4)
		
	else
		new_cpt = GML_UI_CreateCompent(form, EDIT_TYPE, cpt__name, cpt__width - 12, cpt__height - 6, cpt__pos_x + 3, cpt__pos_y + 4)
		if cpt__placeholder then
			GML_UI_SetPlaceholder(new_cpt, cpt__placeholder)
		end
		
	end
	
	GML_UI_SetTextColor( new_cpt, COLOR_WHITE )
	GML_UI_SetCaption(new_cpt, "")
	if cpt__text_hint and cpt__text_hint ~= "" then
		GML_UI_SetHint(new_cpt, cpt__text_hint)
	end
	
	GML_UI_SetEditMaxNum(new_cpt, cpt__count_simbol)
	GML_UI_SetEditMaxNumVisible(new_cpt, cpt__count_simbol)
	GML_UI_SetEditCursorColor(new_cpt, cpt__color_cursor)	
	return new_cpt
end

function L_OldRowInput(name_cpt, name_cpt_2, type_id, count_simbol, text_hint, arr_size, arr_pos, placeholder, color_cursor)
	local width			= arr_size[1]
	local height		= arr_size[2]
	local xpos			= arr_pos[1]
	local ypos			= arr_pos[2]
	local placeholder = placeholder or nil
	local color_cursor = color_cursor or "#FFFFFFFF"
	--color_cursor = color(color_cursor)
		
	local cpt_bg_left = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_bg_left"..math.random(1, 10000), 6, height, xpos, ypos)
	GML_UI_LoadImage(cpt_bg_left, "texture/ui_morgan/buttons.png", NORMAL, 6, 18, 0, 73)
	
	local cpt_bg = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_bg_"..math.random(1, 10000), width - 12, height, xpos + 6, ypos)
	GML_UI_LoadImage(cpt_bg, "texture/ui_morgan/buttons.png", NORMAL, 4, 18, 6, 73)
	
	local cpt_bg_right = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_bg_right"..math.random(1, 10000), 6, height, xpos + width - 6, ypos)
	GML_UI_LoadImage(cpt_bg_right, "texture/ui_morgan/buttons.png", NORMAL, 6, 18, 10, 73)
	
	local cpt
	if (type_id == 6) then
		-- 
		local cpt_icon = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_icon"..math.random(1, 10000), 12, 12, xpos + 3, ypos + 3)
		GML_UI_LoadImage(cpt_icon, "texture/ui_morgan/buttons.png", NORMAL, 12, 12, 12, 61)
		
		cpt = GML_UI_CreateCompent(name_cpt, EDIT_TYPE, name_cpt_2, width - 12 - 12, height - 6, xpos + 15 + 3, ypos + 4)	
	elseif (type_id == 2) then
		-- 
		local cpt_icon = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_icon"..math.random(1, 10000), 12, 12, xpos + 3, ypos + 3)
		GML_UI_LoadImage(cpt_icon, "texture/ui_morgan/buttons.png", NORMAL, 12, 12, 0, 61)
		
		cpt = GML_UI_CreateCompent(name_cpt, EDIT_TYPE, name_cpt_2, width - 12 - 12, height - 6, xpos + 15 + 3, ypos + 4)	
	elseif (type_id == 3) then
		-- -
		local cpt_icon = GML_UI_CreateCompent(name_cpt, IMAGE_TYPE, "cpt_icon"..math.random(1, 10000), 13, 12, xpos + 3, ypos + 4)
		GML_UI_LoadImage(cpt_icon, "texture/ui_morgan/buttons.png", NORMAL, 13, 12, 33, 61)
		
		cpt = GML_UI_CreateCompent(name_cpt, EDIT_TYPE, name_cpt_2, width - 12 - 12, height - 6, xpos + 15 + 4, ypos + 4)
	elseif (type_id == 4) then
		--   x
		L_Text(name_cpt, {
			--system_name	= "f_chabuy_lot_"..id_cell,
			arr_size	= {10, 17},
			arr_area	= {xpos + 6, ypos + 3},
			hint		= "",
			
			arr_text	= {
				text			= "x:",
				font			= FONT14,
				color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				--center		= 1,
				--right	= 1,
			}
		})
		cpt = GML_UI_CreateCompent(name_cpt, EDIT_TYPE, name_cpt_2, width - 12, height - 6, xpos + 6 + 10, ypos + 4)
	elseif (type_id == 5) then
		--   y
		L_Text(name_cpt, {
			--system_name	= "f_chabuy_lot_"..id_cell,
			arr_size	= {10, 17},
			arr_area	= {xpos + 6, ypos + 3},
			hint		= "",
			
			arr_text	= {
				text			= "y:",
				font			= FONT14,
				color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				--center		= 1,
				--right	= 1,
			}
		})
		cpt = GML_UI_CreateCompent(name_cpt, EDIT_TYPE, name_cpt_2, width - 12, height - 6, xpos + 6 + 10, ypos + 4)
		
	else
		cpt = GML_UI_CreateCompent(name_cpt, EDIT_TYPE, name_cpt_2, width - 12, height - 6, xpos + 3, ypos + 4)
		if placeholder then
			GML_UI_SetPlaceholder(cpt, placeholder)
		end
		
	end
	
	GML_UI_SetTextColor( cpt, COLOR_WHITE )
	GML_UI_SetCaption(cpt, "")
	if text_hint and text_hint ~= "" then
		GML_UI_SetHint(cpt, text_hint)
	end
	
	GML_UI_SetEditMaxNum(cpt, count_simbol)
	GML_UI_SetEditMaxNumVisible(cpt, count_simbol)
	GML_UI_SetEditCursorColor(cpt, COLOR_WHITE)	
	return cpt
end

----
-- 
----

function L_pages(form, arr_data)
	local arr_name		= arr_data.arr_name or {""}
	local arr_area_btn	= arr_data.arr_area_btn or {0, 0}
	local arr_area		= arr_data.arr_area or {0, 0}
	local arr_size		= arr_data.arr_size or {0, 0}
	local system_name	= arr_data.system_name or "UI_tab_"..math.random(1, 10000)
	
	local cpt_pages = GML_UI_CreateCompent(form, PAGE_TYPE, system_name, arr_size[1], arr_size[2], arr_area[1], arr_area[2])
	GML_UI_SetPageButton(cpt_pages, PAGE_BUTTON_CUSTOM, 0, 0)
	
	local arr_cpt_pages = {}
	local count_cpt_pages = #arr_name
	for i = 1, count_cpt_pages do
		local cpt_page = GML_UI_CreatePageItem(cpt_pages)
		
		local btn = GML_UI_GetPageItemObj(cpt_page, PAGE_ITEM_TITLE)
		
		local btn_pos_bg_x = 0
		
		if i == count_cpt_pages then
			btn_pos_bg_x = 132
		elseif i > 1 and i < count_cpt_pages then
			btn_pos_bg_x = 66
		end
		
		GML_UI_LoadImage(btn, "texture/ui_morgan/buttons.png", PAGE_ITEM_TITLE_NORMAL, 66, 17, btn_pos_bg_x, 358)
		GML_UI_LoadImage(btn, "texture/ui_morgan/buttons.png", PAGE_ITEM_TITLE_ACTIVE, 66, 17, btn_pos_bg_x, 375)
		GML_UI_SetPos(btn, arr_area_btn[1] + ((i - 1) * 66), arr_area_btn[2])
		GML_UI_SetSize(btn, 66, 17)
		
		L_Text(form, {
			--system_name	= "f_chabuy_lot_"..id_cell,
			arr_size	= {66, 17},
			arr_area	= {arr_area[1] + arr_area_btn[1] + ((i - 1) * 66), arr_area[2] + arr_area_btn[2] + 3},
			hint		= "",
			
			arr_text	= {
				text			= arr_name[i],
				font			= FONT14,
				color			= COLOR_GRAY3,
				shadow		= FALSE,
				--shadow_color	= COLOR_WHITE,
				center		= 1,
				--right	= 1,
			}
		})
		
		arr_cpt_pages[i] = cpt_page
	end
	
	return arr_cpt_pages
end


------
--  
------

function L_StaticBtn(form, arr_data)

	local btn_system_name	= arr_data.system_name
	local btn_text			= arr_data.text
	local btn_count_simbol	= L_countCharacters(btn_text)
	local btn_area_x		= arr_data.arr_area[1]
	local btn_area_y		= arr_data.arr_area[2]
	local btn_hint			= arr_data.hint or ""
	local btn_code			= arr_data.code or BUTTON_YES
	local text_system_name	= arr_data.text_system_name or btn_system_name.."__text"
	local modal_result		= arr_data.modal_result or 1
	
	local btn_size	= arr_data.size or {67, 17}
	local btn_path	= arr_data.bg_path or "texture/ui_morgan/buttons.png"

	
	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, btn_system_name, btn_size[1], btn_size[2], btn_area_x, btn_area_y)
	GML_UI_LoadButtonImage(btn, btn_path, btn_size[1], btn_size[2], 0, 0, TRUE)
	if modal_result == 1 then
		GML_UI_SetButtonModalResult(btn, btn_code)
	end
	
	local title = GML_UI_CreateCompent(form, LABELEX_TYPE, text_system_name, btn_size[1], btn_size[2], btn_area_x, btn_area_y + 2)
	GML_UI_SetCaption(title, btn_text)
	GML_UI_SetTextColor(title, COLOR_WHITE)
	GML_UI_SetLabelExFont(title, DEFAULT_FONT, FALSE, COLOR_WHITE)
	GML_UI_SetIsCenter(title, 1)
	if (btn_hint ~= "") then
		GML_UI_SetHint(btn , btn_hint)
	end
	
	if arr_data.link then
		GML_UI_AddButtonLink(btn, arr_data.link)
	end
	
	return btn
end

function L_btn(form, arr_data)
	local system_name		= arr_data.system_name or "UI_btn_"..math.random(1, 10000)
	local width				= arr_data.width or 67	-- max: 200
	local arr_area			= arr_data.arr_area or {0, 0}
	local action_id			= arr_data.action_id or nil
	
	local text				= arr_data.text or ""
	local text_system_name	= arr_data.text_system_name or "UI_txt_"..math.random(1, 10000)
	
	local hint				= arr_data.hint or ""
	
	local btn = GML_UI_CreateCompent(form, BUTTON_TYPE, system_name, width, 17, arr_area[1], arr_area[2])
	GML_UI_LoadButtonImage(btn, "texture/ui_morgan/buttons.png", width, 17, 0, 0, TRUE)
	if action_id then
		GML_UI_SetButtonModalResult(btn, action_id)
	end
	
	if (hint ~= "") then
		GML_UI_SetHint(btn , hint)
	end
	
	local title = GML_UI_CreateCompent(form, LABELEX_TYPE, text_system_name, width - 8, 17, arr_area[1] + 4, arr_area[2] + 2)
	GML_UI_SetCaption(title, text)
	GML_UI_SetTextColor(title, COLOR_WHITE)
	GML_UI_SetLabelExFont(title, DEFAULT_FONT, FALSE, COLOR_WHITE)
	GML_UI_SetIsCenter(title, 1)

	return btn
end

function L_countCharacters(s)
	local count = 0
	local isSpace = false
	for i = 1, string.len(s) do
		local c = string.byte(s, i)
		if c ~= 92 and c ~= 32 or isSpace then
			count = count + 1
			isSpace = false
		end
		if c == 32 then
			isSpace = true
		end
	end
	return count
end

------
--    2
------
function L_DrawButton2(formObject, code, xpos, ypos, btnName, center)
	local buttons = {
		--  , -    ( )
		["yes"]			= {lstr(328), 2},		-- 
		["yes2"]		= {lstr(329), 2},		-- 
		["no"]			= {lstr(330), 6},		-- 
		["no2"]			= {lstr(331), 6},		-- 
		["ok"]			= {lstr(332), 2},		-- 
		["cancel"]		= {lstr(333), 6},		-- 
		["btnUpgrade"]	= {lstr(334), 6},		-- 
		["btnClose2"]	= {lstr(335), 6},		-- 
		["stock"]		= {lstr(336), 5},		-- 
	}
	
	local btn = GML_UI_CreateCompent( formObject, BUTTON_TYPE, btnName, 67, 17, xpos, ypos )
	GML_UI_LoadButtonImage( btn, "texture/ui_morgan/buttons.png", 67, 17, 0, 0, TRUE )
	if code == "yes" or code == "yes2" then
		GML_UI_SetButtonModalResult( btn, BUTTON_YES ) 
	elseif code == "no" or code == "exit" then
		GML_UI_SetButtonModalResult( btn, BUTTON_CLOSE )
	end
	
	local count_simbol	= buttons[code][2]
	--local widt_text		= GML_GetTextWidthPx(buttons[code][1], LABELEX_TYPE)
	--local padding_left	= math.floor((67 - widt_text) / 2)
	local labTitle = GML_UI_CreateCompent(formObject, LABELEX_TYPE, "labTitle", 67, 15, xpos, ypos + 2)
	GML_UI_SetCaption( labTitle, buttons[code][1])
	GML_UI_SetTextColor( labTitle, COLOR_WHITE )
	GML_UI_SetLabelExFont(labTitle, DEFAULT_FONT, FALSE, COLOR_WHITE)
	GML_UI_SetIsCenter(labTitle, 1)
	if center then
		GML_UI_SetAlign(btn, 11)
		GML_UI_SetAlign(labTitle, 11)
	end
	return btn
end

------
--   
------
function L_DrawPages(formObject, xpos, ypos, listName)
	imgBack333 = GML_UI_CreateCompent( formObject, IMAGE_TYPE, "imgBack333", 38, 17, xpos + 18, ypos - 2 )
	GML_UI_LoadImage( imgBack333, "texture/ui/buttons.tga", NORMAL, 38, 17, 270, 391 )
	
	btnLeftPage = GML_UI_CreateCompent( formObject, BUTTON_TYPE, "btnLeftPage", 14, 13, xpos, ypos )
	GML_UI_LoadButtonImage( btnLeftPage, "texture/ui/buttons.tga", 14, 13, 270, 104, TRUE )
	
	labListPage = GML_UI_CreateCompent( formObject, LABELEX_TYPE, "labListPage", 67, 17, xpos + 28, ypos + 1 )
	GML_UI_SetCaption( labListPage, "")
	GML_UI_SetTextColor( labListPage, COLOR_WHITE )

	btnRightPage = GML_UI_CreateCompent( formObject, BUTTON_TYPE, "btnRightPage", 14, 13, xpos + 60, ypos )
	GML_UI_LoadButtonImage( btnRightPage, "texture/ui/buttons.tga", 14, 13, 270, 117, TRUE )
end



-----------------------------------------------------------------------
-- 
-----------------------------------------------------------------------

function GenFormStock()
	-- 
	local form = L_SetForm({
		system_name	= "frmStock",				--   
		arr_size	= {413, 410},				--   
		text_title	= lstr(141),	--  
	})
	
	--    
	L_SetFormItems(form, {
		system_name	= "grdStockBag",			--   
		arr_area	= {11, 53},					--   
		arr_items	= {
			col = 10,							--  ,
			row = 8								--  
		},
	})
	
	local counter = 0
	for i = 1, 8 do
		for i2 = 1, 10 do
			local cmpt = GML_UI_CreateCompent(form, COMMAND_ONE_TYPE, "grd_lock_"..(counter), 38, 38, 11 + (39 * (i2 - 1)), 53 + (39 * (i - 1)))
			--GML_UI_SetTag(cmpt, v.tag)
			GML_UI_SetHint(cmpt, lstr(142))
			
			--L_SetItemBG(form, {
			--	arr_size			= {38, 38},
			--	arr_area			= { 11 + (39 * (i2 - 1)), 53 + (39 * (i - 1))},
			--	--arr_bg_second		= "",
			--	arr_bg_first		= {alfa = 0},
			--	arr_bg_second		= {path ="item_bg__lock", alfa = 90},
			--})
			counter = counter + 1
		end
	end
	
	--  " : 0  48"
	L_Text(form, {
		system_name	= "labAllCount",
		arr_size	= {98, 18},
		arr_area	= {11, 32},
		
		--  " "
		hint		= lstr(143),
		
		arr_text	= {
			text			= lstr(144),
			--font			= DEFAULT_FONT,
			--color			= COLOR_WHITE,
			shadow		= FALSE,
			--shadow_color	= COLOR_WHITE,
			--center		= 1,
		}
	})
	
	--  
	L_RowText(
		form, 
		"labPage", 
		1,																-- type (gold)
		lstr(145),	-- hint ( )
		{39, 18},														-- : width, height
		{187, 378}														--  : xpos, ypos
	)
	
	local btnLeftPage = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnLeftPage", 16, 16, 171, 379)
	GML_UI_LoadButtonImage(btnLeftPage, "texture/ui_morgan/buttons.png", 16, 16, 0, 109, TRUE )
	
	local btnRightPage = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnRightPage", 16, 16, 226, 379)
	GML_UI_LoadButtonImage(btnRightPage, "texture/ui_morgan/buttons.png", 16, 16, 0, 125, TRUE )
	
	--   
	L_RowText(
		form, 
		"labGoldCount", 
		2,																-- type (gold)
		"",	-- hint (  )
		{150, 18},														-- : width, height
		{252, 378}														--  : xpos, ypos
	)
	
	local btnStockMinusGold = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnStockMinusGold", 14, 14, 386, 380)
	GML_UI_LoadButtonImage(btnStockMinusGold, "texture/ui_morgan/buttons.png", 14, 14, 0, 169, TRUE )
	GML_UI_SetHint(btnStockMinusGold, lstr(146))
	
	local btnStockPlusGold = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnStockPlusGold", 14, 14, 370, 380)
	GML_UI_LoadButtonImage(btnStockPlusGold, "texture/ui_morgan/buttons.png", 14, 14, 0, 155, TRUE )
	GML_UI_SetHint(btnStockPlusGold, lstr(147))
	
	--  
	L_OldRowInput(
		form, 
		"inpStockSearch", 
		1,																-- type (1 --   )
		16,																--   
		"",																-- hint
		{150, 18},														-- : width, height
		{11, 378}														--  : xpos, ypos
	)
	
	
	local btnStockSearchCancle = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnStockSearchCancle", 14, 14, 130, 380)
	GML_UI_LoadButtonImage(btnStockSearchCancle, "texture/ui_morgan/buttons.png", 14, 14, 0, 141, TRUE )
	GML_UI_SetHint(btnStockSearchCancle, lstr(148))
	
	local btnStockSearch = GML_UI_CreateCompent(form, BUTTON_TYPE, "btnStockSearch", 14, 14, 145, 380)
	GML_UI_LoadButtonImage(btnStockSearch, "texture/ui_morgan/buttons.png", 14, 14, 0, 183, TRUE )
	GML_UI_SetHint(btnStockSearch, lstr(149))
	
	--------------------  ----------------------
	local frmStockEditGold = GML_UI_CreateForm( "frmStockEditGold",  FALSE, 197, 113, 397, 500, FALSE, FALSE )
	GML_UI_LoadFormImage( frmStockEditGold, "texture/ui_morgan/pop_up_1.png", 197, 113, 0, 0, "", 0, 0 )
	GML_UI_ShowForm( frmStockEditGold, FALSE )
	GML_UI_AddFormToTemplete( frmStockEditGold, FORM_DIALOG )
	GML_UI_SetFormStyle( frmStockEditGold, 0 )
	GML_UI_SetIsDrag( frmStockEditGold, TRUE )
	
	
	-- 
	local labInfo = GML_UI_CreateCompent( frmStockEditGold, LABELEX_TYPE, "labInfo", 400, 150, 10, 7 )
	GML_UI_SetCaption( labInfo, lstr(150) )
	GML_UI_SetTextColor( labInfo, COLOR_WHITE )
	
	local txtStockTtitle = GML_UI_CreateCompent(frmStockEditGold, LABELEX_TYPE, "labAllCount", 92, 12, 52, 32)
	GML_UI_SetCaption(txtStockTtitle, lstr(151))
	GML_UI_SetTextColor(txtStockTtitle, COLOR_WHITE)
	
	--  
	L_OldRowInput(
		frmStockEditGold, 
		"inpStockEditGold", 
		2,																-- type (2 --    )
		10,																--   
		"",																-- hint
		{157, 18},														-- : width, height
		{20, 48}														--  : xpos, ypos
	)
	
	-- 
	local btnYes = L_DrawButton2(frmStockEditGold, "yes", 19, 76, "btnYes")
	GML_UI_FormSetEnterButton(frmStockEditGold, btnYes)
	
	-- 
	local btnNo = L_DrawButton2(frmStockEditGold, "no", 109, 76, "btnNo")
	L_BtnClose(frmStockEditGold, 197)
end
GenFormStock()

function GenFormAlert(arr_data)
	local arr_line_text		= arr_data.arr_line_text
	local system_name		= arr_data.system_name
	
	local text_width	= 0
	for i = 1, #arr_line_text do
		local line_width = GML_GetTextWidthPx(arr_line_text[i], LABELEX_TYPE)
		if line_width > text_width then
			text_width = line_width
		end
	end
	
	
	local text			= arr_line_text[1]
	
	local form_width	= text_width + 30 + 20
	local form_height	= (12 * #arr_line_text) + 17 + 22 + 20 + 20 + 10
	
	local form = L_SetForm({
		system_name	= system_name,
		arr_size	= {form_width, form_height},
		arr_area	= {397, 500},
		text_title	= lstr(152)
	})
	
	GML_UI_ShowForm(form, FALSE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_SetFormStyle(form, 0)
	
	
	-- 
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 32}, arr_size = {form_width - 20, (12 * #arr_line_text) + 20}
	})
	
	for i = 1, #arr_line_text do
		-- 
		L_Text(form, {
			--system_name	= "labPrice",
			arr_size	= {form_width, 12},
			arr_area	= {0, 42 + (12 * (i - 1))},
			--hint		= "",
			
			arr_text	= {
				text			= arr_line_text[i],
				--font			= ITEMS_NAME,
				color			= COLOR_WHITE,
				shadow			= FALSE,
				--shadow_color	= COLOR_WHITE,
				center		= 1,
				--right			= 1,
			}
		})
	end

	
	-- 
	L_DrawButton2(form, "yes2", math.ceil((form_width / 2) - 67 - 5), form_height - 17 - 10, "btnYes")
	
	-- 
	L_DrawButton2(form, "no2", math.ceil((form_width / 2) + 5), form_height - 17 - 10, "btnNo")
end


function GenFormAlert2(arr_line_text)
	local arr_line_text = arr_line_text or {"", ""}
	
	local text_width = 0
	for i = 1, #arr_line_text do
		local line_width = GML_GetTextWidthPx(arr_line_text[i], LABELEX_TYPE)
		if line_width > text_width then
			text_width = line_width
		end
	end
	
	local text = arr_line_text[1]
	
	local form_width = text_width + 30 + 20
	local form_height = (12 * #arr_line_text) + 17 + 22 + 20 + 20 + 10
	
	local form = L_SetForm({
		system_name = "f_error_alert",
		arr_size = {form_width, form_height},
		arr_area = {397, 500},
		text_title = lstr(155)
	})
	
	
	GML_UI_ShowForm(form, FALSE)
	GML_UI_AddFormToTemplete(form, FORM_MAIN)
	GML_UI_SetFormStyle(form, 0)
	--GML_UI_FormSetHotKey(form, ALT_KEY, HOTKEY_O)
	
	-- 
	L_CreateBG({
		form_name = form, arr_pos_area = {10, 32}, arr_size = {form_width - 20, (12 * #arr_line_text) + 20}
	})
	
	
	for i = 1, #arr_line_text do
	--GML_MsgBox(arr_line_text[i])
		-- 
		L_Text(form, {
			arr_size = {form_width, 12},
			arr_area = {0, 42 + (12 * (i - 1))},
			arr_text = {
				text = arr_line_text[i],
				color = COLOR_WHITE,
				shadow = FALSE,
				center = 1,
			}
		})
	end
	
	-- 
	local btn = L_DrawButton2(form, "yes", math.ceil((form_width / 2) - (67 / 2)), form_height - 17 - 10, "btnYes")
	
	GML_UI_FormSetEnterButton(form, btn)
end
GenFormAlert2()